/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.client.gui.config;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.client.gui.config.widgets.InternalConfigButton;
import com.hypherionmc.craterlib.client.gui.config.widgets.Option;
import com.hypherionmc.craterlib.client.gui.config.widgets.SubConfigWidget;
import com.hypherionmc.craterlib.client.gui.config.widgets.TextConfigOption;
import com.hypherionmc.craterlib.client.gui.config.widgets.ToggleButton;
import com.hypherionmc.craterlib.core.config.ModuleConfig;
import com.hypherionmc.craterlib.core.config.annotations.HideFromScreen;
import com.hypherionmc.craterlib.core.config.annotations.SubConfig;
import com.hypherionmc.craterlib.core.config.annotations.Tooltip;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import shadow.hypherionmc.moonconfig.core.conversion.SpecComment;

public class CraterConfigScreen
extends Screen {
    public static final float SCROLLBAR_BOTTOM_COLOR = 0.5f;
    public static final float SCROLLBAR_TOP_COLOR = 0.67f;
    private static final int TOP = 26;
    private static final int BOTTOM = 24;
    private final Screen parent;
    private final List<Option<?>> options = new ArrayList();
    private final ModuleConfig config;
    public double scrollerAmount;
    private boolean dragging;

    public CraterConfigScreen(ModuleConfig config, Screen parent, Object subConfig) {
        super((Component)Component.m_237115_((String)("cl." + config.getClass().getSimpleName().toLowerCase() + ".title")));
        this.parent = parent;
        this.config = config;
        if (subConfig != null) {
            this.setupScreenFromConfig(subConfig, subConfig.getClass());
        } else {
            this.setupScreenFromConfig(config, config.getClass());
        }
    }

    public CraterConfigScreen(ModuleConfig config, Screen parent) {
        this(config, parent, null);
    }

    private static Component toText(Enum<?> val) {
        return Component.m_237115_((String)val.toString());
    }

    private static Component toText(Boolean bool) {
        return Component.m_237115_((String)bool.toString());
    }

    private void setupScreenFromConfig(Object object, Class<?> clazz) {
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                int fieldModifiers = field.getModifiers();
                if (object == null || Modifier.isStatic(fieldModifiers) || Modifier.isTransient(fieldModifiers)) continue;
                try {
                    String[] tooltipLang;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if (field.isAnnotationPresent(HideFromScreen.class)) {
                        return;
                    }
                    Object val = field.get(object);
                    String baseLangKey = "cl." + clazz.getSimpleName().toLowerCase() + "." + field.getName().toLowerCase();
                    if (field.isAnnotationPresent(SpecComment.class)) {
                        String[] stringArray = new String[1];
                        v1 = stringArray;
                        stringArray[0] = field.getAnnotation(SpecComment.class).value();
                    } else {
                        v1 = tooltipLang = new String[]{};
                    }
                    if (field.isAnnotationPresent(Tooltip.class)) {
                        tooltipLang = field.getAnnotation(Tooltip.class).value();
                    }
                    this.add((Component)Component.m_237115_((String)baseLangKey), val, () -> val, ret -> {
                        try {
                            field.set(object, ret);
                            this.config.saveConfig(this.config);
                        }
                        catch (IllegalAccessException e) {
                            CraterConstants.LOG.error("Failed to update value for field {} in config {}", new Object[]{field.getName(), this.config.getConfigName(), e});
                        }
                    }, field.isAnnotationPresent(SubConfig.class), tooltipLang);
                }
                catch (IllegalAccessException e) {
                    CraterConstants.LOG.error("Failed to access value for field {} in config {}", new Object[]{field.getName(), this.config.getConfigName(), e});
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public <T> void add(Component text, T value, @Nullable Supplier<T> defaultValue, Consumer<T> savingConsumer, boolean isSubConfig, String ... langKeys) {
        Option<?> option = this.createOption(value, isSubConfig);
        option.text = text;
        option.defaultValue = defaultValue;
        option.savingConsumer = savingConsumer;
        option.originalValue = value;
        option.value = value;
        option.setLangKeys(List.of(langKeys));
        this.options.add(option);
        option.onAdd();
    }

    private <T> Option<?> createOption(T value, boolean isSubConfig) {
        if (value instanceof Enum) {
            ?[] objects = value.getClass().getEnumConstants();
            return new ToggleButton<Enum>(Arrays.asList(objects), CraterConfigScreen::toText);
        }
        if (value instanceof Boolean) {
            return new ToggleButton<Boolean>(Arrays.asList(Boolean.TRUE, Boolean.FALSE), CraterConfigScreen::toText);
        }
        if (value instanceof String) {
            return new TextConfigOption(Function.identity(), Function.identity());
        }
        if (value instanceof Integer) {
            return new TextConfigOption<Integer>(Objects::toString, Integer::valueOf);
        }
        if (value instanceof Long) {
            return new TextConfigOption<Long>(Objects::toString, Long::valueOf);
        }
        if (value instanceof Double) {
            return new TextConfigOption<Double>(Objects::toString, Double::valueOf);
        }
        if (value instanceof Float) {
            return new TextConfigOption<Float>(Objects::toString, Float::valueOf);
        }
        if (value instanceof BigInteger) {
            return new TextConfigOption<BigInteger>(Objects::toString, BigInteger::new);
        }
        if (value instanceof BigDecimal) {
            return new TextConfigOption<BigDecimal>(Objects::toString, BigDecimal::new);
        }
        if (value instanceof ResourceLocation) {
            return new TextConfigOption<ResourceLocation>(Objects::toString, ResourceLocation::new);
        }
        if (isSubConfig) {
            return new SubConfigWidget(this.config, this, value);
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_6702_().addAll(this.options);
        int buttonWidths = Math.min(200, (this.f_96543_ - 50 - 12) / 3);
        this.m_142416_((GuiEventListener)new InternalConfigButton(this, this.f_96543_ / 2 - buttonWidths - 3, this.f_96544_ - 22, buttonWidths, 20, (Component)Component.m_237119_(), true));
        this.m_142416_((GuiEventListener)new InternalConfigButton(this, this.f_96543_ / 2 + 3, this.f_96544_ - 22, buttonWidths, 20, (Component)Component.m_237119_(), false));
    }

    public void m_88315_(@NotNull GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.overlayBackground(matrices.m_280168_(), 26, this.f_96544_ - 24, 32);
        this.renderScrollBar();
        matrices.m_280168_().m_85836_();
        matrices.m_280168_().m_85837_(0.0, 0.0, 500.0);
        this.overlayBackground(matrices.m_280168_(), 0, 26, 64);
        this.overlayBackground(matrices.m_280168_(), this.f_96544_ - 24, this.f_96544_, 64);
        this.renderShadow(matrices.m_280168_());
        matrices.m_280653_(this.f_96547_, this.m_96636_(), this.f_96543_ / 2, 9, 0xFFFFFF);
        super.m_88315_(matrices, mouseX, mouseY, delta);
        matrices.m_280168_().m_85849_();
        int y = (int)(30L - Math.round(this.scrollerAmount));
        for (Option<?> option : this.options) {
            int height1 = option.height();
            option.render(this.f_96541_, this.f_96547_, 40, y, this.f_96543_ - 80, height1, matrices, mouseX, mouseY, delta);
            this.renderConfigTooltip(matrices, this.f_96547_, mouseX, mouseY, 40, y, this.f_96547_.m_92852_((FormattedText)option.text), height1, option.text.getString(), option.getLangKeys().toArray(new String[0]));
            y += height1;
        }
    }

    private void renderScrollBar() {
        int listHeight = this.f_96544_ - 24 - 26;
        int totalHeight = this.totalHeight();
        if (totalHeight > listHeight) {
            int maxScroll = Math.max(0, totalHeight - listHeight);
            int height = listHeight * listHeight / totalHeight;
            height = Mth.m_14045_((int)height, (int)32, (int)listHeight);
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scrollerAmount * (listHeight - height) / maxScroll + 26, 26), this.f_96544_ - 24 - height);
            int scrollbarPositionMaxX = this.f_96543_;
            int scrollbarPositionMinX = scrollbarPositionMaxX - 6;
            int maxY = this.f_96544_ - 24;
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_5483_((double)scrollbarPositionMinX, (double)maxY, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMaxX, (double)maxY, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMaxX, 26.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, 26.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)(minY + height), 0.0).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMaxX, (double)minY, 0.0).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)minY, 0.0).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).m_85950_(0.67f, 0.67f, 0.67f, 1.0f).m_5752_();
            buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).m_85950_(0.67f, 0.67f, 0.67f, 1.0f).m_5752_();
            buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).m_85950_(0.67f, 0.67f, 0.67f, 1.0f).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)minY, 0.0).m_85950_(0.67f, 0.67f, 0.67f, 1.0f).m_5752_();
            tesselator.m_85914_();
            RenderSystem.disableBlend();
        }
    }

    private void renderShadow(PoseStack matrices) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.setShader(GameRenderer::m_172820_);
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, 30.0f, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)this.f_96543_, 30.0f, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)this.f_96543_, 26.0f, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 185).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 26.0f, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 185).m_5752_();
        buffer.m_252986_(matrix, 0.0f, (float)(this.f_96544_ - 24), 0.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 185).m_5752_();
        buffer.m_252986_(matrix, (float)this.f_96543_, (float)(this.f_96544_ - 24), 0.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 185).m_5752_();
        buffer.m_252986_(matrix, (float)this.f_96543_, (float)(this.f_96544_ - 24 - 4), 0.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, 0.0f, (float)(this.f_96544_ - 24 - 4), 0.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    protected void overlayBackground(PoseStack matrices, int h1, int h2, int color) {
        this.overlayBackground(matrices.m_85850_().m_252922_(), 0, h1, this.f_96543_, h2, color, color, color, 255, 255);
    }

    protected void overlayBackground(Matrix4f matrix, int minX, int minY, int maxX, int maxY, int red, int green, int blue, int startAlpha, int endAlpha) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.f_279548_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172820_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, (float)minX, (float)maxY, 0.0f).m_7421_((float)minX / 32.0f, (float)maxY / 32.0f).m_6122_(red, green, blue, endAlpha).m_5752_();
        buffer.m_252986_(matrix, (float)maxX, (float)maxY, 0.0f).m_7421_((float)maxX / 32.0f, (float)maxY / 32.0f).m_6122_(red, green, blue, endAlpha).m_5752_();
        buffer.m_252986_(matrix, (float)maxX, (float)minY, 0.0f).m_7421_((float)maxX / 32.0f, (float)minY / 32.0f).m_6122_(red, green, blue, startAlpha).m_5752_();
        buffer.m_252986_(matrix, (float)minX, (float)minY, 0.0f).m_7421_((float)minX / 32.0f, (float)minY / 32.0f).m_6122_(red, green, blue, startAlpha).m_5752_();
        tesselator.m_85914_();
    }

    public int scrollHeight() {
        int listHeight;
        int totalHeight = this.totalHeight();
        if (totalHeight <= (listHeight = this.f_96544_ - 24 - 26)) {
            return 0;
        }
        return totalHeight - listHeight;
    }

    public int totalHeight() {
        int i = 8;
        for (Option<?> option : this.options) {
            i += option.height();
        }
        return i;
    }

    public boolean hasErrors() {
        for (Option<?> option : this.options) {
            if (!option.hasErrors) continue;
            return true;
        }
        return false;
    }

    public boolean isEdited() {
        for (Option<?> option : this.options) {
            if (!option.isEdited()) continue;
            return true;
        }
        return false;
    }

    public void save() {
        for (Option<?> option : this.options) {
            option.save();
            option.originalValue = option.value;
        }
    }

    public void m_7379_() {
        if (this.isEdited()) {
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(this::acceptConfirm, (Component)Component.m_237115_((String)"t.clc.quit_config"), (Component)Component.m_237115_((String)"t.clc.quit_config_sure"), (Component)Component.m_237115_((String)"t.clc.quit_discard"), (Component)Component.m_237115_((String)"gui.cancel")));
        } else {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_6050_(double d, double e, double f) {
        if (e >= 26.0 && e <= (double)(this.f_96544_ - 24)) {
            this.scrollerAmount = Mth.m_14008_((double)(this.scrollerAmount - f * 16.0), (double)0.0, (double)this.scrollHeight());
            return true;
        }
        return super.m_6050_(d, e, f);
    }

    public boolean m_6375_(double d, double e, int i) {
        this.dragging = i == 0 && d >= (double)(this.f_96543_ - 6) && d < (double)this.f_96543_;
        return super.m_6375_(d, e, i) || this.dragging;
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (super.m_7979_(d, e, i, f, g)) {
            return true;
        }
        if (i != 0 || !this.dragging) {
            return false;
        }
        if (e < 26.0) {
            this.scrollerAmount = 0.0;
        } else if (e > (double)(this.f_96544_ - 24)) {
            this.scrollerAmount = this.scrollHeight();
        } else {
            double h = Math.max(1, this.scrollHeight());
            int j = this.f_96544_ - 24 - 26;
            int k = Mth.m_14045_((int)((int)((float)(j * j) / (float)this.scrollHeight())), (int)32, (int)(j - 8));
            double l = Math.max(1.0, h / (double)(j - k));
            this.scrollerAmount = Mth.m_14008_((double)(this.scrollerAmount + g * l), (double)0.0, (double)this.scrollHeight());
        }
        return true;
    }

    private void acceptConfirm(boolean t) {
        if (!t) {
            this.f_96541_.m_91152_((Screen)this);
        } else {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void renderConfigTooltip(GuiGraphics stack, Font font, int mouseX, int mouseY, int startX, int startY, int sizeX, int sizeY, String title, String ... description) {
        if (mouseX > startX && mouseX < startX + sizeX && mouseY > startY && mouseY < startY + sizeY) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)(ChatFormatting.BOLD + ChatFormatting.YELLOW + title)));
            for (String desc : description) {
                list.add(Component.m_237115_((String)desc));
            }
            stack.m_280666_(font, list, mouseX, mouseY);
        }
    }
}

