/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config.conditions;

import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.config.conditions.ConditionInBiome;
import uk.co.dotcode.asb.config.conditions.ConditionInDimension;
import uk.co.dotcode.asb.config.conditions.ConditionInLava;
import uk.co.dotcode.asb.config.conditions.ConditionInRain;
import uk.co.dotcode.asb.config.conditions.ConditionInWater;
import uk.co.dotcode.asb.config.conditions.ConditionMoonPhase;
import uk.co.dotcode.asb.config.conditions.ConditionOnBlock;
import uk.co.dotcode.asb.config.conditions.ConditionTimeRange;
import uk.co.dotcode.asb.config.conditions.ConditionUsingMainHand;
import uk.co.dotcode.asb.config.conditions.ConditionUsingOffHand;

public class TriggerCondition {
    public String type;
    public String extra;
    public String tooltipDescription;
    public boolean inverted = false;
    protected transient String description = "NULL";

    public TriggerCondition() {
    }

    public TriggerCondition(String type, boolean inverted) {
        this.type = type;
        this.inverted = inverted;
    }

    public TriggerCondition parse() {
        String toParse;
        switch (toParse = this.type.toLowerCase()) {
            case "inwater": {
                return new ConditionInWater(this.inverted);
            }
            case "inlava": {
                return new ConditionInLava(this.inverted);
            }
            case "inrain": {
                return new ConditionInRain(this.inverted);
            }
            case "onblock": {
                return new ConditionOnBlock(this.extra.toLowerCase(), this.inverted);
            }
            case "isusingmainhand": {
                return new ConditionUsingMainHand(this.inverted);
            }
            case "isusingoffhand": {
                return new ConditionUsingOffHand(this.inverted);
            }
            case "inbiome": {
                return new ConditionInBiome(this.extra.toLowerCase(), this.inverted);
            }
            case "timerange": {
                return new ConditionTimeRange(this.extra.toLowerCase(), this.inverted);
            }
            case "moonphase": {
                return new ConditionMoonPhase(this.extra.toLowerCase(), this.inverted);
            }
            case "indimension": {
                return new ConditionInDimension(this.extra.toLowerCase(), this.inverted);
            }
        }
        return null;
    }

    public boolean conditionMet(LivingEntity e) {
        return this.parse().conditionMet(e);
    }

    public boolean isValid() {
        if (this.type == null || this.type == "") {
            ModLogger.warn("Invalid bonus condition: " + this.type + ". The specified condition type does not exist.");
            return false;
        }
        return true;
    }

    public MutableComponent translationText() {
        return this.parse().translationText();
    }
}

