/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config.conditions;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import uk.co.dotcode.asb.ComponentManager;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.config.conditions.TriggerCondition;

public class ConditionTimeRange
extends TriggerCondition {
    private transient int timeStart = 0;
    private transient int timeEnd = 0;
    private transient MutableComponent component = null;

    public ConditionTimeRange(String timeRange, boolean inverted) {
        super("timeRange", inverted);
        this.extra = timeRange;
        this.timeStart = Integer.parseInt(this.extra.split(",")[0]);
        this.timeEnd = Integer.parseInt(this.extra.split(",")[1]);
    }

    @Override
    public boolean conditionMet(LivingEntity e) {
        boolean result = false;
        float dayTime = e.m_9236_().m_46468_() % 24000L;
        if ((float)this.timeStart <= dayTime && dayTime <= (float)this.timeEnd) {
            result = true;
        }
        return this.inverted ? !result : result;
    }

    @Override
    public boolean isValid() {
        if (this.extra == null || this.extra.isEmpty() || !this.extra.contains(",")) {
            ModLogger.warn("Invalid bonus condition: timeRange," + this.extra + ". The 'extra' field has not been defined correctly (it must be a tick range - example: '0,10000').");
            return false;
        }
        return super.isValid();
    }

    @Override
    public MutableComponent translationText() {
        if (this.component == null) {
            if (this.tooltipDescription != null && !this.tooltipDescription.isEmpty()) {
                return ComponentManager.createComponent(this.tooltipDescription, true);
            }
            this.component = this.inverted ? ComponentManager.mergeComponents(new Component[]{ComponentManager.not, ComponentManager.space}) : ComponentManager.empty;
            this.component = ComponentManager.mergeComponents(new Component[]{this.component, ComponentManager.timeRangePrefix, ComponentManager.space, ComponentManager.createComponent(Integer.toString(this.timeStart), false), ComponentManager.space, ComponentManager.dash, ComponentManager.createComponent(Integer.toString(this.timeEnd), false)});
        }
        return this.component;
    }
}

