/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import uk.co.dotcode.asb.ComponentManager;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.ModUtils;
import uk.co.dotcode.asb.config.AdditionalSetPiece;

public class EnchantmentCondition {
    public boolean shouldHave = true;
    public String enchantmentKey;
    public Integer minLevel;
    public Integer maxLevel;
    private transient String enchantmentText = "";
    private transient String levelText = "";

    public boolean verify(String armorSetName, String slotType) {
        boolean valid = true;
        if (this.enchantmentKey == null || this.enchantmentKey.isEmpty() || !ModUtils.checkEnchantmentKey(this.enchantmentKey)) {
            ModLogger.warn("Failed to add custom armorset: " + armorSetName + ". The " + slotType + " enchantmentKey is invalid: " + this.enchantmentKey);
            valid = false;
        }
        return valid;
    }

    public MutableComponent getEnchantmentTooltipText(int armorSlot, Player player, String itemKey) {
        if (this.enchantmentText.isEmpty()) {
            Enchantment tempEnchantment = ModUtils.getEnchantment(this.enchantmentKey);
            this.enchantmentText = tempEnchantment.m_44704_();
        }
        if (this.levelText.isEmpty()) {
            if (this.minLevel != null && this.maxLevel == null) {
                this.levelText = this.minLevel.toString();
            } else if (this.minLevel != null && this.maxLevel != null) {
                this.levelText = " " + this.minLevel + " - " + this.maxLevel;
            }
        }
        MutableComponent extraText = this.shouldHave ? ComponentManager.empty : ComponentManager.mergeComponents(new Component[]{ComponentManager.no, ComponentManager.space});
        MutableComponent tooltipText = ComponentManager.mergeComponents(new Component[]{ComponentManager.space, ComponentManager.space, ComponentManager.dash, extraText, ComponentManager.createComponent(this.enchantmentText, true), ComponentManager.createComponent(this.levelText, false)});
        if (armorSlot == -1) {
            if (this.matches(player.m_21205_())) {
                return ComponentManager.setGreen(tooltipText);
            }
            return ComponentManager.setGray(tooltipText);
        }
        if (armorSlot == -2) {
            if (this.matches(player.m_21206_())) {
                return ComponentManager.setGreen(tooltipText);
            }
            return ComponentManager.setGray(tooltipText);
        }
        if (armorSlot == -3) {
            ItemStack active = new ItemStack((ItemLike)ModUtils.getItem(itemKey));
            if (AdditionalSetPiece.additionalMatchesSpecific(player, itemKey)) {
                return ComponentManager.setGreen(ComponentManager.mergeComponents(new Component[]{ComponentManager.space, ComponentManager.dash, extraText, ComponentManager.createComponent(active.m_41778_(), true)}));
            }
            return ComponentManager.setGray(ComponentManager.mergeComponents(new Component[]{ComponentManager.space, ComponentManager.dash, extraText, ComponentManager.createComponent(active.m_41778_(), true)}));
        }
        if (this.matches(player.m_150109_().m_36052_(armorSlot))) {
            return ComponentManager.setGreen(tooltipText);
        }
        return ComponentManager.setGray(tooltipText);
    }

    public boolean matches(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        boolean flag = false;
        for (Map.Entry entry : enchantments.entrySet()) {
            String currentKey = ModUtils.getRegistryNameEnchantment((Enchantment)entry.getKey()).toString();
            int currentLevel = (Integer)entry.getValue();
            if (this.shouldHave) {
                if (!currentKey.equalsIgnoreCase(this.enchantmentKey)) continue;
                if (this.minLevel != null && this.maxLevel == null) {
                    if (currentLevel != this.minLevel) continue;
                    flag = true;
                    break;
                }
                if (this.minLevel != null && this.maxLevel != null) {
                    if (currentLevel < this.minLevel || currentLevel > this.maxLevel) continue;
                    flag = true;
                    break;
                }
                flag = true;
                break;
            }
            if (currentKey.equalsIgnoreCase(this.enchantmentKey)) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }
}

