/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.config.ArmorSet;
import uk.co.dotcode.asb.config.DefaultArmorSets;

public class ConfigHandler {
    public static File folder;
    public static ArrayList<ArmorSet> localConfigArmorSets;
    public static ArrayList<ArmorSet> serverArmorSets;
    private static int totalLoadedSets;
    private static int numberOfErrors;

    public static void load() {
        File[] fileArray;
        if (!folder.exists()) {
            ModLogger.info("No configs found, creating defaults");
            folder.mkdirs();
            DefaultArmorSets.generateDefaultConfigs(folder);
        }
        if ((fileArray = folder.listFiles()) != null && fileArray.length > 0) {
            Gson gson = new Gson();
            ModLogger.info("Loading armor sets and bonuses");
            for (File f : fileArray) {
                if (f.isDirectory() || !ConfigHandler.isJsonFile(f)) continue;
                ConfigHandler.loadFile(gson, f);
            }
            ModLogger.info("Finished loading a total of " + totalLoadedSets + " armor sets and bonuses with " + numberOfErrors + " errors.");
            serverArmorSets = localConfigArmorSets;
        }
    }

    private static void loadFile(Gson gson, File file) {
        try (FileReader reader = new FileReader(file);){
            ArmorSet as = (ArmorSet)gson.fromJson((Reader)reader, ArmorSet.class);
            ModLogger.info("Loading armor set: " + as.armorSetName);
            if (as.isValid()) {
                localConfigArmorSets.add(as);
                ++totalLoadedSets;
            } else {
                ++numberOfErrors;
            }
        }
        catch (FileNotFoundException e) {
            ModLogger.error("Failed to load armor set (file not found): " + file.getPath());
            e.printStackTrace();
            ++numberOfErrors;
        }
        catch (IOException e) {
            ModLogger.error("Failed to load armor set (IOException): " + file.getPath());
            e.printStackTrace();
            ++numberOfErrors;
        }
    }

    private static boolean isJsonFile(File f) {
        String extension = f.getPath().substring(f.getPath().lastIndexOf("."));
        return extension.equalsIgnoreCase(".json");
    }

    static {
        localConfigArmorSets = new ArrayList();
        serverArmorSets = new ArrayList();
        totalLoadedSets = 0;
        numberOfErrors = 0;
    }
}

