/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import uk.co.dotcode.asb.config.ArmorSet;
import uk.co.dotcode.asb.config.Bonus;
import uk.co.dotcode.asb.config.ConfigHandler;
import uk.co.dotcode.asb.forge.ModUtilsImpl;

public class ModUtils {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Item getItem(String item) {
        return ModUtilsImpl.getItem(item);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Enchantment getEnchantment(String enchantment) {
        return ModUtilsImpl.getEnchantment(enchantment);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getRegistryNameItem(Item item) {
        return ModUtilsImpl.getRegistryNameItem(item);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getRegistryNameEnchantment(Enchantment enchantment) {
        return ModUtilsImpl.getRegistryNameEnchantment(enchantment);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getRegistryNameEffect(MobEffect effect) {
        return ModUtilsImpl.getRegistryNameEffect(effect);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Block getBlock(String block) {
        return ModUtilsImpl.getBlock(block);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Attribute getAttribute(String attribute) {
        return ModUtilsImpl.getAttribute(attribute);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MobEffect getMobEffect(String effect) {
        return ModUtilsImpl.getMobEffect(effect);
    }

    public static boolean checkItemKey(String itemKey) {
        String[] splitLocation = itemKey.split(":");
        if (splitLocation.length == 2) {
            ResourceLocation resourceLocation = new ResourceLocation(splitLocation[0], splitLocation[1]);
            Item item = ModUtils.getItem(resourceLocation.toString());
            return item != null && item != Items.f_41852_;
        }
        return false;
    }

    public static boolean checkEnchantmentKey(String enchantmentKey) {
        String[] splitLocation = enchantmentKey.split(":");
        if (splitLocation.length == 2) {
            ResourceLocation resourceLocation = new ResourceLocation(splitLocation[0], splitLocation[1]);
            Enchantment enchantment = ModUtils.getEnchantment(resourceLocation.toString());
            return enchantment != null;
        }
        return false;
    }

    public static void checkAndApplyBonusesTo(LivingEntity source, LivingEntity target, String interactionType) {
        if (!(source instanceof Animal)) {
            for (int i = 0; i < ConfigHandler.serverArmorSets.size(); ++i) {
                ArmorSet as = ConfigHandler.serverArmorSets.get(i);
                if (as.performanceMode) {
                    if (!(source instanceof Player)) continue;
                    ModUtils.actuallyCheckAndApplyBonuses(as, source, target, interactionType);
                    continue;
                }
                ModUtils.actuallyCheckAndApplyBonuses(as, source, target, interactionType);
            }
        }
    }

    private static void actuallyCheckAndApplyBonuses(ArmorSet as, LivingEntity source, LivingEntity target, String interactionType) {
        block10: {
            if (as.armorSetMatch(source)) {
                for (Bonus b : as.fullSetBonuses) {
                    if (b.conditionsMet(source)) {
                        b.applyBonus(target, interactionType);
                        continue;
                    }
                    b.removeBonus(target, interactionType);
                }
            } else {
                for (Bonus b : as.fullSetBonuses) {
                    b.removeBonus(target, interactionType);
                }
            }
            if (as.partialBonusRequiredAmount == null) break block10;
            if (as.armorSetCount(source) >= as.partialBonusRequiredAmount) {
                for (Bonus b : as.partialSetBonuses) {
                    if (b.conditionsMet(source)) {
                        b.applyBonus(target, interactionType);
                        continue;
                    }
                    b.removeBonus(target, interactionType);
                }
            } else {
                for (Bonus b : as.partialSetBonuses) {
                    b.removeBonus(target, interactionType);
                }
            }
        }
    }

    public static void checkAndApplyImmunitiesTo(LivingEntity source, LivingEntity target) {
        if (!(source instanceof Animal)) {
            for (int i = 0; i < ConfigHandler.serverArmorSets.size(); ++i) {
                ArmorSet as = ConfigHandler.serverArmorSets.get(i);
                if (as.performanceMode) {
                    if (!(source instanceof Player)) continue;
                    ModUtils.actuallyApplyImmunities(as, source, target);
                    continue;
                }
                ModUtils.actuallyApplyImmunities(as, source, target);
            }
        }
    }

    private static void actuallyApplyImmunities(ArmorSet as, LivingEntity source, LivingEntity target) {
        if (as.armorSetMatch(source)) {
            for (Bonus b : as.fullSetBonuses) {
                if (!b.conditionsMet(target)) continue;
                b.applyImmunity(target);
            }
        }
        if (as.partialBonusRequiredAmount != null && as.armorSetCount(source) >= as.partialBonusRequiredAmount) {
            for (Bonus b : as.partialSetBonuses) {
                if (!b.conditionsMet(target)) continue;
                b.applyImmunity(target);
            }
        }
    }

    public static boolean isImmuneToEffect(MobEffectInstance effect, LivingEntity entity) {
        if (!(entity instanceof Animal)) {
            for (int i = 0; i < ConfigHandler.serverArmorSets.size(); ++i) {
                ArmorSet as = ConfigHandler.serverArmorSets.get(i);
                if (!(as.performanceMode ? entity instanceof Player && ModUtils.actuallyCheckIsImmuneToEffect(as, effect, entity) : ModUtils.actuallyCheckIsImmuneToEffect(as, effect, entity))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean actuallyCheckIsImmuneToEffect(ArmorSet as, MobEffectInstance effect, LivingEntity entity) {
        if (as.armorSetMatch(entity)) {
            for (Bonus b : as.fullSetBonuses) {
                if (!b.type.equalsIgnoreCase("effect") || !b.interactionType.equalsIgnoreCase("immunity") || !b.conditionsMet(entity) || b.getBonusEffectInstance().m_19544_() != effect.m_19544_()) continue;
                return true;
            }
        }
        if (as.partialBonusRequiredAmount != null && as.armorSetCount(entity) >= as.partialBonusRequiredAmount) {
            for (Bonus b : as.partialSetBonuses) {
                if (!b.type.equalsIgnoreCase("effect") || !b.interactionType.equalsIgnoreCase("immunity") || !b.conditionsMet(entity) || b.getBonusEffectInstance().m_19544_() != effect.m_19544_()) continue;
                return true;
            }
        }
        return false;
    }

    public static String getSlotLabel(int armorSlot) {
        switch (armorSlot) {
            default: {
                return "error";
            }
            case -1: {
                return "mainhand";
            }
            case -2: {
                return "offhand";
            }
            case 0: {
                return "feet";
            }
            case 1: {
                return "legs";
            }
            case 2: {
                return "chest";
            }
            case 3: 
        }
        return "head";
    }

    public static int convertMoonPhaseToInt(String phase) {
        switch (phase.toLowerCase()) {
            default: {
                return -1;
            }
            case "full": {
                return 0;
            }
            case "waninggibbous": {
                return 1;
            }
            case "lastquarter": {
                return 2;
            }
            case "waningcresent": {
                return 3;
            }
            case "new": {
                return 4;
            }
            case "waxingcresent": {
                return 5;
            }
            case "firstquarter": {
                return 6;
            }
            case "waxinggibbous": 
        }
        return 7;
    }
}

