/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug.ingredients;

import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DebugIngredientHelper
implements IIngredientHelper<DebugIngredient> {
    @Override
    public IIngredientType<DebugIngredient> getIngredientType() {
        return DebugIngredient.TYPE;
    }

    @Override
    public String getDisplayName(DebugIngredient ingredient) {
        return "JEI Debug Item #" + ingredient.getNumber();
    }

    @Override
    public String getUniqueId(DebugIngredient ingredient, UidContext context) {
        return "JEI_debug_" + ingredient.getNumber();
    }

    @Override
    public ResourceLocation getResourceLocation(DebugIngredient ingredient) {
        return new ResourceLocation("jei", "debug_" + ingredient.getNumber());
    }

    @Override
    public ItemStack getCheatItemStack(DebugIngredient ingredient) {
        return ItemStack.f_41583_;
    }

    @Override
    public DebugIngredient copyIngredient(DebugIngredient ingredient) {
        return ingredient.copy();
    }

    @Override
    public String getErrorInfo(@Nullable DebugIngredient ingredient) {
        if (ingredient == null) {
            return "debug ingredient: null";
        }
        return this.getDisplayName(ingredient);
    }
}

