/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipenetwork;

import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidNetworkLocation
extends NetworkLocation {
    private Map<Integer, FluidStack> fluidCache;
    private IFluidHandler handlerCache;

    public FluidNetworkLocation(BlockPos pipePos, Direction direction) {
        super(pipePos, direction);
    }

    public FluidNetworkLocation(CompoundTag nbt) {
        super(nbt);
    }

    public List<Integer> getFluidSlots(Level level, FluidStack fluid) {
        if (this.isEmpty(level)) {
            return Collections.emptyList();
        }
        return this.getFluids(level).entrySet().stream().filter(kv -> ((FluidStack)kv.getValue()).isFluidEqual(fluid) && this.canExtract(level, (Integer)kv.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public int getFluidAmount(Level level, FluidStack fluid) {
        if (this.isEmpty(level)) {
            return 0;
        }
        return this.getFluids(level).entrySet().stream().filter(kv -> ((FluidStack)kv.getValue()).isFluidEqual(fluid) && this.canExtract(level, (Integer)kv.getKey())).mapToInt(kv -> ((FluidStack)kv.getValue()).getAmount()).sum();
    }

    public Map<Integer, FluidStack> getFluids(Level level) {
        IFluidHandler handler;
        if (this.fluidCache == null && (handler = this.getFluidHandler(level)) != null) {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack stack = handler.getFluidInTank(i);
                if (stack.isEmpty()) continue;
                if (this.fluidCache == null) {
                    this.fluidCache = new HashMap<Integer, FluidStack>();
                }
                this.fluidCache.put(i, stack);
            }
        }
        return this.fluidCache;
    }

    public FluidStack getFirstAvailableFluid(Level level) {
        for (Map.Entry<Integer, FluidStack> entry : this.getFluids(level).entrySet()) {
            if (!this.canExtract(level, entry.getKey())) continue;
            return entry.getValue();
        }
        return FluidStack.EMPTY;
    }

    public IFluidHandler getFluidHandler(Level level) {
        if (this.handlerCache == null) {
            PipeNetwork network = PipeNetwork.get((Level)level);
            PipeBlockEntity pipe = network.getPipe(this.pipePos);
            if (!(pipe instanceof FluidPipeBlockEntity)) {
                throw new IllegalArgumentException(String.format("Pipe at %s is not a Fluid Pipe for a FluidNetworkLocation instance. Please report to PrettyPipesFluids issues.", this.pipePos));
            }
            this.handlerCache = ((FluidPipeBlockEntity)pipe).getFluidHandler(this.direction);
        }
        return this.handlerCache;
    }

    public boolean canExtract(Level level, int slot) {
        IFluidHandler handler = this.getFluidHandler(level);
        if (handler == null) {
            return false;
        }
        FluidStack stored = handler.getFluidInTank(slot).copy();
        stored.setAmount(1);
        return !handler.drain(stored, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public boolean isEmpty(Level level) {
        Map<Integer, FluidStack> fluids = this.getFluids(level);
        return fluids == null || fluids.isEmpty();
    }

    public IItemHandler getItemHandler(Level le) {
        throw new UnsupportedOperationException("getItemHandler is unsupported for FluidNetworkLocation");
    }

    public Map<Integer, ItemStack> getItems(Level level) {
        throw new UnsupportedOperationException("getItems is unsupported for FluidNetworkLocation");
    }

    public List<Integer> getStackSlots(Level level, ItemStack stack, ItemEquality ... equalityTypes) {
        throw new UnsupportedOperationException("getStackSlots is unsupported for FluidNetworkLocation");
    }

    public int getItemAmount(Level level, ItemStack stack, ItemEquality ... equalityTypes) {
        throw new UnsupportedOperationException("getItemAmount is unsupported for FluidNetworkLocation");
    }
}

