/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.misc;

import dev.quarris.ppfluids.container.FluidFilterSlot;
import dev.quarris.ppfluids.network.FluidButtonPacket;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import dev.quarris.ppfluids.registry.ItemSetup;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class FluidFilter
extends ItemStackHandler {
    protected ItemStack moduleItem;
    protected FluidPipeBlockEntity pipe;
    public boolean isWhitelist;
    public boolean canPopulateFromTanks;
    public boolean canModifyWhitelist = true;
    private boolean modified;

    public FluidFilter(int size, ItemStack moduleItem, FluidPipeBlockEntity pipe, boolean isDefaultWhitelist) {
        super(size);
        this.pipe = pipe;
        this.moduleItem = moduleItem;
        this.isWhitelist = isDefaultWhitelist;
        this.load();
    }

    public FluidFilter(int size, ItemStack moduleItem, FluidPipeBlockEntity pipe) {
        this(size, moduleItem, pipe, false);
    }

    public List<Slot> createSlots(int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.getSlots(); ++i) {
            slots.add((Slot)new FluidFilterSlot(this, i, x + i % 9 * 18, y + i / 9 * 18));
        }
        return slots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<AbstractWidget> createButtons(Screen gui, int x, int y) {
        ArrayList<AbstractWidget> buttons = new ArrayList<AbstractWidget>();
        if (this.canModifyWhitelist) {
            Supplier<String> whitelistText = () -> "info.prettypipes." + (this.isWhitelist ? "whitelist" : "blacklist");
            buttons.add((AbstractWidget)Button.m_253074_((Component)Component.m_237115_((String)whitelistText.get()), button -> {
                FluidButtonPacket.sendAndExecute(this.pipe.m_58899_(), FluidButtonPacket.ButtonResult.FILTER_CHANGE, 0);
                button.m_93666_((Component)Component.m_237115_((String)((String)whitelistText.get())));
            }).m_252987_(x - 20, y, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)(whitelistText.get() + ".description")).m_130940_(ChatFormatting.GRAY))).m_253136_());
        }
        if (this.canPopulateFromTanks) {
            buttons.add((AbstractWidget)Button.m_253074_((Component)Component.m_237115_((String)"info.prettypipes.populate"), button -> FluidButtonPacket.sendAndExecute(this.pipe.m_58899_(), FluidButtonPacket.ButtonResult.FILTER_CHANGE, 1)).m_252987_(x - 42, y, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"info.prettypipes.populate.description").m_130940_(ChatFormatting.GRAY))).m_253136_());
        }
        return buttons;
    }

    public void onButtonPacket(IFluidFilteredContainer menu, int id) {
        if (id == 0 && this.canModifyWhitelist) {
            this.isWhitelist = !this.isWhitelist;
            this.modified = true;
            this.save();
        } else if (id == 1 && this.canPopulateFromTanks) {
            List<FluidFilter> filters = this.pipe.getFluidFilters();
            boolean changed = false;
            for (Direction dir : Direction.values()) {
                IFluidHandler handler = this.pipe.getFluidHandler(dir);
                if (handler == null) continue;
                block1: for (int i = 0; i < handler.getTanks(); ++i) {
                    FluidStack stack = handler.getFluidInTank(i);
                    if (stack.isEmpty() || this.isFluidFiltered(stack)) continue;
                    for (FluidFilter filter : filters) {
                        if (!filter.addFilter(stack)) continue;
                        changed = true;
                        filter.save();
                        continue block1;
                    }
                }
            }
            if (changed) {
                menu.onFilterPopulated();
            }
        }
    }

    public boolean isPipeItemAllowed(ItemStack stack) {
        if (stack.m_41720_() == ItemSetup.FLUID_HOLDER.get()) {
            return FluidUtil.getFluidContained((ItemStack)stack).map(this::isPipeFluidAllowed).orElse(false);
        }
        return false;
    }

    public boolean isPipeFluidAllowed(FluidStack stack) {
        return this.isFluidFiltered(stack) == this.isWhitelist;
    }

    private boolean isFluidFiltered(FluidStack fluidStack) {
        for (ItemStackHandler itemStackHandler : this.pipe.getFluidFilters()) {
            for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
                ItemStack filter = itemStackHandler.getStackInSlot(i);
                Optional filteredFluid = FluidUtil.getFluidContained((ItemStack)filter);
                if (!filteredFluid.isPresent() || !((FluidStack)filteredFluid.get()).equals((Object)fluidStack)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean addFilter(FluidStack stack) {
        if (this.isFluidFiltered(stack)) {
            return false;
        }
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            if (!this.getStackInSlot(slot).m_41619_()) continue;
            this.setFilter(slot, stack);
            this.modified = true;
            return true;
        }
        return false;
    }

    public void setFilter(int slot, FluidStack filter) {
        this.setStackInSlot(slot, filter.isEmpty() ? ItemStack.f_41583_ : FluidUtil.getFilledBucket((FluidStack)filter));
        this.modified = true;
    }

    public void save() {
        if (this.modified) {
            this.moduleItem.m_41784_().m_128365_("filter", (Tag)this.serializeNBT());
            this.pipe.m_6596_();
            this.modified = false;
        }
    }

    protected void onContentsChanged(int slot) {
        this.modified = true;
    }

    public void load() {
        if (this.moduleItem.m_41782_() && this.moduleItem.m_41783_().m_128441_("filter")) {
            this.deserializeNBT(this.moduleItem.m_41783_().m_128469_("filter"));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.canModifyWhitelist) {
            nbt.m_128379_("whitelist", this.isWhitelist);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (this.canModifyWhitelist) {
            this.isWhitelist = nbt.m_128471_("whitelist");
        }
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public static interface IFluidFilteredContainer {
        public FluidFilter getFilter();

        default public void onFilterPopulated() {
        }
    }
}

