/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.container;

import dev.quarris.ppfluids.misc.FluidFilter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FluidFilterSlot
extends SlotItemHandler {
    private final FluidFilter filter;
    private final int index;

    public FluidFilterSlot(FluidFilter filter, int index, int xPosition, int yPosition) {
        super((IItemHandler)filter, index, xPosition, yPosition);
        this.index = index;
        this.filter = filter;
    }

    public static boolean clickFilter(AbstractContainerMenu container, int slotId, Player player) {
        Slot slot;
        if (slotId >= 0 && slotId < container.f_38839_.size() && (slot = container.m_38853_(slotId)) instanceof FluidFilterSlot) {
            ((FluidFilterSlot)slot).slotClick(container);
            return true;
        }
        return false;
    }

    private void slotClick(AbstractContainerMenu menu) {
        FluidStack fluid;
        ItemStack heldStack = menu.m_142621_();
        ItemStack stackInSlot = this.m_7993_();
        if (!stackInSlot.m_41619_() && heldStack.m_41619_()) {
            this.putFluidStack(FluidStack.EMPTY);
        } else if (!heldStack.m_41619_() && !(fluid = FluidUtil.getFluidContained((ItemStack)heldStack).orElse(FluidStack.EMPTY).copy()).isEmpty()) {
            fluid.setAmount(1);
            this.putFluidStack(fluid);
        }
    }

    public void putFluidStack(FluidStack stack) {
        this.filter.setFilter(this.index, stack);
        this.m_6654_();
    }

    public void m_6654_() {
        this.filter.setModified(true);
    }

    public boolean m_5857_(ItemStack stack) {
        return false;
    }

    public boolean m_8010_(Player playerIn) {
        return false;
    }
}

