/*
 * Decompiled with CFR 0.152.
 */
package com.github.raverbury.aggroindicator.event;

import com.github.raverbury.aggroindicator.config.ServerConfig;
import com.github.raverbury.aggroindicator.network.NetworkHandler;
import com.github.raverbury.aggroindicator.network.packet.MobDeAggroPacket;
import com.github.raverbury.aggroindicator.network.packet.MobTargetPlayerPacket;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerEventHandler {
    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(ServerEventHandler::handleLivingChangeTargetEvent);
        MinecraftForge.EVENT_BUS.addListener(ServerEventHandler::handleLivingDeathEvent);
    }

    public static void handleLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        if (event.isCanceled() || event.getEntity() == null || event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (ServerEventHandler.shouldSendDeAggroPacket(event)) {
            NetworkHandler.sendToPlayer(new MobDeAggroPacket(event.getEntity().m_20148_()), (ServerPlayer)ServerEventHandler.getCurrentTarget(event.getEntity()));
        }
        if (ServerEventHandler.shouldSendAggroPacket(event)) {
            NetworkHandler.sendToPlayer(new MobTargetPlayerPacket(event.getEntity().m_20148_(), event.getNewTarget().m_20148_()), (ServerPlayer)event.getNewTarget());
        }
    }

    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        if (event.isCanceled() || event.getEntity() == null || event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (ServerEventHandler.shouldSendDeAggroPacket(event)) {
            ServerPlayer serverPlayer = (ServerPlayer)((Mob)event.getEntity()).m_5448_();
            NetworkHandler.sendToPlayer(new MobDeAggroPacket(event.getEntity().m_20148_()), serverPlayer);
        }
    }

    private static boolean shouldSendDeAggroPacket(LivingDeathEvent event) {
        LivingEntity target = ServerEventHandler.getCurrentTarget(event.getEntity());
        boolean WAS_TARGETING_PLAYER = target instanceof ServerPlayer;
        return WAS_TARGETING_PLAYER;
    }

    private static boolean shouldSendDeAggroPacket(LivingChangeTargetEvent event) {
        LivingEntity oldTarget = ServerEventHandler.getCurrentTarget(event.getEntity());
        LivingEntity newTarget = event.getNewTarget();
        boolean WAS_TARGETING_PLAYER = oldTarget instanceof ServerPlayer;
        boolean NEW_TARGET_IS_DIFFERENT = newTarget == null || !newTarget.m_7306_((Entity)oldTarget);
        return WAS_TARGETING_PLAYER && NEW_TARGET_IS_DIFFERENT;
    }

    private static boolean shouldSendAggroPacket(LivingChangeTargetEvent event) {
        LivingEntity oldTarget = ServerEventHandler.getCurrentTarget(event.getEntity());
        LivingEntity newTarget = event.getNewTarget();
        String entityRegistryName = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_())).toString();
        boolean IS_BLACKLISTED = false;
        for (String item : (List)ServerConfig.SERVER_MOB_BLACKLIST.get()) {
            Pattern pattern = Pattern.compile(item = item.replace("*", ".*"), 2);
            if (!pattern.matcher(entityRegistryName).matches()) continue;
            IS_BLACKLISTED = true;
            break;
        }
        if (IS_BLACKLISTED) {
            return false;
        }
        boolean IS_TARGETING_PLAYER = newTarget instanceof ServerPlayer;
        boolean NEW_TARGET_IS_DIFFERENT = oldTarget == null || !oldTarget.m_7306_((Entity)newTarget);
        return IS_TARGETING_PLAYER && NEW_TARGET_IS_DIFFERENT;
    }

    private static LivingEntity getCurrentTarget(LivingEntity entity) {
        if (!(entity instanceof Mob)) {
            return null;
        }
        Mob mob = (Mob)entity;
        return mob.m_5448_();
    }
}

