/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DEGroundStructure
extends DEBaseStructure {
    public static final String ID_HAY_STORAGE = "hay_storage";
    public static final Codec<DEGroundStructure> CODEC_HAY_STORAGE = DEGroundStructure.m_226607_(DEGroundStructure::HayStorage);
    public static final String ID_JUNGLE_MONUMENT = "jungle_monument";
    public static final Codec<DEGroundStructure> CODEC_JUNGLE_MONUMENT = DEGroundStructure.m_226607_(DEGroundStructure::JungleMonument);
    public static final String ID_MINERS_HOUSE = "miners_house";
    public static final Codec<DEGroundStructure> CODEC_MINERS_HOUSE = DEGroundStructure.m_226607_(DEGroundStructure::MinersHouse);
    public static final String ID_MUSHROOM_HOUSE = "mushroom_house";
    public static final Codec<DEGroundStructure> CODEC_MUSHROOM_HOUSE = DEGroundStructure.m_226607_(DEGroundStructure::MushroomHouse);
    public static final String ID_RUINED_BUILDING = "ruined_building";
    public static final Codec<DEGroundStructure> CODEC_RUINED_BUILDING = DEGroundStructure.m_226607_(DEGroundStructure::RuinedBuilding);
    public static final String ID_STABLES = "stables";
    public static final Codec<DEGroundStructure> CODEC_STABLES = DEGroundStructure.m_226607_(DEGroundStructure::Stables);
    public static final String ID_TREE_HOUSE = "tree_house";
    public static final Codec<DEGroundStructure> CODEC_TREE_HOUSE = DEGroundStructure.m_226607_(DEGroundStructure::TreeHouse);
    public static final String ID_TOWER_OF_THE_UNDEAD = "tower_of_the_undead";
    public static final Codec<DEGroundStructure> CODEC_TOWER_OF_THE_UNDEAD = DEGroundStructure.m_226607_(DEGroundStructure::TowerOfTheUndead);
    public static final String ID_WATCH_TOWER = "watch_tower";
    public static final Codec<DEGroundStructure> CODEC_WATCH_TOWER = DEGroundStructure.m_226607_(DEGroundStructure::WatchTower);
    public static final String ID_WITCH_TOWER = "witch_tower";
    public static final Codec<DEGroundStructure> CODEC_WITCH_TOWER = DEGroundStructure.m_226607_(DEGroundStructure::WitchTower);

    public static DEGroundStructure HayStorage(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().add("hay_storage/small").add("hay_storage/big").build(), () -> DEStructures.HAY_STORAGE.getType());
    }

    public static DEGroundStructure JungleMonument(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().yOffset(-9).add(ID_JUNGLE_MONUMENT).build(), () -> DEStructures.JUNGLE_MONUMENT.getType());
    }

    public static DEGroundStructure MinersHouse(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().add(ID_MINERS_HOUSE).build(), () -> DEStructures.MINERS_HOUSE.getType());
    }

    public static DEGroundStructure MushroomHouse(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().add("mushroom_house/red").add("mushroom_house/brown").build(), () -> DEStructures.MUSHROOM_HOUSE.getType());
    }

    public static DEGroundStructure RuinedBuilding(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().weight(3).add("ruined_building/house").weight(2).add("ruined_building/house_big").weight(3).add("ruined_building/barn").build(), () -> DEStructures.RUINED_BUILDING.getType());
    }

    public static DEGroundStructure Stables(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().yOffset(-6).add(ID_STABLES).build(), () -> DEStructures.STABLES.getType());
    }

    public static DEGroundStructure TreeHouse(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().add(ID_TREE_HOUSE).build(), () -> DEStructures.TREE_HOUSE.getType());
    }

    public static DEGroundStructure TowerOfTheUndead(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().weight(3).add("tower_of_the_undead/small").weight(2).add("tower_of_the_undead/big").build(), () -> DEStructures.TOWER_OF_THE_UNDEAD.getType());
    }

    public static DEGroundStructure WatchTower(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().add(ID_WATCH_TOWER).build(), () -> DEStructures.WATCH_TOWER.getType());
    }

    public static DEGroundStructure WitchTower(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().weight(3).add("witch_tower/normal").weight(2).add("witch_tower/big").build(), () -> DEStructures.WITCH_TOWER.getType());
    }

    public DEGroundStructure(Structure.StructureSettings settings, DEStructureTemplates variants, Supplier<StructureType<?>> type) {
        super(settings, variants, type);
    }

    protected static void assemble(DEPieceAssembler.Context context) {
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), context.piece(), context.pos(), context.rotation()));
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        DEStructureTemplates.Template piece = this.Templates.getRandom((RandomSource)context.f_226626_());
        BlockPos rawPos = this.getGenPos(context.f_226628_()).m_6630_(piece.yOffset);
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        Vec3i size = context.f_226625_().m_230359_(piece.Resource).m_163808_(rotation);
        Pair<Float, Boolean> result = DETerrainAnalyzer.isFlatEnough(rawPos, size, 1, 4, context.f_226622_(), context.f_226629_(), context.f_226624_());
        if (!((Boolean)result.getSecond()).booleanValue()) {
            return Optional.empty();
        }
        BlockPos pos = rawPos.m_175288_(Math.round(((Float)result.getFirst()).floatValue())).m_6630_(piece.yOffset);
        return DEGroundStructure.at(pos, builder -> DEGroundStructure.generatePieces(builder, pos, piece, rotation, context, DEGroundStructure::assemble));
    }

    protected BlockPos getGenPos(ChunkPos chunkPos) {
        return DEUtil.ChunkPosToBlockPos(chunkPos);
    }

    public static class Piece
    extends DEBaseStructure.Piece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((Registrar.Static<StructurePieceType>)DEStructures.RUINED_BUILDING.getPieceType(), structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super((Registrar.Static<StructurePieceType>)DEStructures.RUINED_BUILDING.getPieceType(), serializationContext, nbt);
        }
    }
}

