/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.world.DEJigsawTypes;
import com.barion.dungeons_enhanced.world.DETemplatePools;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawRegistryHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class DEPillagerCamp {
    public static final String ID = "pillager_camp";

    public static void pool(BootstapContext<StructureTemplatePool> context) {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_enhanced", "pillager_camp/", context);
        registry.registerBuilder().pools(registry.poolBuilder().names(new String[]{"tent/general"}).maintainWater(false)).register(DETemplatePools.PILLAGER_CAMP);
        JigsawPoolBuilder basicPool = registry.poolBuilder().maintainWater(false);
        JigsawPoolBuilder SleepingTents = basicPool.clone().names(new String[]{"tent/sleep1", "tent/sleep2"});
        JigsawPoolBuilder Kitchen = basicPool.clone().names(new String[]{"tent/kitchen"});
        JigsawPoolBuilder Decoration2 = basicPool.clone().names(new String[]{"decoration/campfire", "decoration/cage1"});
        JigsawPoolBuilder Pillars = basicPool.clone().names(new String[]{"decoration/bell", "decoration/pillar"});
        JigsawPoolBuilder VanillaDecoration = basicPool.clone().namesR(new ResourceLocation[]{DEPillagerCamp.mcPiece("logs"), DEPillagerCamp.mcPiece("targets"), DEPillagerCamp.mcPiece("tent1"), DEPillagerCamp.mcPiece("tent2")});
        registry.registerBuilder().pools(basicPool.clone().names(new String[]{"plate/var1", "plate/var2"})).projection(StructureTemplatePool.Projection.TERRAIN_MATCHING).register("feature_plates");
        registry.register("features", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{SleepingTents.weight(2), Kitchen.weight(2), VanillaDecoration.weight(2), Decoration2.weight(3), Pillars.weight(1)}));
    }

    private static ResourceLocation mcPiece(String key) {
        return new ResourceLocation("pillager_outpost/feature_" + key);
    }

    public static class Piece
    extends ExtendedJigsawStructurePiece {
        public Piece(IPieceFactory.Context context) {
            super(context);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super(serializationContext, nbt);
        }

        public StructurePieceType m_210000_() {
            return (StructurePieceType)DEStructures.PILLAGER_CAMP.getPieceType().get();
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
        }
    }

    public static class Capability
    implements JigsawCapability.IJigsawCapability {
        public static final Capability INSTANCE = new Capability();
        public static final Codec<Capability> CODEC = Codec.unit((Object)INSTANCE);

        public JigsawCapability.JigsawType<?> getType() {
            return DEJigsawTypes.PILLAGER_CAMP;
        }

        public IPieceFactory getPieceFactory() {
            return Piece::new;
        }
    }
}

