/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEUnderwaterStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.processor.DESwapDeadCoralsProcessor;
import com.barion.dungeons_enhanced.world.structure.processor.DEUnderwaterProcessor;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DEEldersTemple
extends DEUnderwaterStructure {
    public static final String ID = "elders_temple";
    public static final Codec<DEEldersTemple> CODEC = DEEldersTemple.m_226607_(DEEldersTemple::new);
    private static final ResourceLocation NE = DEUtil.location("elders_temple/ne");
    private static final ResourceLocation NW = DEUtil.location("elders_temple/nw");
    private static final ResourceLocation SE = DEUtil.location("elders_temple/se");
    private static final ResourceLocation SW = DEUtil.location("elders_temple/sw");

    public DEEldersTemple(Structure.StructureSettings settings) {
        super(settings, DEUtil.pieceBuilder().add("elders_temple/se").build(), () -> DEStructures.ELDERS_TEMPLE.getType());
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        BlockPos pos = DEUtil.ChunkPosToBlockPosFromHeightMap(context.f_226628_(), context.f_226622_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
        if (!DETerrainAnalyzer.isUnderwater(pos, context.f_226622_(), 32, context.f_226629_(), context.f_226624_())) {
            return Optional.empty();
        }
        if (!DETerrainAnalyzer.areNearbyBiomesValid(context.f_226623_(), pos, context.f_226622_(), 30, context.f_226630_(), context.f_226624_())) {
            return Optional.empty();
        }
        return DEEldersTemple.at(pos, builder -> DEEldersTemple.generatePieces(builder, pos, this.Templates.getRandom((RandomSource)context.f_226626_()), Rotation.m_221990_((RandomSource)context.f_226626_()), context, DEEldersTemple::assembleTemple));
    }

    public static void assembleTemple(DEPieceAssembler.Context context) {
        Rotation rotation = Rotation.NONE;
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), SE, context.pos().m_7918_(0, 0, 0), rotation));
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), SW, context.pos().m_7918_(-30, 0, 0), rotation));
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), NE, context.pos().m_7918_(0, 0, -29), rotation));
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), NW, context.pos().m_7918_(-30, 0, -29), rotation));
    }

    public static class Piece
    extends DEBaseStructure.Piece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((Registrar.Static<StructurePieceType>)DEStructures.ELDERS_TEMPLE.getPieceType(), structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super((Registrar.Static<StructurePieceType>)DEStructures.ELDERS_TEMPLE.getPieceType(), serializationContext, nbt);
        }

        @Override
        protected void addProcessors(StructurePlaceSettings settings) {
            settings.m_74394_();
            settings.m_74383_((StructureProcessor)DEUnderwaterProcessor.INSTANCE).m_74383_((StructureProcessor)DESwapDeadCoralsProcessor.INSTANCE);
        }
    }
}

