/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.data.provider;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.DEUtil;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public class DEAdvancementProvider
extends ForgeAdvancementProvider {
    public static final CompletableFuture<HolderLookup.Provider> registriesLookup = CompletableFuture.supplyAsync(VanillaRegistries::m_255371_, Util.m_183991_());

    public DEAdvancementProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, registriesLookup, existingFileHelper, List.of(new DEExplorerAdvancementSubProvider()));
    }

    public static class DEExplorerAdvancementSubProvider
    implements ForgeAdvancementProvider.AdvancementGenerator {
        public void generate(@Nonnull HolderLookup.Provider registries, @Nonnull Consumer<Advancement> consumer, @Nonnull ExistingFileHelper existingFileHelper) {
            Advancement root = this.enterAnyStructure(this.advancement((ItemLike)Blocks.f_50223_, "root", new ResourceLocation("textures/block/mossy_cobblestone.png"), FrameType.TASK, false, false, false), DEStructures.ALL_STRUCTURE_REGISTRARS).m_138360_(RequirementsStrategy.f_15979_).save(consumer, this.location("root"), existingFileHelper);
            Advancement HiddenUnderTheRoots = this.enterStructure(this.advancement((ItemLike)Blocks.f_50144_, "hidden_under_the_roots", FrameType.TASK, true, true, false), DEStructures.MONSTER_MAZE).m_138398_(root).save(consumer, this.location("hidden_under_the_roots"), existingFileHelper);
            Advancement ThatsADungeon = this.enterStructure(this.advancement((ItemLike)Blocks.f_50310_, "thats_a_dungeon", FrameType.TASK, true, true, false), DEStructures.LARGE_DUNGEON).m_138398_(root).save(consumer, this.location("thats_a_dungeon"), existingFileHelper);
            Advancement TrapsAndCurses = this.enterStructure(this.advancement((ItemLike)Blocks.f_50077_, "traps_and_curses", FrameType.TASK, true, true, false), DEStructures.DESERT_TEMPLE).m_138398_(root).save(consumer, this.location("traps_and_curses"), existingFileHelper);
            Advancement AncientCivilizations = this.enterStructure(this.advancement((ItemLike)Blocks.f_50571_, "ancient_civilizations", FrameType.TASK, true, true, false), DEStructures.JUNGLE_MONUMENT).m_138398_(root).save(consumer, this.location("ancient_civilizations"), existingFileHelper);
            Advancement WarsAndKingdoms = this.enterStructure(this.advancement((ItemLike)Blocks.f_50222_, "wars_and_kingdoms", FrameType.TASK, true, true, false), DEStructures.CASTLE).m_138398_(root).save(consumer, this.location("wars_and_kingdoms"), existingFileHelper);
            Advancement RarestStructure = this.enterStructure(this.advancement((ItemLike)Items.f_41953_, "rarest_structure", FrameType.TASK, true, true, false), DEStructures.MUSHROOM_HOUSE).m_138398_(root).save(consumer, this.location("rarest_structure"), existingFileHelper);
            Advancement ChilledHalls = this.enterStructure(this.advancement((ItemLike)Items.f_42500_, "chilled_halls", FrameType.TASK, true, true, false), DEStructures.ICE_PIT).m_138398_(root).save(consumer, this.location("chilled_halls"), existingFileHelper);
            Advancement Ahoy = this.enterStructure(this.advancement((ItemLike)Items.f_42679_, "ahoy", FrameType.TASK, true, true, false), DEStructures.PIRATE_SHIP).m_138398_(root).save(consumer, this.location("ahoy"), existingFileHelper);
            Advancement InTheAir = this.enterStructure(this.advancement((ItemLike)Items.f_42778_, "in_the_air", FrameType.TASK, true, true, false), DEStructures.FLYING_DUTCHMAN).m_138398_(root).save(consumer, this.location("in_the_air"), existingFileHelper);
            Advancement SunkenDepths = this.enterStructure(this.advancement((ItemLike)Items.f_42715_, "sunken_deeps", FrameType.TASK, true, true, false), DEStructures.ELDERS_TEMPLE).m_138398_(root).save(consumer, this.location("sunken_deeps"), existingFileHelper);
            Advancement SevenWorldWonders = this.enterAnyStructure(this.advancement((ItemLike)Items.f_151059_, "seven_world_wonders", FrameType.GOAL, true, true, false), DEStructures.CASTLE, DEStructures.DEEP_CRYPT, DEStructures.DESERT_TEMPLE, DEStructures.ICE_PIT, DEStructures.JUNGLE_MONUMENT, DEStructures.MONSTER_MAZE, DEStructures.ELDERS_TEMPLE).m_138360_(RequirementsStrategy.f_15978_).m_138398_(root).save(consumer, this.location("seven_world_wonders"), existingFileHelper);
            Advancement AmbitiousExplorer = this.enterAnyStructure(this.advancement((ItemLike)Items.f_42573_, "ambitious_explorer", FrameType.CHALLENGE, true, true, false), DEStructures.ALL_STRUCTURE_REGISTRARS).m_138360_(RequirementsStrategy.f_15978_).m_138398_(SevenWorldWonders).save(consumer, this.location("ambitious_explorer"), existingFileHelper);
        }

        private Advancement.Builder enterAnyStructure(Advancement.Builder builder, StructureRegistrar<?> ... structures) {
            for (StructureRegistrar<?> structure : structures) {
                builder = this.enterStructure(builder, structure);
            }
            return builder;
        }

        private Advancement.Builder enterStructure(Advancement.Builder builder, StructureRegistrar<?> structure) {
            return builder.m_138386_(this.enterFeatureText(structure), (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_((ResourceKey)Objects.requireNonNull(structure.getStructure()).getKey())));
        }

        private String enterFeatureText(StructureRegistrar<?> structure) {
            return "entered_" + Objects.requireNonNull(structure.getRegistryName()).m_135815_();
        }

        private Advancement.Builder advancement(ItemLike displayItem, String name, ResourceLocation background, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.m_285878_().m_138371_(displayItem, this.translate(name), this.translate(name + ".desc"), background, frameType, showToast, announceToChat, hidden);
        }

        private Advancement.Builder advancement(ItemLike displayItem, String name, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.advancement(displayItem, name, null, frameType, showToast, announceToChat, hidden);
        }

        private Component translate(String key) {
            return Component.m_237115_((String)("advancements.dungeons_enhanced." + key));
        }

        private ResourceLocation location(String key) {
            return DEUtil.location(key);
        }
    }
}

