/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.world;

import com.google.common.collect.Lists;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(category="world.peacefulsurface")
public class PeacefulSurfaceTweak
extends VTweak {
    public static final TagKey<EntityType<?>> BLACKLISTED_ENTITIES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("vtweaks", "ignored_by_peaceful_surface"));
    public static final TagKey<DimensionType> BLACKLISTED_DIMENSIONS = TagKey.m_203882_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("vtweaks", "peaceful_surface_blacklist_dims"));
    private ForgeConfigSpec.BooleanValue enabled;
    private ForgeConfigSpec.IntValue minY;
    private ForgeConfigSpec.ConfigValue<List<String>> moonPhases;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        String moonPhaseList = String.join((CharSequence)", ", Arrays.stream(MoonPhase.values()).map(Enum::toString).collect(Collectors.toList()));
        this.enabled = builder.comment("Prevents mobs from spawning above sea level unless it's a new moon").define("enablePeacefulSurface", false);
        this.minY = builder.comment("The lowest Y-level which mobs will be prevented from spawning").defineInRange("peacefulSurfaceMinY", 60, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.moonPhases = builder.comment("Peaceful Surface will only apply on nights whose moon phases are contained in this list (by default, all nights except for New Moons are going to be peaceful).\nOptions can include: " + moonPhaseList).define("moonPhasesToApplyTo", (Object)Lists.newArrayList((Object[])new String[]{MoonPhase.FULL.toString(), MoonPhase.WANING_GIBBOUS.toString(), MoonPhase.LAST_QUARTER.toString(), MoonPhase.WANING_CRESCENT.toString(), MoonPhase.WAXING_CRESCENT.toString(), MoonPhase.FIRST_QUARTER.toString(), MoonPhase.WAXING_GIBBOUS.toString()}));
        builder.pop();
    }

    @SubscribeEvent
    public void process(MobSpawnEvent.SpawnPlacementCheck evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getSpawnType() != MobSpawnType.NATURAL) {
            return;
        }
        if (evt.getEntityType().m_20674_() != MobCategory.MONSTER) {
            return;
        }
        if (evt.getEntityType().m_204039_(BLACKLISTED_ENTITIES)) {
            return;
        }
        ServerLevelAccessor serverLevelAccessor = evt.getLevel();
        if (!(serverLevelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)serverLevelAccessor;
        if (level.m_204156_().m_203656_(BLACKLISTED_DIMENSIONS)) {
            return;
        }
        String currentPhase = MoonPhase.values()[level.m_46941_()].toString();
        if (((List)this.moonPhases.get()).stream().noneMatch(moonPhase -> Objects.equals(moonPhase, currentPhase))) {
            return;
        }
        if (evt.getPos().m_123342_() >= (Integer)this.minY.get()) {
            evt.setResult(Event.Result.DENY);
        }
    }

    public static enum MoonPhase {
        FULL,
        WANING_GIBBOUS,
        LAST_QUARTER,
        WANING_CRESCENT,
        NEW,
        WAXING_CRESCENT,
        FIRST_QUARTER,
        WAXING_GIBBOUS;

    }
}

