/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(category="entity.trader")
public class TraderStonks
extends VTweak {
    private ForgeConfigSpec.BooleanValue enabled;
    private ForgeConfigSpec.BooleanValue enableFlavorText;
    private ForgeConfigSpec.BooleanValue saveUnenchanted;
    private ForgeConfigSpec.IntValue numItemsToRestore;
    private ForgeConfigSpec.IntValue minCost;
    private ForgeConfigSpec.IntValue maxCost;
    private ForgeConfigSpec.DoubleValue chanceToSellValuable;
    public static final String lostItemKey = "vtweaks:lost_items";
    public static final String lostItemAddedKey = "vtweaks:lost_item_added";
    public static final String skipKey = "vtweaks:skipme";
    public static final TagKey<Item> VALUABLE = ItemTags.create((ResourceLocation)new ResourceLocation("vtweaks", "valuable"));
    private final HashMap<UUID, List<ItemEntity>> trackedValuables = new HashMap();
    long last = 0L;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("If enabled, any valuable tools / items lost forever via Cactus, Lava, Void, etc. might be found by the next Wandering Trader and put up for sale!\nValuable items are determined by the vtweaks:valuable tag and, if the item can be enchanted and the config option wanderingTraderRecoverySaveUnenchantedGear is set to true, is enchanted.").define("wanderingTraderRecoveryEnabled", true);
        this.enableFlavorText = builder.comment("Whether or not to show a silly message when interacting with a trader that has that player's items").define("enableFlavorText", true);
        this.saveUnenchanted = builder.comment("Determines if a destroyed #vtweaks:valuable should still be saved if it *can* be enchanted but isn't").define("saveUnenchantedGear", false);
        this.numItemsToRestore = builder.comment("The maximum number of a player's lost items will be sold by a Wandering Trader each visit").defineInRange("numItemsToRestore", 5, 1, Integer.MAX_VALUE);
        this.minCost = builder.comment("The minimum amount of emeralds a recovered item should cost").defineInRange("minEmeraldCost", 24, 1, 128);
        this.maxCost = builder.comment("The maximum amount of emeralds a recovered item should cost").defineInRange("maxEmeraldCost", 92, 1, 128);
        this.chanceToSellValuable = builder.comment("The chance that a given Wandering Trader will offer lost valuables for sale").defineInRange("chanceToSellValuable", 1.0, 0.0, 1.0);
        builder.pop();
    }

    @SubscribeEvent
    public void process(ItemTossEvent evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (!evt.getEntity().m_32055_().m_204117_(VALUABLE)) {
            return;
        }
        UUID uuid = evt.getPlayer().m_20148_();
        if (this.trackedValuables.containsKey(uuid)) {
            this.trackedValuables.get(uuid).add(evt.getEntity());
        } else {
            this.trackedValuables.put(uuid, List.of(evt.getEntity()));
        }
    }

    @SubscribeEvent
    public void process(LivingDropsEvent evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity livingEntity = evt.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        UUID uuid = player.m_20148_();
        for (ItemEntity itemEntity : evt.getDrops()) {
            if (!this.isItemValuable(itemEntity.m_32055_())) continue;
            if (this.trackedValuables.containsKey(uuid)) {
                this.trackedValuables.get(uuid).add(itemEntity);
                continue;
            }
            this.trackedValuables.put(uuid, List.of(itemEntity));
        }
    }

    @SubscribeEvent
    public void process(PlayerEvent.ItemPickupEvent evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getOriginalEntity().m_9236_().m_5776_()) {
            return;
        }
        HashMap<UUID, ArrayList> changes = new HashMap<UUID, ArrayList>();
        for (Map.Entry<UUID, List<ItemEntity>> entry : this.trackedValuables.entrySet()) {
            if (!entry.getValue().contains(evt.getOriginalEntity())) continue;
            ArrayList cpy = Lists.newArrayList(entry.getValue().listIterator());
            cpy.remove(evt.getOriginalEntity());
            changes.put(entry.getKey(), cpy);
        }
        this.trackedValuables.putAll(changes);
    }

    @SubscribeEvent
    public void process(TickEvent.ServerTickEvent evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.last < 1000L) {
            return;
        }
        HashMap<UUID, ArrayList> changes = new HashMap<UUID, ArrayList>();
        for (Map.Entry<UUID, List<ItemEntity>> entry : this.trackedValuables.entrySet()) {
            for (ItemEntity valuable : entry.getValue()) {
                ServerPlayer player;
                if (valuable.m_6084_() || (player = evt.getServer().m_6846_().m_11259_(entry.getKey())) == null) continue;
                ArrayList cpy = Lists.newArrayList(entry.getValue().listIterator());
                cpy.remove(valuable);
                changes.put(entry.getKey(), cpy);
                this.addLostValuableToPlayer((Player)player, valuable);
            }
        }
        this.trackedValuables.putAll(changes);
        this.last = System.currentTimeMillis();
    }

    @SubscribeEvent
    public void process(PlayerInteractEvent.EntityInteract evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getLevel().m_5776_()) {
            return;
        }
        Entity entity = evt.getTarget();
        if (!(entity instanceof WanderingTrader)) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)entity;
        CompoundTag traderTag = trader.getPersistentData();
        if (traderTag.m_128441_(skipKey)) {
            return;
        }
        if (evt.getLevel().m_213780_().m_188500_() > (Double)this.chanceToSellValuable.get()) {
            traderTag.m_128379_(skipKey, true);
            return;
        }
        if (traderTag.m_128441_(lostItemAddedKey)) {
            return;
        }
        CompoundTag tag = evt.getEntity().getPersistentData();
        if (!tag.m_128441_(lostItemKey)) {
            return;
        }
        ListTag lostItems = tag.m_128437_(lostItemKey, 10);
        if (lostItems.isEmpty()) {
            return;
        }
        int addedItemsCount = 0;
        for (int __ = 0; __ < (Integer)this.numItemsToRestore.get() && !lostItems.isEmpty(); ++__) {
            int idx = evt.getEntity().m_217043_().m_188503_(lostItems.size());
            Tag tag2 = lostItems.get(idx);
            if (!(tag2 instanceof CompoundTag)) {
                return;
            }
            CompoundTag itemTag = (CompoundTag)tag2;
            lostItems.remove(idx);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
            if (stack.m_41619_()) {
                return;
            }
            MerchantOffer newOffer = this.makeListing(stack, trader).m_213663_((Entity)trader, trader.m_217043_());
            trader.m_6616_().add((Object)newOffer);
            ++addedItemsCount;
        }
        traderTag.m_128379_(lostItemAddedKey, true);
        if (((Boolean)this.enableFlavorText.get()).booleanValue()) {
            try {
                String str = addedItemsCount > 1 ? "vtweaks.warranty.message.text.plural" : "vtweaks.warranty.message.text.singular";
                MutableComponent text = new TranslatableContents(str, null, new Object[0]).m_213698_(null, null, 0);
                evt.getEntity().m_5661_((Component)text, true);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    private void addLostValuableToPlayer(Player player, ItemEntity valuable) {
        CompoundTag tag = player.getPersistentData();
        ListTag lostItems = tag.m_128441_(lostItemKey) ? tag.m_128437_(lostItemKey, 10) : new ListTag();
        CompoundTag itemStackAsTag = new CompoundTag();
        valuable.m_32055_().m_41739_(itemStackAsTag);
        lostItems.add((Object)itemStackAsTag);
        tag.m_128365_(lostItemKey, (Tag)lostItems);
    }

    private boolean isItemValuable(ItemStack stack) {
        if (!stack.m_204117_(VALUABLE)) {
            return false;
        }
        if (!((Boolean)this.saveUnenchanted.get()).booleanValue() && stack.m_41792_()) {
            return stack.m_41793_();
        }
        return true;
    }

    private BasicItemListing makeListing(ItemStack forSale, WanderingTrader trader) {
        int max;
        int min = (Integer)this.minCost.get();
        int cost = min == (max = ((Integer)this.maxCost.get()).intValue()) ? min : trader.m_217043_().m_216339_(min, max);
        int leftOver = Math.max(cost - 64, 0);
        if (leftOver == 0) {
            return new BasicItemListing(cost, forSale, 1, 0);
        }
        return new BasicItemListing(new ItemStack((ItemLike)Items.f_42616_, cost - leftOver), new ItemStack((ItemLike)Items.f_42616_, leftOver), forSale, 1, 0, 0.0f);
    }
}

