/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.block;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(category="block")
public class TorchLightingTweak
extends VTweak {
    public static final TagKey<Item> TORCH_ITEM = ItemTags.create((ResourceLocation)new ResourceLocation("vtweaks", "ignition_item"));
    public static final TagKey<Block> TORCH_IGNITE_BL = BlockTags.create((ResourceLocation)new ResourceLocation("vtweaks", "torch_ignition_blacklist"));
    public ForgeConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("Allows the player to re-light certain blocks like Candles and Campfires (defined by the block using the `lit` blockstate) using torches or other items in the tag `vtweaks:ignition_item`").define("enableTorchLighting", true);
    }

    @SubscribeEvent
    public void process(PlayerInteractEvent.RightClickBlock evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        Player player = evt.getEntity();
        Level level = evt.getLevel();
        BlockPos pos = evt.getPos();
        BlockState state = level.m_8055_(pos);
        if (player.m_6047_()) {
            return;
        }
        if (state.m_204336_(TORCH_IGNITE_BL)) {
            return;
        }
        if (!state.m_61138_((Property)BlockStateProperties.f_61443_)) {
            return;
        }
        if (!player.m_21205_().m_204117_(TORCH_ITEM)) {
            return;
        }
        if (state.m_61143_((Property)BlockStateProperties.f_61443_) == Boolean.FALSE && level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 18)) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11874_, SoundSource.BLOCKS, 0.15f, 1.0f);
            player.m_6674_(InteractionHand.MAIN_HAND);
            evt.setCancellationResult(InteractionResult.CONSUME);
            evt.setCanceled(true);
        }
    }
}

