/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.fluidconversion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipe;
import com.oitsjustjose.vtweaks.common.data.helpers.VTJsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidConversionRecipeSerializer
implements RecipeSerializer<FluidConversionRecipe> {
    @NotNull
    public FluidConversionRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject obj) {
        Ingredient input = Ingredient.m_288218_((JsonElement)obj.get("input"), (boolean)false);
        ItemStack output = VTJsonHelpers.deserializeItemStack(obj, "output");
        ResourceLocation fluid = new ResourceLocation(obj.get("fluid").getAsString());
        return new FluidConversionRecipe(id, input, output, fluid);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull FluidConversionRecipe recipe) {
        CraftingHelper.write((FriendlyByteBuf)buf, (Ingredient)recipe.getInput());
        buf.writeItemStack(recipe.getResult(), false);
        buf.m_130070_(recipe.getFluid().toString());
    }

    @Nullable
    public FluidConversionRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
        ItemStack output = buf.m_130267_();
        ResourceLocation fluid = new ResourceLocation(buf.m_130277_());
        return new FluidConversionRecipe(id, input, output, fluid);
    }
}

