/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks;

import com.oitsjustjose.vtweaks.client.ClientProxy;
import com.oitsjustjose.vtweaks.common.CommonProxy;
import com.oitsjustjose.vtweaks.common.config.ClientConfig;
import com.oitsjustjose.vtweaks.common.config.CommonConfig;
import com.oitsjustjose.vtweaks.common.core.TickScheduler;
import com.oitsjustjose.vtweaks.common.core.TweakRegistry;
import com.oitsjustjose.vtweaks.common.data.anvil.AnvilRecipe;
import com.oitsjustjose.vtweaks.common.data.challenger.ChallengerDataLoader;
import com.oitsjustjose.vtweaks.common.data.culling.EntityCullingDataLoader;
import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipe;
import com.oitsjustjose.vtweaks.common.registries.RecipeTypeRegistry;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="vtweaks")
public class VTweaks {
    public static final CommonProxy Proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static VTweaks instance;
    public final Logger LOGGER = LogManager.getLogger();
    public final TweakRegistry TweakRegistry = new TweakRegistry();
    public final TickScheduler Scheduler = new TickScheduler();
    public final RecipeTypeRegistry CustomRecipeRegistry = new RecipeTypeRegistry();
    private final HashMap<ResourceLocation, AnvilRecipe> AllAnvilRecipes;
    private final HashMap<ResourceLocation, FluidConversionRecipe> AllFluidConversionRecipes;

    public VTweaks() {
        instance = this;
        this.AllAnvilRecipes = new HashMap();
        this.AllFluidConversionRecipes = new HashMap();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.Scheduler);
        this.CustomRecipeRegistry.SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.configSetup();
    }

    public static VTweaks getInstance() {
        return instance;
    }

    public void setup(FMLCommonSetupEvent ignoredEvent) {
        Proxy.init();
    }

    private void configSetup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        CommonConfig.loadConfig(CommonConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("vtweaks-common.toml"));
        ClientConfig.loadConfig(ClientConfig.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("vtweaks-client.toml"));
    }

    @SubscribeEvent
    public void onSlashReload(AddReloadListenerEvent evt) {
        evt.addListener((PreparableReloadListener)new ChallengerDataLoader());
        evt.addListener((PreparableReloadListener)new EntityCullingDataLoader());
        this.AllAnvilRecipes.clear();
        this.AllFluidConversionRecipes.clear();
    }

    public void addAnvilRecipe(ResourceLocation loc, AnvilRecipe recipe) {
        this.AllAnvilRecipes.put(loc, recipe);
    }

    public void addFluidConversionRecipe(ResourceLocation loc, FluidConversionRecipe recipe) {
        this.AllFluidConversionRecipes.put(loc, recipe);
    }

    public HashMap<ResourceLocation, AnvilRecipe> getAnvilRecipes() {
        return (HashMap)this.AllAnvilRecipes.clone();
    }

    public HashMap<ResourceLocation, FluidConversionRecipe> getFluidConversionRecipes() {
        return (HashMap)this.AllFluidConversionRecipes.clone();
    }
}

