/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui.frame;

import java.util.concurrent.atomic.AtomicReference;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.gui.GuiGraphics;
import org.embeddedt.embeddium.gui.frame.AbstractFrame;
import org.embeddedt.embeddium.gui.frame.components.ScrollBarComponent;

public class ScrollableFrame
extends AbstractFrame {
    protected final Dim2i frameOrigin;
    protected final AbstractFrame frame;
    private boolean canScrollHorizontal;
    private boolean canScrollVertical;
    private Dim2i viewPortDimension = null;
    private ScrollBarComponent verticalScrollBar = null;
    private ScrollBarComponent horizontalScrollBar = null;

    public ScrollableFrame(Dim2i dim, AbstractFrame frame, boolean renderOutline, AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        super(dim, renderOutline);
        this.frame = frame;
        this.frameOrigin = new Dim2i(frame.dim.x(), frame.dim.y(), 0, 0);
        this.setupFrame(verticalScrollBarOffset, horizontalScrollBarOffset);
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame(AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        int maxWidth = 0;
        int maxHeight = 0;
        if (!this.dim.canFitDimension(this.frame.dim)) {
            int value;
            if (this.dim.getLimitX() < this.frame.dim.getLimitX() && maxWidth < (value = this.frame.dim.x() - this.dim.x() + this.frame.dim.width())) {
                maxWidth = value;
            }
            if (this.dim.getLimitY() < this.frame.dim.getLimitY() && maxHeight < (value = this.frame.dim.y() - this.dim.y() + this.frame.dim.height())) {
                maxHeight = value;
            }
        }
        if (maxWidth > 0) {
            this.canScrollHorizontal = true;
        }
        if (maxHeight > 0) {
            this.canScrollVertical = true;
        }
        if (this.canScrollHorizontal && this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height() - 11);
        } else if (this.canScrollHorizontal) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height() - 11);
            this.frame.dim = this.frame.dim.withHeight(this.frame.dim.height() - 11);
        } else if (this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height());
            this.frame.dim = this.frame.dim.withWidth(this.frame.dim.width() - 11);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.x(), this.viewPortDimension.getLimitY() + 1, this.viewPortDimension.width(), 10), ScrollBarComponent.Mode.HORIZONTAL, this.frame.dim.width(), this.viewPortDimension.width(), offset -> horizontalScrollBarOffset.set((Integer)offset));
            this.horizontalScrollBar.setOffset(horizontalScrollBarOffset.get());
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.getLimitX() + 1, this.viewPortDimension.y(), 10, this.viewPortDimension.height()), ScrollBarComponent.Mode.VERTICAL, this.frame.dim.height(), this.viewPortDimension.height(), offset -> verticalScrollBarOffset.set((Integer)offset), this.viewPortDimension);
            this.verticalScrollBar.setOffset(verticalScrollBarOffset.get());
        }
    }

    @Override
    public void buildFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar.updateThumbPosition();
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.updateThumbPosition();
        }
        if (this.canScrollHorizontal) {
            this.children.add(this.horizontalScrollBar);
        }
        if (this.canScrollVertical) {
            this.children.add(this.verticalScrollBar);
        }
        this.frame.buildFrame();
        this.children.add(this.frame);
        super.buildFrame();
        this.frame.registerFocusListener(element -> {
            if (element instanceof ControlElement) {
                ControlElement controlElement = (ControlElement)element;
                if (this.canScrollVertical) {
                    Dim2i dim = controlElement.getDimensions();
                    int inputOffset = this.verticalScrollBar.getOffset();
                    int elementTop = dim.y() - inputOffset;
                    int elementBottom = dim.getLimitY() - inputOffset;
                    if (elementTop <= this.viewPortDimension.y()) {
                        inputOffset += elementTop - this.viewPortDimension.y();
                    } else if (elementBottom >= this.viewPortDimension.getLimitY()) {
                        inputOffset += elementBottom - this.viewPortDimension.getLimitY();
                    }
                    this.verticalScrollBar.setOffset(inputOffset);
                }
            }
        });
    }

    private double applyOffset(ScrollBarComponent component, double coord, boolean negate) {
        if (component == null) {
            return coord;
        }
        return coord + (double)(component.getOffset() * (negate ? -1 : 1));
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.canScrollHorizontal || this.canScrollVertical) {
            if (this.renderOutline) {
                this.drawBorder(drawContext, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
            }
            this.applyScissor(this.viewPortDimension.x(), this.viewPortDimension.y(), this.viewPortDimension.width(), this.viewPortDimension.height(), () -> {
                drawContext.m_280168_().m_85836_();
                drawContext.m_280168_().m_85837_(this.applyOffset(this.horizontalScrollBar, 0.0, true), this.applyOffset(this.verticalScrollBar, 0.0, true), 0.0);
                super.m_88315_(drawContext, (int)this.applyOffset(this.horizontalScrollBar, mouseX, false), (int)this.applyOffset(this.verticalScrollBar, mouseY, false), delta);
                drawContext.m_280168_().m_85849_();
            });
        } else {
            super.m_88315_(drawContext, mouseX, mouseY, delta);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar.m_88315_(drawContext, mouseX, mouseY, delta);
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.m_88315_(drawContext, mouseX, mouseY, delta);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), button) || this.canScrollHorizontal && this.horizontalScrollBar.m_6375_(mouseX, mouseY, button) || this.canScrollVertical && this.verticalScrollBar.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.m_7979_(this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), button, deltaX, deltaY) || this.canScrollHorizontal && this.horizontalScrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY) || this.canScrollVertical && this.verticalScrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), button) || this.canScrollHorizontal && this.horizontalScrollBar.m_6348_(mouseX, mouseY, button) || this.canScrollVertical && this.verticalScrollBar.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double verticalAmount) {
        return super.m_6050_(this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), verticalAmount) || this.canScrollHorizontal && this.horizontalScrollBar.m_6050_(mouseX, mouseY, verticalAmount) || this.canScrollVertical && this.verticalScrollBar.m_6050_(mouseX, mouseY, verticalAmount);
    }

    public static class Builder {
        private boolean renderOutline = false;
        private Dim2i dim = null;
        private AbstractFrame frame = null;
        private AtomicReference<Integer> verticalScrollBarOffset = new AtomicReference<Integer>(0);
        private AtomicReference<Integer> horizontalScrollBarOffset = new AtomicReference<Integer>(0);

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean state) {
            this.renderOutline = state;
            return this;
        }

        public Builder setVerticalScrollBarOffset(AtomicReference<Integer> verticalScrollBarOffset) {
            this.verticalScrollBarOffset = verticalScrollBarOffset;
            return this;
        }

        public Builder setHorizontalScrollBarOffset(AtomicReference<Integer> horizontalScrollBarOffset) {
            this.horizontalScrollBarOffset = horizontalScrollBarOffset;
            return this;
        }

        public Builder setFrame(AbstractFrame frame) {
            this.frame = frame;
            return this;
        }

        public ScrollableFrame build() {
            return new ScrollableFrame(this.dim, this.frame, this.renderOutline, this.verticalScrollBarOffset, this.horizontalScrollBarOffset);
        }
    }
}

