/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.compat.immersive;

import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.embeddedt.embeddium.api.ChunkMeshEvent;
import org.embeddedt.embeddium.compat.immersive.ImmersiveEmptyChunkChecker;

public class ImmersiveConnectionRenderer
implements ResourceManagerReloadListener {
    private static final LoadingCache<SegmentsKey, List<RenderedSegment>> SEGMENT_CACHE = CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.SECONDS).build(CacheLoader.from(ImmersiveConnectionRenderer::renderSegmentForCache));
    private static final ResettableLazy<TextureAtlasSprite> WIRE_TEXTURE = new ResettableLazy(() -> Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(ImmersiveConnectionRenderer.rl("block/wire")));
    private static final Material MATERIAL = DefaultMaterials.SOLID;

    public static ResourceLocation rl(String path) {
        return new ResourceLocation("immersiveengineering", path);
    }

    static void meshAppendEvent(ChunkMeshEvent event) {
        if (ImmersiveEmptyChunkChecker.hasWires(event.getSectionOrigin())) {
            event.addMeshAppender(ctx -> ImmersiveConnectionRenderer.renderConnectionsInSection(ctx.sodiumBuildBuffers(), ctx.blockRenderView(), ctx.sectionOrigin()));
        }
    }

    public void m_6213_(@Nonnull ResourceManager pResourceManager) {
        WIRE_TEXTURE.reset();
        ImmersiveConnectionRenderer.resetCache();
    }

    public static void resetCache() {
        SEGMENT_CACHE.invalidateAll();
    }

    public static void renderConnectionsInSection(ChunkBuildBuffers buffers, BlockAndTintGetter region, SectionPos section) {
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork((Level)Minecraft.m_91087_().f_91073_);
        List connectionParts = globalNet.getCollisionData().getWiresIn(section);
        if (connectionParts == null || connectionParts.isEmpty()) {
            return;
        }
        RenderType renderType = RenderType.m_110451_();
        ChunkModelBuilder builder = buffers.get(DefaultMaterials.forRenderLayer(renderType));
        int originX = section.m_123229_();
        int originY = section.m_123234_();
        int originZ = section.m_123239_();
        for (WireCollisionData.ConnectionSegments connection : connectionParts) {
            ConnectionPoint connectionOrigin = connection.connection().getEndA();
            ImmersiveConnectionRenderer.renderSegments(builder, connection, region, connectionOrigin.getX() - originX, connectionOrigin.getY() - originY, connectionOrigin.getZ() - originZ);
        }
    }

    public static void renderSegments(ChunkModelBuilder out, WireCollisionData.ConnectionSegments toRender, BlockAndTintGetter level, int offX, int offY, int offZ) {
        Connection connection = toRender.connection();
        int colorRGB = connection.type.getColour(connection);
        int colorBGR = ColorARGB.toABGR(colorRGB, 255);
        double radius = connection.type.getRenderDiameter() / 2.0;
        List segments = (List)SEGMENT_CACHE.getUnchecked((Object)new SegmentsKey(radius, colorBGR, connection.getCatenaryData(), toRender.firstPointToRender(), toRender.lastPointToRender()));
        int lastLight = 0;
        for (int startPoint = 0; startPoint < segments.size(); ++startPoint) {
            RenderedSegment renderedSegment = (RenderedSegment)segments.get(startPoint);
            if (startPoint == 0) {
                lastLight = ImmersiveConnectionRenderer.getLight(connection, renderedSegment.offsetStart, level);
            }
            int nextLight = ImmersiveConnectionRenderer.getLight(connection, renderedSegment.offsetEnd, level);
            renderedSegment.render(lastLight, nextLight, offX, offY, offZ, out);
            lastLight = nextLight;
        }
    }

    private static List<RenderedSegment> renderSegmentForCache(SegmentsKey key) {
        ArrayList<RenderedSegment> segments = new ArrayList<RenderedSegment>(key.endIndex() - key.beginIndex());
        for (int i = key.beginIndex(); i < key.endIndex(); ++i) {
            segments.add(ImmersiveConnectionRenderer.renderSegmentForCache(key, i));
        }
        return segments;
    }

    private static RenderedSegment renderSegmentForCache(SegmentsKey key, int startIndex) {
        Connection.CatenaryData catenaryData = key.catenaryShape();
        Vec3 start = key.catenaryShape().getRenderPoint(startIndex);
        Vec3 end = key.catenaryShape().getRenderPoint(startIndex + 1);
        Vec3 horNormal = key.catenaryShape().isVertical() ? new Vec3(1.0, 0.0, 0.0) : new Vec3(-catenaryData.delta().f_82481_, 0.0, catenaryData.delta().f_82479_).m_82541_();
        Vec3 verticalNormal = start.m_82546_(end).m_82537_(horNormal).m_82541_();
        Vec3 horRadius = horNormal.m_82490_(key.radius());
        Vec3 verticalRadius = verticalNormal.m_82490_(-key.radius());
        return new RenderedSegment(ImmersiveConnectionRenderer.renderQuad(start, end, horRadius, key.color()), ImmersiveConnectionRenderer.renderQuad(start, end, verticalRadius, key.color()), ImmersiveConnectionRenderer.flooredVec3(start.f_82479_, start.f_82480_, start.f_82481_), ImmersiveConnectionRenderer.flooredVec3(end.f_82479_, end.f_82480_, end.f_82481_));
    }

    private static Vec3i flooredVec3(double x, double y, double z) {
        return new Vec3i(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
    }

    private static int getLight(Connection connection, Vec3i point, BlockAndTintGetter level) {
        return LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)connection.getEndA().position().m_121955_(point));
    }

    private static Quad renderQuad(Vec3 start, Vec3 end, Vec3 radius, int color) {
        TextureAtlasSprite texture = (TextureAtlasSprite)WIRE_TEXTURE.get();
        return new Quad(ImmersiveConnectionRenderer.vertex(start.m_82549_(radius), texture.m_118409_(), texture.m_118411_(), color, true), ImmersiveConnectionRenderer.vertex(end.m_82549_(radius), texture.m_118410_(), texture.m_118411_(), color, false), ImmersiveConnectionRenderer.vertex(end.m_82546_(radius), texture.m_118410_(), texture.m_118412_(), color, false), ImmersiveConnectionRenderer.vertex(start.m_82546_(radius), texture.m_118409_(), texture.m_118412_(), color, true));
    }

    private static Vertex vertex(Vec3 point, double u, double v, int color, boolean lightForStart) {
        return new Vertex((float)point.f_82479_, (float)point.f_82480_, (float)point.f_82481_, (float)u, (float)v, color, lightForStart);
    }

    private record SegmentsKey(double radius, int color, Connection.CatenaryData catenaryShape, int beginIndex, int endIndex) {
    }

    private record RenderedSegment(Quad quadA, Quad quadB, Vec3i offsetStart, Vec3i offsetEnd) {
        public void render(int lightStart, int lightEnd, int offX, int offY, int offZ, ChunkModelBuilder out) {
            this.quadA.write(out, offX, offY, offZ, lightStart, lightEnd);
            this.quadB.write(out, offX, offY, offZ, lightStart, lightEnd);
        }
    }

    private record Quad(Vertex v0, Vertex v1, Vertex v2, Vertex v3) {
        void write(ChunkModelBuilder out, int offX, int offY, int offZ, int lightStart, int lightEnd) {
            ChunkMeshBufferBuilder vertexSink = out.getVertexBuffer(ModelQuadFacing.UNASSIGNED);
            int quadStart = vertexSink.count();
            this.v0.write(vertexSink, offX, offY, offZ, lightStart, lightEnd);
            this.v1.write(vertexSink, offX, offY, offZ, lightStart, lightEnd);
            this.v2.write(vertexSink, offX, offY, offZ, lightStart, lightEnd);
            this.v3.write(vertexSink, offX, offY, offZ, lightStart, lightEnd);
            this.v0.write(vertexSink, offX, offY, offZ, lightStart, lightEnd);
            this.v3.write(vertexSink, offX, offY, offZ, lightStart, lightEnd);
            this.v2.write(vertexSink, offX, offY, offZ, lightStart, lightEnd);
            this.v1.write(vertexSink, offX, offY, offZ, lightStart, lightEnd);
        }
    }

    private record Vertex(float posX, float posY, float posZ, float texU, float texV, int color, boolean lightForStart) {
        static final ThreadLocal<ChunkVertexEncoder.Vertex[]> vertexHolder = ThreadLocal.withInitial(() -> new ChunkVertexEncoder.Vertex[1]);

        void write(ChunkMeshBufferBuilder vertexSink, int offX, int offY, int offZ, int lightStart, int lightEnd) {
            ChunkVertexEncoder.Vertex sodiumVertex = new ChunkVertexEncoder.Vertex();
            sodiumVertex.x = (float)offX + this.posX;
            sodiumVertex.y = (float)offY + this.posY;
            sodiumVertex.z = (float)offZ + this.posZ;
            sodiumVertex.color = this.color;
            sodiumVertex.u = this.texU;
            sodiumVertex.v = this.texV;
            sodiumVertex.light = this.lightForStart ? lightStart : lightEnd;
            ChunkVertexEncoder.Vertex[] array = vertexHolder.get();
            array[0] = sodiumVertex;
            vertexSink.push(array, MATERIAL);
        }
    }
}

