/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.function.Consumer;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.model.quad.blender.BlendedColorProvider;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import me.jellysquid.mods.sodium.client.render.chunk.map.ChunkTracker;
import me.jellysquid.mods.sodium.client.render.chunk.map.ChunkTrackerHolder;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import me.jellysquid.mods.sodium.client.util.NativeBuffer;
import me.jellysquid.mods.sodium.client.util.iterator.ByteIterator;
import me.jellysquid.mods.sodium.client.world.WorldRendererExtended;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLLoader;

public class SodiumWorldRenderer {
    private static final boolean ENABLE_BLOCKENTITY_CULLING = FMLLoader.getLoadingModList().getModFileById("valkyrienskies") == null;
    private final Minecraft client;
    private ClientLevel world;
    private int renderDistance;
    private double lastCameraX;
    private double lastCameraY;
    private double lastCameraZ;
    private double lastCameraPitch;
    private double lastCameraYaw;
    private float lastFogDistance;
    private boolean useEntityCulling;
    private Viewport currentViewport;
    private RenderSectionManager renderSectionManager;
    private boolean blockEntityRequestedOutline;
    private static final double MAX_ENTITY_CHECK_VOLUME = 61440.0;

    public static SodiumWorldRenderer instance() {
        SodiumWorldRenderer instance = SodiumWorldRenderer.instanceNullable();
        if (instance == null) {
            throw new IllegalStateException("No renderer attached to active world");
        }
        return instance;
    }

    public static SodiumWorldRenderer instanceNullable() {
        LevelRenderer world = Minecraft.m_91087_().f_91060_;
        if (world instanceof WorldRendererExtended) {
            return ((WorldRendererExtended)world).sodium$getWorldRenderer();
        }
        return null;
    }

    public SodiumWorldRenderer(Minecraft client) {
        this.client = client;
    }

    public void setWorld(ClientLevel world) {
        if (this.world == world) {
            return;
        }
        if (this.world != null) {
            this.unloadWorld();
        }
        if (world != null) {
            this.loadWorld(world);
        }
    }

    private void loadWorld(ClientLevel world) {
        this.world = world;
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    private void unloadWorld() {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.destroy();
            this.renderSectionManager = null;
        }
        this.world = null;
    }

    public int getVisibleChunkCount() {
        return this.renderSectionManager.getVisibleChunkCount();
    }

    public void scheduleTerrainUpdate() {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.markGraphDirty();
        }
    }

    public boolean isTerrainRenderComplete() {
        return this.renderSectionManager.getBuilder().isBuildQueueEmpty();
    }

    public void setupTerrain(Camera camera, Viewport viewport, @Deprecated(forRemoval=true) int frame, boolean spectator, boolean updateChunksImmediately) {
        boolean dirty;
        NativeBuffer.reclaim(false);
        this.processChunkEvents();
        this.useEntityCulling = SodiumClientMod.options().performance.useEntityCulling;
        if (this.client.f_91066_.m_193772_() != this.renderDistance) {
            this.reload();
        }
        ProfilerFiller profiler = this.client.m_91307_();
        profiler.m_6180_("camera_setup");
        LocalPlayer player = this.client.f_91074_;
        if (player == null) {
            throw new IllegalStateException("Client instance has no active player entity");
        }
        Vec3 pos = camera.m_90583_();
        float pitch = camera.m_90589_();
        float yaw = camera.m_90590_();
        float fogDistance = RenderSystem.getShaderFogEnd();
        boolean bl = dirty = pos.f_82479_ != this.lastCameraX || pos.f_82480_ != this.lastCameraY || pos.f_82481_ != this.lastCameraZ || (double)pitch != this.lastCameraPitch || (double)yaw != this.lastCameraYaw || fogDistance != this.lastFogDistance;
        if (dirty) {
            this.renderSectionManager.markGraphDirty();
        }
        this.currentViewport = viewport;
        this.lastCameraX = pos.f_82479_;
        this.lastCameraY = pos.f_82480_;
        this.lastCameraZ = pos.f_82481_;
        this.lastCameraPitch = pitch;
        this.lastCameraYaw = yaw;
        this.lastFogDistance = fogDistance;
        this.renderSectionManager.runAsyncTasks();
        profiler.m_6182_("chunk_update");
        this.renderSectionManager.updateChunks(updateChunksImmediately);
        profiler.m_6182_("chunk_upload");
        this.renderSectionManager.uploadChunks();
        if (this.renderSectionManager.needsUpdate()) {
            profiler.m_6182_("chunk_render_lists");
            this.renderSectionManager.update(camera, viewport, frame, spectator);
        }
        if (updateChunksImmediately) {
            profiler.m_6182_("chunk_upload_immediately");
            this.renderSectionManager.uploadChunks();
        }
        profiler.m_6182_("chunk_render_tick");
        this.renderSectionManager.tickVisibleRenders();
        profiler.m_7238_();
        Entity.m_20103_((double)(Mth.m_14008_((double)((double)this.client.f_91066_.m_193772_() / 8.0), (double)1.0, (double)2.5) * (Double)this.client.f_91066_.m_232018_().m_231551_()));
    }

    private void processChunkEvents() {
        ChunkTracker tracker = ChunkTrackerHolder.get(this.world);
        tracker.forEachEvent(this.renderSectionManager::onChunkAdded, this.renderSectionManager::onChunkRemoved);
    }

    public void drawChunkLayer(RenderType renderLayer, PoseStack matrixStack, double x, double y, double z) {
        ChunkRenderMatrices matrices = ChunkRenderMatrices.from(matrixStack);
        if (renderLayer == RenderType.m_110451_()) {
            this.renderSectionManager.renderLayer(matrices, DefaultTerrainRenderPasses.SOLID, x, y, z);
            this.renderSectionManager.renderLayer(matrices, DefaultTerrainRenderPasses.CUTOUT, x, y, z);
        } else if (renderLayer == RenderType.m_110466_()) {
            this.renderSectionManager.renderLayer(matrices, DefaultTerrainRenderPasses.TRANSLUCENT, x, y, z);
        }
    }

    public void reload() {
        if (this.world == null) {
            return;
        }
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    private void initRenderer(CommandList commandList) {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.destroy();
            this.renderSectionManager = null;
        }
        this.renderDistance = this.client.f_91066_.m_193772_();
        this.renderSectionManager = new RenderSectionManager(this.world, this.renderDistance, commandList);
        ChunkTracker tracker = ChunkTrackerHolder.get(this.world);
        ChunkTracker.forEachChunk(tracker.getReadyChunks(), this.renderSectionManager::onChunkAdded);
        Window window = Minecraft.m_91087_().m_91268_();
        if (window != null) {
            window.m_85409_(((Boolean)Minecraft.m_91087_().f_91066_.m_231817_().m_231551_()).booleanValue());
        }
        BlendedColorProvider.checkBlendingEnabled();
    }

    public boolean didBlockEntityRequestOutline() {
        return this.blockEntityRequestedOutline;
    }

    public void forEachVisibleBlockEntity(Consumer<BlockEntity> consumer) {
        SortedRenderLists renderLists = this.renderSectionManager.getRenderLists();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                BlockEntity[] blockEntities = renderSection.getCulledBlockEntities();
                if (blockEntities == null) continue;
                for (BlockEntity blockEntity : blockEntities) {
                    consumer.accept(blockEntity);
                }
            }
        }
        for (RenderSection renderSection : this.renderSectionManager.getSectionsWithGlobalEntities()) {
            BlockEntity[] blockEntities = renderSection.getGlobalBlockEntities();
            if (blockEntities == null) continue;
            for (BlockEntity blockEntity : blockEntities) {
                consumer.accept(blockEntity);
            }
        }
    }

    public void renderBlockEntities(PoseStack matrices, RenderBuffers bufferBuilders, Long2ObjectMap<SortedSet<BlockDestructionProgress>> blockBreakingProgressions, Camera camera, float tickDelta) {
        MultiBufferSource.BufferSource immediate = bufferBuilders.m_110104_();
        Vec3 cameraPos = camera.m_90583_();
        double x = cameraPos.m_7096_();
        double y = cameraPos.m_7098_();
        double z = cameraPos.m_7094_();
        BlockEntityRenderDispatcher blockEntityRenderer = Minecraft.m_91087_().m_167982_();
        this.blockEntityRequestedOutline = false;
        this.renderBlockEntities(matrices, bufferBuilders, blockBreakingProgressions, tickDelta, immediate, x, y, z, blockEntityRenderer);
        this.renderGlobalBlockEntities(matrices, bufferBuilders, blockBreakingProgressions, tickDelta, immediate, x, y, z, blockEntityRenderer);
    }

    private void renderBlockEntities(PoseStack matrices, RenderBuffers bufferBuilders, Long2ObjectMap<SortedSet<BlockDestructionProgress>> blockBreakingProgressions, float tickDelta, MultiBufferSource.BufferSource immediate, double x, double y, double z, BlockEntityRenderDispatcher blockEntityRenderer) {
        SortedRenderLists renderLists = this.renderSectionManager.getRenderLists();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                BlockEntity[] blockEntities = renderSection.getCulledBlockEntities();
                if (blockEntities == null) continue;
                for (BlockEntity blockEntity : blockEntities) {
                    if (ENABLE_BLOCKENTITY_CULLING && !this.currentViewport.isBoxVisible(blockEntity.getRenderBoundingBox())) continue;
                    if (blockEntity.hasCustomOutlineRendering((Player)this.client.f_91074_)) {
                        this.blockEntityRequestedOutline = true;
                    }
                    SodiumWorldRenderer.renderBlockEntity(matrices, bufferBuilders, blockBreakingProgressions, tickDelta, immediate, x, y, z, blockEntityRenderer, blockEntity);
                }
            }
        }
    }

    private void renderGlobalBlockEntities(PoseStack matrices, RenderBuffers bufferBuilders, Long2ObjectMap<SortedSet<BlockDestructionProgress>> blockBreakingProgressions, float tickDelta, MultiBufferSource.BufferSource immediate, double x, double y, double z, BlockEntityRenderDispatcher blockEntityRenderer) {
        for (RenderSection renderSection : this.renderSectionManager.getSectionsWithGlobalEntities()) {
            BlockEntity[] blockEntities = renderSection.getGlobalBlockEntities();
            if (blockEntities == null) continue;
            for (BlockEntity blockEntity : blockEntities) {
                if (ENABLE_BLOCKENTITY_CULLING && !this.currentViewport.isBoxVisible(blockEntity.getRenderBoundingBox())) continue;
                if (blockEntity.hasCustomOutlineRendering((Player)this.client.f_91074_)) {
                    this.blockEntityRequestedOutline = true;
                }
                SodiumWorldRenderer.renderBlockEntity(matrices, bufferBuilders, blockBreakingProgressions, tickDelta, immediate, x, y, z, blockEntityRenderer, blockEntity);
            }
        }
    }

    private static void renderBlockEntity(PoseStack matrices, RenderBuffers bufferBuilders, Long2ObjectMap<SortedSet<BlockDestructionProgress>> blockBreakingProgressions, float tickDelta, MultiBufferSource.BufferSource immediate, double x, double y, double z, BlockEntityRenderDispatcher dispatcher, BlockEntity entity) {
        int stage;
        BlockPos pos = entity.m_58899_();
        matrices.m_85836_();
        matrices.m_85837_((double)pos.m_123341_() - x, (double)pos.m_123342_() - y, (double)pos.m_123343_() - z);
        MultiBufferSource.BufferSource consumer = immediate;
        SortedSet breakingInfo = (SortedSet)blockBreakingProgressions.get(pos.m_121878_());
        if (breakingInfo != null && !breakingInfo.isEmpty() && (stage = ((BlockDestructionProgress)breakingInfo.last()).m_139988_()) >= 0) {
            VertexConsumer bufferBuilder = bufferBuilders.m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(stage));
            PoseStack.Pose entry = matrices.m_85850_();
            SheetedDecalTextureGenerator transformer = new SheetedDecalTextureGenerator(bufferBuilder, entry.m_252922_(), entry.m_252943_(), 1.0f);
            consumer = arg_0 -> SodiumWorldRenderer.lambda$renderBlockEntity$0((VertexConsumer)transformer, immediate, arg_0);
        }
        try {
            dispatcher.m_112267_(entity, tickDelta, matrices, (MultiBufferSource)consumer);
        }
        catch (RuntimeException e) {
            if (!entity.m_58901_()) {
                throw e;
            }
            SodiumClientMod.logger().error("Suppressing crash from removed block entity", (Throwable)e);
        }
        matrices.m_85849_();
    }

    private static boolean isInfiniteExtentsBox(AABB box) {
        return Double.isInfinite(box.f_82288_) || Double.isInfinite(box.f_82289_) || Double.isInfinite(box.f_82290_) || Double.isInfinite(box.f_82291_) || Double.isInfinite(box.f_82292_) || Double.isInfinite(box.f_82293_);
    }

    public boolean isEntityVisible(Entity entity) {
        if (!this.useEntityCulling) {
            return true;
        }
        if (this.client.m_91314_(entity) || entity.m_6052_()) {
            return true;
        }
        AABB box = entity.m_6921_();
        if (SodiumWorldRenderer.isInfiniteExtentsBox(box)) {
            return true;
        }
        double entityVolume = (box.f_82291_ - box.f_82288_) * (box.f_82292_ - box.f_82289_) * (box.f_82293_ - box.f_82290_);
        if (entityVolume > 61440.0) {
            return true;
        }
        return this.isBoxVisible(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
    }

    public boolean isBoxVisible(double x1, double y1, double z1, double x2, double y2, double z2) {
        if (y2 < (double)this.world.m_141937_() + 0.5 || y1 > (double)this.world.m_151558_() - 0.5) {
            return true;
        }
        int minX = SectionPos.m_175552_((double)(x1 - 0.5));
        int minY = SectionPos.m_175552_((double)(y1 - 0.5));
        int minZ = SectionPos.m_175552_((double)(z1 - 0.5));
        int maxX = SectionPos.m_175552_((double)(x2 + 0.5));
        int maxY = SectionPos.m_175552_((double)(y2 + 0.5));
        int maxZ = SectionPos.m_175552_((double)(z2 + 0.5));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!this.renderSectionManager.isSectionVisible(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getChunksDebugString() {
        return String.format("C: %d/%d D: %d", this.renderSectionManager.getVisibleChunkCount(), this.renderSectionManager.getTotalSections(), this.renderDistance);
    }

    public void scheduleRebuildForBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        this.scheduleRebuildForChunks(minX >> 4, minY >> 4, minZ >> 4, maxX >> 4, maxY >> 4, maxZ >> 4, important);
    }

    public void scheduleRebuildForChunks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkY = minY; chunkY <= maxY; ++chunkY) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.scheduleRebuildForChunk(chunkX, chunkY, chunkZ, important);
                }
            }
        }
    }

    public void scheduleRebuildForChunk(int x, int y, int z, boolean important) {
        this.renderSectionManager.scheduleRebuild(x, y, z, important);
    }

    public Collection<String> getDebugStrings() {
        return this.renderSectionManager.getDebugStrings();
    }

    public boolean isSectionReady(int x, int y, int z) {
        return this.renderSectionManager.isSectionBuilt(x, y, z);
    }

    @Deprecated
    public void onChunkAdded(int x, int z) {
        ChunkTracker tracker = ChunkTrackerHolder.get(this.world);
        tracker.onChunkStatusAdded(x, z, 1);
    }

    @Deprecated
    public void onChunkLightAdded(int x, int z) {
        ChunkTracker tracker = ChunkTrackerHolder.get(this.world);
        tracker.onChunkStatusAdded(x, z, 2);
    }

    @Deprecated
    public void onChunkRemoved(int x, int z) {
        ChunkTracker tracker = ChunkTrackerHolder.get(this.world);
        tracker.onChunkStatusRemoved(x, z, 3);
    }

    private static /* synthetic */ VertexConsumer lambda$renderBlockEntity$0(VertexConsumer transformer, MultiBufferSource.BufferSource immediate, RenderType layer) {
        return layer.m_110405_() ? VertexMultiConsumer.m_86168_((VertexConsumer)transformer, (VertexConsumer)immediate.m_6299_(layer)) : immediate.m_6299_(layer);
    }
}

