/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.color;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.color.DefaultColorProviders;
import me.jellysquid.mods.sodium.client.model.color.interop.BlockColorsExtended;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class ColorProviderRegistry {
    private final Reference2ReferenceMap<Block, ColorProvider<BlockState>> blocks = new Reference2ReferenceOpenHashMap();
    private final Reference2ReferenceMap<Fluid, ColorProvider<FluidState>> fluids = new Reference2ReferenceOpenHashMap();
    private final ReferenceSet<Block> overridenBlocks;

    public ColorProviderRegistry(BlockColors blockColors) {
        Reference2ReferenceMap<Block, BlockColor> providers = BlockColorsExtended.getProviders(blockColors);
        for (Reference2ReferenceMap.Entry entry : providers.reference2ReferenceEntrySet()) {
            this.blocks.put((Object)((Block)entry.getKey()), DefaultColorProviders.adapt((BlockColor)entry.getValue()));
        }
        this.overridenBlocks = BlockColorsExtended.getOverridenVanillaBlocks(blockColors);
        this.installOverrides();
    }

    private void installOverrides() {
        this.registerBlocks(new DefaultColorProviders.VertexBlendedBiomeColorAdapter<BlockState>(BiomeColors::m_108793_), Blocks.f_50440_, Blocks.f_50035_, Blocks.f_50034_, Blocks.f_50231_, Blocks.f_271445_, Blocks.f_50130_, Blocks.f_50360_, Blocks.f_50359_);
        this.registerBlocks(new DefaultColorProviders.VertexBlendedBiomeColorAdapter<BlockState>(BiomeColors::m_108804_), Blocks.f_50050_, Blocks.f_50053_, Blocks.f_50054_, Blocks.f_50055_, Blocks.f_50191_, Blocks.f_220838_);
        this.registerBlocks(new DefaultColorProviders.VertexBlendedBiomeColorAdapter<BlockState>(BiomeColors::m_108811_), Blocks.f_49990_, Blocks.f_50628_);
        this.registerFluids(new DefaultColorProviders.VertexBlendedBiomeColorAdapter<FluidState>(BiomeColors::m_108811_), new Fluid[]{Fluids.f_76193_, Fluids.f_76192_});
    }

    private void registerBlocks(ColorProvider<BlockState> resolver, Block ... blocks) {
        for (Block block : blocks) {
            if (this.overridenBlocks.contains((Object)block)) continue;
            this.blocks.put((Object)block, resolver);
        }
    }

    private void registerFluids(ColorProvider<FluidState> resolver, Fluid ... fluids) {
        for (Fluid fluid : fluids) {
            this.fluids.put((Object)fluid, resolver);
        }
    }

    public ColorProvider<BlockState> getColorProvider(Block block) {
        return (ColorProvider)this.blocks.get((Object)block);
    }

    public ColorProvider<FluidState> getColorProvider(Fluid fluid) {
        return (ColorProvider)this.fluids.get((Object)fluid);
    }
}

