/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block.entity;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import de.cristelknight.doapi.common.util.GeneralUtil;
import de.cristelknight.doapi.common.world.ImplementedInventory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.brewery.block.brew_event.BrewEvent;
import net.satisfy.brewery.block.brew_event.BrewEvents;
import net.satisfy.brewery.block.brew_event.BrewHelper;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.block.property.Heat;
import net.satisfy.brewery.block.property.Liquid;
import net.satisfy.brewery.entity.BeerElementalEntity;
import net.satisfy.brewery.item.DrinkBlockItem;
import net.satisfy.brewery.recipe.BrewingRecipe;
import net.satisfy.brewery.registry.BlockEntityRegistry;
import net.satisfy.brewery.registry.BlockStateRegistry;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.registry.RecipeTypeRegistry;
import net.satisfy.brewery.util.BreweryMath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewstationBlockEntity
extends BlockEntity
implements ImplementedInventory,
BlockEntityTicker<BrewstationBlockEntity> {
    @NotNull
    private Set<BlockPos> components = new HashSet<BlockPos>(4);
    private static final int MAX_BREW_TIME = 1200;
    private static final int MIN_TIME_FOR_EVENT = 100;
    private static final int MAX_TIME_FOR_EVENT = 300;
    private static final int SOUND_DURATION = 60;
    private int soundTime;
    private int brewTime;
    private int timeToNextEvent = Integer.MIN_VALUE;
    private final Set<BrewEvent> runningEvents = new HashSet<BrewEvent>();
    private int solved;
    private int totalEvents;
    private NonNullList<ItemStack> ingredients;
    private ItemStack beer = ItemStack.f_41583_;
    private final SoundEvent spawnEntitySound = (SoundEvent)DoApiSoundEventRegistry.BREWSTATION_PROCESS_FAILED.get();

    public BrewstationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.BREWINGSTATION_BLOCK_ENTITY.get(), blockPos, blockState);
        this.ingredients = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    }

    public void updateInClientWorld() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().m_8450_(this.m_58899_());
        }
    }

    public void setComponents(BlockPos ... components) {
        if (components.length != 4) {
            return;
        }
        this.components.addAll(Arrays.asList(components));
    }

    public InteractionResult addIngredient(ItemStack itemStack) {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = (ItemStack)this.ingredients.get(i);
            if (!stack.m_41619_()) continue;
            this.m_6836_(i, itemStack.m_41620_(1));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public ItemStack getBeer() {
        if (this.beer.m_41619_()) {
            return null;
        }
        ItemStack beerStack = this.beer.m_41777_();
        beerStack.m_41764_(1);
        this.beer.m_41774_(1);
        if (this.beer.m_41619_() && this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.EMPTY)));
        }
        return beerStack;
    }

    @Nullable
    public ItemStack removeIngredient() {
        for (int i = 0; i < 3; ++i) {
            ItemStack itemStack = (ItemStack)this.ingredients.get(i);
            if (itemStack.m_41619_()) continue;
            this.ingredients.set(i, (Object)ItemStack.f_41583_);
            return itemStack;
        }
        return null;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, BrewstationBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!this.beer.m_41619_()) {
            return;
        }
        Recipe recipe = level.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.BREWING_RECIPE_TYPE.get(), (Container)this, level).orElse(null);
        if (!this.canBrew(recipe)) {
            this.endBrewing();
            return;
        }
        if (this.soundTime >= 60) {
            assert (this.f_58857_ != null);
            level.m_5594_(null, blockPos, (SoundEvent)DoApiSoundEventRegistry.BREWSTATION_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.soundTime = 0;
        }
        ++this.soundTime;
        if (this.timeToNextEvent == Integer.MIN_VALUE) {
            this.setTimeToEvent();
        }
        BrewHelper.checkRunningEvents(this);
        int timeLeft = 1200 - this.brewTime;
        if (this.brewTime >= 1200) {
            RegistryAccess access = level.m_9598_();
            this.brew(recipe, access);
        } else if (timeLeft >= 100 && this.timeToNextEvent <= 0 && this.runningEvents.size() < BrewEvents.BREW_EVENTS.size()) {
            ResourceLocation eventId;
            BrewEvent event = BrewHelper.getRdmEvent(this);
            if (event != null && (eventId = BrewEvents.getId(event)) != null) {
                event.start(this.components, level);
                this.runningEvents.add(event);
                ++this.totalEvents;
            }
            this.setTimeToEvent();
        }
        ++this.brewTime;
        --this.timeToNextEvent;
    }

    private void setTimeToEvent() {
        if (this.f_58857_ != null) {
            this.timeToNextEvent = BreweryMath.getRandomHighNumber(this.f_58857_.m_213780_(), 100, 300);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canBrew(Recipe<?> recipe) {
        if (recipe == null) return false;
        if (this.f_58857_ == null) {
            return false;
        }
        if (!(recipe instanceof BrewingRecipe)) return false;
        BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
        if (((BrewMaterial)((Object)this.f_58857_.m_8055_(this.m_58899_()).m_61143_(BlockStateRegistry.MATERIAL))).getLevel() < brewingRecipe.getMaterial().getLevel()) return false;
        if (this.f_58857_.m_8055_(this.m_58899_()).m_61143_(BlockStateRegistry.LIQUID) == Liquid.EMPTY) return false;
        if (this.f_58857_.m_8055_(BrewHelper.getBlock((Block)ObjectRegistry.BREW_OVEN.get(), this.components, this.f_58857_)).m_61143_(BlockStateRegistry.HEAT) == Heat.OFF) return false;
        return true;
    }

    private void brew(Recipe<?> recipe, RegistryAccess access) {
        ItemStack resultStack = recipe.m_8043_(access);
        Item item = resultStack.m_41720_();
        if (item instanceof DrinkBlockItem) {
            DrinkBlockItem drinkItem = (DrinkBlockItem)item;
            assert (this.f_58857_ != null);
            int quality = this.f_58857_.m_8055_(this.m_58899_()).m_61143_(BlockStateRegistry.MATERIAL) == BrewMaterial.NETHERITE ? 3 : this.solved;
            DrinkBlockItem.addQuality(resultStack, quality);
            drinkItem.addCount(resultStack, this.solved == 0 ? 1 : this.solved);
        }
        this.beer = resultStack;
        this.spawnElementals();
        this.endBrewing();
        if (this.f_58857_ != null) {
            BlockState blockState = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)blockState.m_61124_(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.BEER)));
            BlockPos ovenPos = BrewHelper.getBlock((Block)ObjectRegistry.BREW_OVEN.get(), this.components, this.f_58857_);
            BlockState ovenState = this.f_58857_.m_8055_(ovenPos);
            this.f_58857_.m_46597_(ovenPos, (BlockState)ovenState.m_61124_(BlockStateRegistry.HEAT, (Comparable)((Object)Heat.OFF)));
            BlockPos timerPos = BrewHelper.getBlock((Block)ObjectRegistry.BREW_TIMER.get(), this.components, this.f_58857_);
            BlockState timerState = this.f_58857_.m_8055_(timerPos);
            this.f_58857_.m_46597_(timerPos, (BlockState)timerState.m_61124_((Property)BlockStateRegistry.TIME, (Comparable)Boolean.valueOf(false)));
        }
        block0: for (Ingredient ingredient : recipe.m_7527_()) {
            for (int i = 0; i < 3; ++i) {
                ItemStack itemStack = (ItemStack)this.ingredients.get(i);
                if (!ingredient.test(itemStack)) continue;
                this.m_7407_(i, 1);
                continue block0;
            }
        }
    }

    private void spawnElementals() {
        BlockPos spawnPos;
        assert (this.f_58857_ != null);
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_());
        if (this.solved == 0 && this.f_58857_ != null && this.f_58857_.f_46441_.m_188500_() >= 0.1 && blockState.m_61143_(BlockStateRegistry.MATERIAL) == BrewMaterial.WOOD && (spawnPos = BrewHelper.getBlock((Block)ObjectRegistry.BREW_OVEN.get(), this.components, this.f_58857_)) != null) {
            BeerElementalEntity beerElemental = new BeerElementalEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.BEER_ELEMENTAL.get()), this.f_58857_);
            beerElemental.m_6034_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
            this.f_58857_.m_7967_((Entity)beerElemental);
            this.f_58857_.m_5594_(null, spawnPos, this.spawnEntitySound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void endBrewing() {
        BrewHelper.finishEvents(this);
        this.solved = 0;
        this.brewTime = 0;
        this.totalEvents = 0;
        this.soundTime = 60;
        this.timeToNextEvent = Integer.MIN_VALUE;
    }

    public boolean isPartOf(BlockPos blockPos) {
        return this.components.contains(blockPos);
    }

    public void m_183515_(CompoundTag compoundTag) {
        if (!this.components.isEmpty()) {
            GeneralUtil.putBlockPoses((CompoundTag)compoundTag, this.components);
        }
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.ingredients);
        compoundTag.m_128365_("beer", (Tag)this.beer.m_41739_(new CompoundTag()));
        compoundTag.m_128405_("solved", this.solved);
        compoundTag.m_128405_("brewTime", this.brewTime);
        compoundTag.m_128405_("totalEvents", this.totalEvents);
        compoundTag.m_128405_("timeToNextEvent", this.timeToNextEvent);
        BrewHelper.saveAdditional(this, compoundTag);
    }

    public void m_142466_(CompoundTag compoundTag) {
        this.components = GeneralUtil.readBlockPoses((CompoundTag)compoundTag);
        this.ingredients = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.ingredients);
        if (compoundTag.m_128441_("beer")) {
            this.beer = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("beer"));
        }
        this.solved = compoundTag.m_128451_("solved");
        this.brewTime = compoundTag.m_128451_("brewTime");
        this.totalEvents = compoundTag.m_128451_("totalEvents");
        this.timeToNextEvent = compoundTag.m_128451_("timeToNextEvent");
        BrewHelper.load(this, compoundTag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public void growSolved() {
        ++this.solved;
    }

    public Set<BrewEvent> getRunningEvents() {
        return this.runningEvents;
    }

    @NotNull
    public Set<BlockPos> getComponents() {
        return this.components;
    }

    public List<ItemStack> getIngredient() {
        return this.ingredients;
    }

    public NonNullList<ItemStack> getItems() {
        return this.ingredients;
    }

    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }
}

