/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.monsterplus.common.entity.projectiles;

import com.nitespring.monsterplus.core.init.EntityInit;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class CrystalSpikes
extends Entity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int lifeTicks = 22;
    private boolean clientSideAttackStarted;
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private float damage;
    public int xTilt;
    public int zTilt;
    public int rotationModifier;

    public CrystalSpikes(EntityType<? extends CrystalSpikes> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public CrystalSpikes(Level worldIn, float damageIn, double posX, double posY, double posZ, float p_36930_, int warmUpDelayTicks, LivingEntity ownerIn) {
        this((EntityType<? extends CrystalSpikes>)((EntityType)EntityInit.CRYSTAL_SPIKES.get()), worldIn);
        this.warmupDelayTicks = warmUpDelayTicks;
        this.setOwner(ownerIn);
        this.m_146922_(p_36930_ * 57.295776f);
        this.m_6034_(posX, posY, posZ);
        this.damage = damageIn;
    }

    public CrystalSpikes(Level worldIn, float damageIn, double posX, double posY, double posZ, float p_36930_, int warmUpDelayTicks, LivingEntity ownerIn, int xTilt, int zTilt) {
        this((EntityType<? extends CrystalSpikes>)((EntityType)EntityInit.CRYSTAL_SPIKES.get()), worldIn);
        this.warmupDelayTicks = warmUpDelayTicks;
        this.setOwner(ownerIn);
        this.m_146922_(p_36930_ * 57.295776f);
        this.m_6034_(posX, posY, posZ);
        this.damage = damageIn;
        this.xTilt = xTilt;
        this.zTilt = zTilt;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_20052_) {
        this.warmupDelayTicks = p_20052_.m_128451_("Warmup");
        if (p_20052_.m_128403_("Owner")) {
            this.ownerUUID = p_20052_.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag p_20139_) {
        p_20139_.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            p_20139_.m_128362_("Owner", this.ownerUUID);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public float getAnimationProgress(float p_36937_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_36937_) / 20.0f;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.xTilt = new Random().nextInt(30) - 14;
        this.zTilt = new Random().nextInt(30) - 14;
        this.m_146922_(new Random().nextInt(360) + 1);
        this.rotationModifier = new Random().nextBoolean() ? (new Random().nextInt(2) + 1) / 2 : (new Random().nextInt(2) - 2) / 2;
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d1 = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
                        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d3 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.f_19796_.m_188500_() * 0.3;
                        double d5 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123784_, d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -4) {
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
                    this.dealDamageTo(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    private void dealDamageTo(LivingEntity p_36945_) {
        LivingEntity livingentity = this.getOwner();
        if (p_36945_.m_6084_() && !p_36945_.m_20147_() && p_36945_ != livingentity) {
            if (livingentity == null) {
                p_36945_.m_6469_(this.m_9236_().m_269111_().m_269425_(), 6.0f);
            } else {
                if (livingentity.m_7307_((Entity)p_36945_)) {
                    return;
                }
                p_36945_.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)this, (Entity)livingentity), this.damage);
            }
        }
    }

    public void m_7822_(byte p_36935_) {
        super.m_7822_(p_36935_);
        if (p_36935_ == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }
}

