/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.init.PSTItemBonuses;
import daripher.skilltree.skill.bonus.item.ItemBonus;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class FoodSaturationBonus
implements ItemBonus<FoodSaturationBonus> {
    private float multiplier;

    public FoodSaturationBonus(float multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public boolean canMerge(ItemBonus<?> other) {
        return other instanceof FoodSaturationBonus;
    }

    @Override
    public FoodSaturationBonus merge(ItemBonus<?> other) {
        if (!(other instanceof FoodSaturationBonus)) {
            throw new IllegalArgumentException();
        }
        FoodSaturationBonus otherBonus = (FoodSaturationBonus)other;
        return new FoodSaturationBonus(this.multiplier + otherBonus.multiplier);
    }

    @Override
    public FoodSaturationBonus copy() {
        return new FoodSaturationBonus(this.multiplier);
    }

    @Override
    public FoodSaturationBonus multiply(double multiplier) {
        return new FoodSaturationBonus((float)(multiplier * multiplier));
    }

    @Override
    public ItemBonus.Serializer getSerializer() {
        return (ItemBonus.Serializer)PSTItemBonuses.FOOD_SATURATION.get();
    }

    @Override
    public MutableComponent getTooltip() {
        return TooltipHelper.getSkillBonusTooltip(this.getDescriptionId(), (double)this.multiplier, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    @Override
    public boolean isPositive() {
        return this.multiplier > 0.0f;
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, int index, Consumer<ItemBonus<?>> consumer) {
        editor.addLabel(0, 0, "Multiplier", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addNumericTextField(0, 0, 90, 14, this.getMultiplier()).setNumericResponder(v -> {
            this.setMultiplier(v.floatValue());
            consumer.accept(this);
        });
        editor.shiftWidgets(0, 19);
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FoodSaturationBonus that = (FoodSaturationBonus)obj;
        return Float.floatToIntBits(this.multiplier) == Float.floatToIntBits(that.multiplier);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.multiplier));
    }

    public static class Serializer
    implements ItemBonus.Serializer {
        @Override
        public ItemBonus<?> deserialize(JsonObject json) throws JsonParseException {
            float multiplier = json.get("multiplier").getAsFloat();
            return new FoodSaturationBonus(multiplier);
        }

        @Override
        public void serialize(JsonObject json, ItemBonus<?> bonus) {
            if (!(bonus instanceof FoodSaturationBonus)) {
                throw new IllegalArgumentException();
            }
            FoodSaturationBonus aBonus = (FoodSaturationBonus)bonus;
            json.addProperty("multiplier", (Number)Float.valueOf(aBonus.multiplier));
        }

        @Override
        public ItemBonus<?> deserialize(CompoundTag tag) {
            float multiplier = tag.m_128457_("multiplier");
            return new FoodSaturationBonus(multiplier);
        }

        @Override
        public CompoundTag serialize(ItemBonus<?> bonus) {
            if (!(bonus instanceof FoodSaturationBonus)) {
                throw new IllegalArgumentException();
            }
            FoodSaturationBonus aBonus = (FoodSaturationBonus)bonus;
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("multiplier", aBonus.multiplier);
            return tag;
        }

        @Override
        public ItemBonus<?> deserialize(FriendlyByteBuf buf) {
            return new FoodSaturationBonus(buf.readFloat());
        }

        @Override
        public void serialize(FriendlyByteBuf buf, ItemBonus<?> bonus) {
            if (!(bonus instanceof FoodSaturationBonus)) {
                throw new IllegalArgumentException();
            }
            FoodSaturationBonus aBonus = (FoodSaturationBonus)bonus;
            buf.writeFloat(aBonus.multiplier);
        }

        @Override
        public ItemBonus<?> createDefaultInstance() {
            return new FoodSaturationBonus(0.1f);
        }
    }
}

