/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.condition.living;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.screen.SkillTreeEditorScreen;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.entity.player.PlayerHelper;
import daripher.skilltree.init.PSTItemConditions;
import daripher.skilltree.init.PSTLivingConditions;
import daripher.skilltree.item.gem.GemItem;
import daripher.skilltree.network.NetworkHelper;
import daripher.skilltree.skill.bonus.condition.item.ItemCondition;
import daripher.skilltree.skill.bonus.condition.item.NoneItemCondition;
import daripher.skilltree.skill.bonus.condition.living.LivingCondition;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public final class HasGemsCondition
implements LivingCondition {
    private int min;
    private int max;
    @Nonnull
    private ItemCondition itemCondition;

    public HasGemsCondition(int min, int max, @Nonnull ItemCondition itemCondition) {
        this.min = min;
        this.max = max;
        this.itemCondition = itemCondition;
    }

    @Override
    public boolean met(LivingEntity living) {
        int gems = this.getGems(PlayerHelper.getAllEquipment(living).filter(this.itemCondition::met));
        if (this.min == -1) {
            return gems <= this.max;
        }
        if (this.max == -1) {
            return gems >= this.min;
        }
        return gems <= this.max && gems >= this.min;
    }

    private int getGems(Stream<ItemStack> items) {
        return items.map(GemItem::getGems).map(List::size).reduce(Integer::sum).orElse(0);
    }

    @Override
    public MutableComponent getTooltip(MutableComponent bonusTooltip, String target) {
        String key = this.getDescriptionId();
        MutableComponent targetDescription = Component.m_237115_((String)"%s.target.%s".formatted(key, target));
        Component itemDescription = this.itemCondition.getTooltip("where");
        if (this.min == -1) {
            return Component.m_237110_((String)(key + ".max"), (Object[])new Object[]{bonusTooltip, targetDescription, this.max, itemDescription});
        }
        if (this.max == -1) {
            if (this.min == 1) {
                return Component.m_237110_((String)(key + ".min.1"), (Object[])new Object[]{bonusTooltip, targetDescription, itemDescription});
            }
            return Component.m_237110_((String)(key + ".min"), (Object[])new Object[]{bonusTooltip, targetDescription, this.min, itemDescription});
        }
        return Component.m_237110_((String)(key + ".range"), (Object[])new Object[]{bonusTooltip, targetDescription, this.min, this.max, itemDescription});
    }

    @Override
    public LivingCondition.Serializer getSerializer() {
        return (LivingCondition.Serializer)PSTLivingConditions.HAS_GEMS.get();
    }

    @Override
    public void addEditorWidgets(SkillTreeEditorScreen editor, Consumer<LivingCondition> consumer) {
        editor.addLabel(0, 0, "Item Condition", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addDropDownList(0, 0, 200, 14, 10, this.itemCondition, PSTItemConditions.conditionsList()).setToNameFunc(a -> Component.m_237115_((String)PSTItemConditions.getName(a))).setResponder(c -> {
            this.setItemCondition((ItemCondition)c);
            consumer.accept(this);
            editor.m_232761_();
        });
        editor.shiftWidgets(0, 19);
        this.itemCondition.addEditorWidgets(editor, (ItemCondition c) -> {
            this.setItemCondition((ItemCondition)c);
            consumer.accept(this);
        });
        editor.addLabel(0, 0, "Min", ChatFormatting.GREEN);
        editor.addLabel(55, 0, "Max", ChatFormatting.GREEN);
        editor.shiftWidgets(0, 19);
        editor.addNumericTextField(0, 0, 50, 14, this.min).setNumericResponder(a -> {
            this.setMin(a.intValue());
            consumer.accept(this);
        });
        editor.addNumericTextField(55, 0, 50, 14, this.max).setNumericResponder(a -> {
            this.setMax(a.intValue());
            consumer.accept(this);
        });
        editor.shiftWidgets(0, 19);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasGemsCondition that = (HasGemsCondition)o;
        return this.min == that.min && this.max == that.max && Objects.equals(this.itemCondition, that.itemCondition);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.itemCondition);
    }

    public void setItemCondition(@Nonnull ItemCondition itemCondition) {
        this.itemCondition = itemCondition;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public static class Serializer
    implements LivingCondition.Serializer {
        @Override
        public LivingCondition deserialize(JsonObject json) throws JsonParseException {
            int min = json.has("min") ? json.get("min").getAsInt() : -1;
            int max = json.has("max") ? json.get("max").getAsInt() : -1;
            ItemCondition itemCondition = SerializationHelper.deserializeItemCondition(json);
            return new HasGemsCondition(min, max, itemCondition);
        }

        @Override
        public void serialize(JsonObject json, LivingCondition condition) {
            if (!(condition instanceof HasGemsCondition)) {
                throw new IllegalArgumentException();
            }
            HasGemsCondition aCondition = (HasGemsCondition)condition;
            if (aCondition.min != -1) {
                json.addProperty("min", (Number)aCondition.min);
            }
            if (aCondition.max != -1) {
                json.addProperty("max", (Number)aCondition.max);
            }
            SerializationHelper.serializeItemCondition(json, aCondition.itemCondition);
        }

        @Override
        public LivingCondition deserialize(CompoundTag tag) {
            int min = tag.m_128441_("min") ? tag.m_128451_("min") : -1;
            int max = tag.m_128441_("max") ? tag.m_128451_("max") : -1;
            ItemCondition itemCondition = SerializationHelper.deserializeItemCondition(tag);
            return new HasGemsCondition(min, max, itemCondition);
        }

        @Override
        public CompoundTag serialize(LivingCondition condition) {
            if (!(condition instanceof HasGemsCondition)) {
                throw new IllegalArgumentException();
            }
            HasGemsCondition aCondition = (HasGemsCondition)condition;
            CompoundTag tag = new CompoundTag();
            if (aCondition.min != -1) {
                tag.m_128405_("min", aCondition.min);
            }
            if (aCondition.max != -1) {
                tag.m_128405_("max", aCondition.max);
            }
            SerializationHelper.serializeItemCondition(tag, aCondition.itemCondition);
            return tag;
        }

        @Override
        public LivingCondition deserialize(FriendlyByteBuf buf) {
            return new HasGemsCondition(buf.readInt(), buf.readInt(), NetworkHelper.readItemCondition(buf));
        }

        @Override
        public void serialize(FriendlyByteBuf buf, LivingCondition condition) {
            if (!(condition instanceof HasGemsCondition)) {
                throw new IllegalArgumentException();
            }
            HasGemsCondition aCondition = (HasGemsCondition)condition;
            buf.writeInt(aCondition.min);
            buf.writeInt(aCondition.max);
            NetworkHelper.writeItemCondition(buf, aCondition.itemCondition);
        }

        @Override
        public LivingCondition createDefaultInstance() {
            return new HasGemsCondition(1, -1, NoneItemCondition.INSTANCE);
        }
    }
}

