/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.compat.apotheosis;

import com.google.common.collect.ImmutableList;
import daripher.skilltree.compat.apotheosis.gem.PSTGemBonus;
import daripher.skilltree.entity.player.PlayerHelper;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.skill.bonus.item.ItemBonus;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.event.GetItemSocketsEvent;
import dev.shadowsoffire.apotheosis.adventure.loot.GemLootPoolEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;

public enum ApotheosisCompatibility {
    INSTANCE;


    public void register() {
        GemBonus.CODEC.register(new ResourceLocation("skilltree", "gem_bonus"), PSTGemBonus.CODEC);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::addItemSockets);
    }

    public List<ItemStack> getGems(ItemStack stack, int sockets) {
        if (sockets == 0 || stack.m_41619_()) {
            return Collections.emptyList();
        }
        NonNullList gems = NonNullList.m_122780_((int)sockets, (Object)ItemStack.f_41583_);
        int i = 0;
        CompoundTag afxData = stack.m_41737_("affix_data");
        if (afxData != null && afxData.m_128441_("gems")) {
            ListTag gemData = afxData.m_128437_("gems", 10);
            for (Tag tag : gemData) {
                ItemStack gemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
                gemStack.m_41764_(1);
                if (GemInstance.unsocketed((ItemStack)gemStack).isValidUnsocketed()) {
                    gems.set(i++, gemStack);
                }
                if (i < sockets) continue;
                break;
            }
        }
        return ImmutableList.copyOf((Collection)gems);
    }

    public List<? extends ItemBonus<?>> getGemBonuses(ItemStack stack) {
        ArrayList list = new ArrayList();
        block0: for (ItemStack gemStack : SocketHelper.getGems((ItemStack)stack)) {
            DynamicHolder gem = GemItem.getGem((ItemStack)gemStack);
            if (!gem.isBound()) continue;
            List bonuses = ((Gem)gem.get()).getBonuses();
            for (GemBonus gemBonus : bonuses) {
                Set lootCategories = gemBonus.getGemClass().types();
                if (lootCategories.stream().noneMatch(c -> c.isValid(stack)) || !(gemBonus instanceof PSTGemBonus)) continue;
                PSTGemBonus aBonus = (PSTGemBonus)gemBonus;
                list.add(aBonus.getBonus(gemStack));
                continue block0;
            }
        }
        return list;
    }

    public List<ItemStack> getGems(ItemStack stack) {
        return this.getGems(stack, this.getSockets(stack, null));
    }

    public int getSockets(ItemStack stack, @Nullable Player player) {
        int playerSockets = player == null ? 0 : PlayerHelper.getPlayerSockets(stack, player);
        int sockets = SocketHelper.getSockets((ItemStack)stack);
        int gems = SocketHelper.getGems((ItemStack)stack).size();
        if ((playerSockets -= gems) < 0) {
            playerSockets = 0;
        }
        return sockets + playerSockets;
    }

    public boolean hasEmptySockets(ItemStack stack, Player player) {
        return this.getGems(stack, this.getSockets(stack, player)).stream().map(GemItem::getGem).map(DynamicHolder::getOptional).anyMatch(Optional::isEmpty);
    }

    public int getFirstEmptySocket(ItemStack stack, int sockets) {
        List<ItemStack> gems = this.getGems(stack, sockets);
        for (int socket = 0; socket < sockets; ++socket) {
            if (!GemItem.getGem((ItemStack)gems.get(socket)).getOptional().isEmpty()) continue;
            return socket;
        }
        return 0;
    }

    public void createGemStack(Consumer<ItemStack> consumer, LootContext context, ResourceLocation gemTypeId) {
        Player player = GemLootPoolEntry.findPlayer((LootContext)context);
        if (player == null) {
            return;
        }
        ItemStack gemStack = this.getGemStack(gemTypeId);
        if (!gemStack.m_41619_()) {
            consumer.accept(gemStack);
        }
    }

    public ItemStack getGemStack(ResourceLocation gemTypeId) {
        Gem gem = (Gem)GemRegistry.INSTANCE.getValue(gemTypeId);
        if (gem == null) {
            return ItemStack.f_41583_;
        }
        LootRarity rarity = gem.getMinRarity();
        if (rarity == null) {
            return ItemStack.f_41583_;
        }
        return GemRegistry.createGemStack((Gem)gem, (LootRarity)rarity);
    }

    @Nullable
    public ResourceLocation getGemId(ItemStack stack) {
        return GemItem.getGem((ItemStack)stack).getOptional().map(Gem::getId).orElse(null);
    }

    public boolean adventureModuleEnabled() {
        return Apotheosis.enableAdventure;
    }

    private void addItemSockets(GetItemSocketsEvent event) {
        ListTag gemsTag;
        CompoundTag affixTag;
        if (!Apoth.Affixes.SOCKET.isBound()) {
            return;
        }
        ItemStack stack = event.getStack();
        if (!ItemHelper.hasSockets(stack)) {
            return;
        }
        int sockets = event.getSockets();
        if (event.getSockets() == 0) {
            int defaultSockets = ItemHelper.getDefaultSockets(stack);
            SocketHelper.setSockets((ItemStack)stack, (int)defaultSockets);
            sockets += defaultSockets;
        }
        if ((affixTag = stack.m_41737_("affix_data")) != null && affixTag.m_128441_("gems") && (sockets += ItemHelper.getAdditionalSockets(stack)) < (gemsTag = affixTag.m_128437_("gems", 10)).size()) {
            sockets = gemsTag.size();
        }
        event.setSockets(sockets);
    }
}

