/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class DropDownList<T>
extends AbstractButton {
    public static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("skilltree:textures/screen/widgets.png");
    private Function<T, Component> toNameFunc = t -> Component.m_237113_((String)t.toString());
    private Consumer<T> responder = t -> {};
    private final List<T> possibleValues;
    private T value;
    private String search = "";
    private final int maxDisplayed;
    private final int maxScroll;
    private int scroll;
    private int searchTimer;
    private boolean opened;

    public DropDownList(int x, int y, int width, int height, int maxDisplayed, Collection<T> possibleValues, T value) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.possibleValues = new ArrayList<T>(possibleValues);
        this.value = value;
        this.maxDisplayed = maxDisplayed = Math.min(maxDisplayed, possibleValues.size());
        this.maxScroll = possibleValues.size() - maxDisplayed;
    }

    public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        int v = this.m_198029_() ? 42 : 56;
        graphics.m_280218_(WIDGETS_LOCATION, this.m_252754_(), this.m_252907_(), 0, v, this.f_93618_ / 2, this.f_93619_);
        graphics.m_280218_(WIDGETS_LOCATION, this.m_252754_() + this.f_93618_ / 2, this.m_252907_(), -this.f_93618_ / 2, v, this.f_93618_ / 2, this.f_93619_);
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        String visibleText = font.m_92834_(this.toNameFunc.apply(this.value).getString(), this.f_93618_ - 8);
        graphics.m_280056_(font, visibleText, this.m_252754_() + 5, this.m_252907_() + 3, 0xE0E0E0, true);
    }

    public void renderList(GuiGraphics graphics) {
        if (!this.opened) {
            return;
        }
        int y = this.m_252907_() + this.f_93619_ + 1;
        graphics.m_280218_(WIDGETS_LOCATION, this.m_252754_(), y, 0, 42, this.f_93618_ / 2, this.f_93619_ / 2);
        graphics.m_280218_(WIDGETS_LOCATION, this.m_252754_() + this.f_93618_ / 2, y, -this.f_93618_ / 2, 42, this.f_93618_ / 2, this.f_93619_ / 2);
        for (int i = 0; i < this.maxDisplayed - 1; ++i) {
            int rowY = y + this.f_93619_ / 2 + i * this.f_93619_;
            graphics.m_280218_(WIDGETS_LOCATION, this.m_252754_(), rowY, 0, 70, this.f_93618_ / 2, this.f_93619_);
            graphics.m_280218_(WIDGETS_LOCATION, this.m_252754_() + this.f_93618_ / 2, rowY, -this.f_93618_ / 2, 70, this.f_93618_ / 2, this.f_93619_);
        }
        graphics.m_280218_(WIDGETS_LOCATION, this.m_252754_(), y += (this.maxDisplayed - 1) * this.f_93619_ + this.f_93619_ / 2, 0, 42 + this.f_93619_ / 2, this.f_93618_ / 2, this.f_93619_ / 2);
        graphics.m_280218_(WIDGETS_LOCATION, this.m_252754_() + this.f_93618_ / 2, y, -this.f_93618_ / 2, 42 + this.f_93619_ / 2, this.f_93618_ / 2, this.f_93619_ / 2);
        y -= (this.maxDisplayed - 1) * this.f_93619_ + this.f_93619_ / 2;
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        for (int i = 0; i < this.maxDisplayed; ++i) {
            Object line = this.toNameFunc.apply(this.possibleValues.get(i + this.scroll)).getString();
            if (font.m_92895_((String)line) > this.f_93618_ - 10) {
                while (font.m_92895_((String)line + "...") > this.f_93618_ - 10) {
                    line = ((String)line).substring(0, ((String)line).length() - 1);
                }
                line = (String)line + "...";
            }
            int textX = this.m_252754_() + 5;
            int textY = y + 3 + i * this.f_93619_;
            String lowerCase = ((String)line).toLowerCase();
            if (!this.search.isEmpty() && lowerCase.contains(this.search)) {
                String split1 = ((String)line).substring(0, lowerCase.indexOf(this.search));
                graphics.m_280488_(font, split1, textX, textY, 0xE0E0E0);
                String split2 = ((String)line).substring(lowerCase.indexOf(this.search), lowerCase.indexOf(this.search) + this.search.length());
                graphics.m_280488_(font, split2, textX += font.m_92895_(split1), textY, 16766530);
                String split3 = ((String)line).substring(lowerCase.indexOf(this.search) + this.search.length());
                graphics.m_280488_(font, split3, textX += font.m_92895_(split2), textY, 0xE0E0E0);
                continue;
            }
            graphics.m_280488_(font, (String)line, textX, textY, 0xE0E0E0);
        }
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        boolean clicked;
        boolean bl = clicked = super.m_93680_(mouseX, mouseY) || this.clickedList(mouseX, mouseY);
        if (!clicked) {
            this.opened = false;
        }
        return clicked;
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (this.clickedList(mouseX, mouseY)) {
            int clickedLine = ((int)mouseY - this.m_252907_() - this.f_93619_ - 1) / this.f_93619_ + this.scroll;
            this.value = this.possibleValues.get(clickedLine);
            this.responder.accept(this.value);
            this.opened = false;
            return;
        }
        if (mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
            this.m_5691_();
        } else {
            this.opened = false;
        }
    }

    private boolean clickedList(double mouseX, double mouseY) {
        return this.opened && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)(this.m_252907_() + this.f_93619_ + 1) && mouseY < (double)(this.m_252907_() + this.f_93619_ + 1 + this.maxDisplayed * this.f_93619_);
    }

    public void m_5691_() {
        this.opened ^= true;
    }

    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.opened) {
            return false;
        }
        this.setScroll(this.scroll - Mth.m_14205_((double)delta));
        return true;
    }

    private void setScroll(int scroll) {
        this.scroll = Math.min(this.maxScroll, Math.max(0, scroll));
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.opened) {
            return false;
        }
        if (SharedConstants.m_136188_((char)codePoint)) {
            this.searchTimer = 40;
            this.search = this.search + Character.toString(codePoint).toLowerCase();
            this.possibleValues.stream().filter(v -> this.toNameFunc.apply(v).getString().toLowerCase().contains(this.search)).findFirst().ifPresent(v -> this.setScroll(this.possibleValues.indexOf(v)));
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.searchTimer == 0) {
            this.search = "";
        }
        if (this.searchTimer > 0) {
            --this.searchTimer;
        }
    }

    public DropDownList<T> setToNameFunc(Function<T, Component> function) {
        this.toNameFunc = function;
        this.possibleValues.sort((v1, v2) -> {
            String name1 = ((Component)function.apply(v1)).getString();
            String name2 = ((Component)function.apply(v2)).getString();
            return name1.compareTo(name2);
        });
        return this;
    }

    public DropDownList<T> setResponder(Consumer<T> responder) {
        this.responder = responder;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean m_198029_() {
        return super.m_198029_() || this.opened;
    }

    protected void m_168797_(@NotNull NarrationElementOutput output) {
    }
}

