/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.tooltip;

import daripher.skilltree.effect.SkillBonusEffect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TooltipHelper {
    private static final Style SKILL_BONUS_STYLE = Style.f_131099_.m_178520_(8092645);
    private static final Style SKILL_BONUS_STYLE_NEGATIVE = Style.f_131099_.m_178520_(14834266);
    private static final Style ITEM_BONUS_STYLE = Style.f_131099_.m_178520_(8041442);
    private static final Style ITEM_BONUS_STYLE_NEGATIVE = Style.f_131099_.m_178520_(14391186);

    public static Component getEffectInstanceTooltip(MobEffectInstance effect) {
        Component effectDescription;
        MobEffect mobEffect = effect.m_19544_();
        if (mobEffect instanceof SkillBonusEffect) {
            SkillBonusEffect skillEffect = (SkillBonusEffect)mobEffect;
            effectDescription = skillEffect.getBonus().copy().multiply(effect.m_19564_() + 1).getTooltip().m_6270_(Style.f_131099_);
        } else {
            effectDescription = effect.m_19544_().m_19482_();
            if (effect.m_19564_() == 0) {
                return effectDescription;
            }
            MutableComponent amplifier = Component.m_237115_((String)("potion.potency." + effect.m_19564_()));
            effectDescription = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectDescription, amplifier});
        }
        return effectDescription;
    }

    public static Component getEffectTooltip(MobEffect effect) {
        if (effect instanceof SkillBonusEffect) {
            SkillBonusEffect skillEffect = (SkillBonusEffect)effect;
            return skillEffect.getBonus().getTooltip().m_6270_(Style.f_131099_);
        }
        return effect.m_19482_();
    }

    public static Component getOperationName(AttributeModifier.Operation operation) {
        return Component.m_237113_((String)(switch (operation) {
            default -> throw new IncompatibleClassChangeError();
            case AttributeModifier.Operation.ADDITION -> "Addition";
            case AttributeModifier.Operation.MULTIPLY_BASE -> "Multiply Base";
            case AttributeModifier.Operation.MULTIPLY_TOTAL -> "Multiply Total";
        }));
    }

    public static Component getOptionalTooltip(String descriptionId, String subtype) {
        String key = "%s.%s".formatted(descriptionId, subtype);
        MutableComponent tooltip = Component.m_237115_((String)key);
        if (!tooltip.getString().equals(key)) {
            return tooltip;
        }
        return Component.m_237115_((String)descriptionId);
    }

    public static void consumeTranslated(String descriptionId, Consumer<MutableComponent> consumer) {
        MutableComponent tooltip = Component.m_237115_((String)descriptionId);
        if (!tooltip.getString().equals(descriptionId)) {
            consumer.accept(tooltip);
        }
    }

    public static MutableComponent getSkillBonusTooltip(Component bonusDescription, double amount, AttributeModifier.Operation operation) {
        float multiplier = 1.0f;
        if (operation != AttributeModifier.Operation.ADDITION) {
            multiplier = 100.0f;
        }
        double visibleAmount = amount * (double)multiplier;
        if (amount < 0.0) {
            visibleAmount *= -1.0;
        }
        Object operationDescription = amount > 0.0 ? "plus" : "take";
        operationDescription = "attribute.modifier." + (String)operationDescription + "." + operation.ordinal();
        String multiplierDescription = TooltipHelper.formatNumber(visibleAmount);
        return Component.m_237110_((String)operationDescription, (Object[])new Object[]{multiplierDescription, bonusDescription});
    }

    public static String formatNumber(double number) {
        return ItemStack.f_41584_.format(number);
    }

    public static MutableComponent getSkillBonusTooltip(String bonus, double amount, AttributeModifier.Operation operation) {
        return TooltipHelper.getSkillBonusTooltip((Component)Component.m_237115_((String)bonus), amount, operation);
    }

    public static Style getSkillBonusStyle(boolean positive) {
        return positive ? SKILL_BONUS_STYLE : SKILL_BONUS_STYLE_NEGATIVE;
    }

    public static Style getItemBonusStyle(boolean positive) {
        return positive ? ITEM_BONUS_STYLE : ITEM_BONUS_STYLE_NEGATIVE;
    }

    public static MutableComponent getTextureName(ResourceLocation location) {
        String texture = location.m_135815_();
        texture = texture.substring(texture.lastIndexOf("/") + 1);
        texture = texture.replace(".png", "");
        texture = TooltipHelper.idToName(texture);
        return Component.m_237113_((String)texture);
    }

    public static String getRecipeDescriptionId(ResourceLocation recipeId) {
        return "recipe.%s.%s".formatted(recipeId.m_135827_(), recipeId.m_135815_());
    }

    @NotNull
    public static String idToName(String path) {
        String[] words = path.split("_");
        StringBuilder name = new StringBuilder();
        Arrays.stream(words).map(w -> w.substring(0, 1).toUpperCase() + w.substring(1)).forEach(w -> {
            name.append(" ");
            name.append((String)w);
        });
        return name.substring(1);
    }

    public static List<MutableComponent> split(MutableComponent component, Font font, int maxWidth) {
        String[] split = component.getString().split(" ");
        if (split.length < 2) {
            return List.of(component);
        }
        Object line = split[0];
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        for (int i = 1; i < split.length; ++i) {
            String next = (String)line + " " + split[i];
            if (font.m_92895_(next) > maxWidth) {
                components.add(Component.m_237115_((String)line).m_130948_(component.m_7383_()));
                line = "  " + split[i];
                continue;
            }
            line = next;
        }
        components.add(Component.m_237115_((String)line).m_130948_(component.m_7383_()));
        return components;
    }

    @NotNull
    public static String getTrimmedMessage(Font font, String message, int maxWidth) {
        if (font.m_92895_((String)message) > maxWidth) {
            while (font.m_92895_((String)message + "...") > maxWidth) {
                message = ((String)message).substring(0, ((String)message).length() - 1);
            }
            message = (String)message + "...";
        }
        return message;
    }
}

