/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.client.gui.GuiSidedContainer;
import shetiphian.core.common.StringUtil;
import shetiphian.core.common.inventory.SidedContainer;
import shetiphian.platforms.client.gui.Textures;
import shetiphian.platforms.common.inventory.ContainerPlatFormer;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;

@OnlyIn(value=Dist.CLIENT)
public class GuiPlatFormer
extends GuiSidedContainer<ContainerPlatFormer> {
    private final String TEXT_STORAGE = I18n.m_118938_((String)"gui.platforms.platformer.slot.storage.info", (Object[])new Object[0]);
    private final String TEXT_CRAFT = I18n.m_118938_((String)"gui.platforms.platformer.slot.craft.info", (Object[])new Object[0]);
    private final String TEXT_DECON = I18n.m_118938_((String)"gui.platforms.platformer.slot.decon.info", (Object[])new Object[0]);
    private final String TEXT_BUFFER = I18n.m_118938_((String)"gui.platforms.platformer.slot.buffer.info", (Object[])new Object[0]);
    private final String TEXT_MATERIAL = I18n.m_118938_((String)"gui.platforms.platformer.slot.material.info", (Object[])new Object[0]);
    private final String TEXT_SELECT = I18n.m_118938_((String)"gui.platforms.platformer.button.select.info", (Object[])new Object[0]);
    private final String TEXT_PREVIEW = I18n.m_118938_((String)"gui.platforms.platformer.preview.info", (Object[])new Object[0]);

    public GuiPlatFormer(ContainerPlatFormer screenContainer, Inventory inv, Component title) {
        super((SidedContainer)screenContainer, false, inv, title);
        this.f_97726_ = 182;
        this.f_97727_ = 194;
        this.invNames = StringUtil.translateAll((String[])new String[]{"gui.platforms.platformer.basic", "gui.platforms.platformer.decon", "gui.platforms.platformer.output", "gui.platforms.platformer.storage"});
    }

    protected List<String> getInfoBoxText() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("\u00a79I:\u00a7r " + this.TEXT_STORAGE);
        lines.add(null);
        lines.add("\u00a7eII:\u00a7r " + this.TEXT_CRAFT);
        lines.add(null);
        lines.add("\u00a71III:\u00a7r " + this.TEXT_DECON);
        lines.add(null);
        lines.add("\u00a76IV:\u00a7r " + this.TEXT_BUFFER);
        lines.add(null);
        lines.add("\u00a73V:\u00a7r " + this.TEXT_MATERIAL);
        lines.add(null);
        lines.add("\u00a7aVI:\u00a7r " + this.TEXT_SELECT);
        lines.add(null);
        lines.add("\u00a72VII:\u00a7r " + this.TEXT_PREVIEW);
        return lines;
    }

    public void initSidedContainer() {
        this.m_142416_((GuiEventListener)new ButtonIndex(this.f_97735_ + 35, this.f_97736_ + 16, -1));
        this.m_142416_((GuiEventListener)new ButtonIndex(this.f_97735_ + 87, this.f_97736_ + 16, 1));
    }

    private void drawCommon(GuiGraphics graphics, ResourceLocation texture) {
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.f_97735_, (double)this.f_97736_, (int)0, (int)60, (int)182, (int)98, (ResourceLocation)texture);
    }

    protected void drawNormal(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation guiTexture = Textures.PLATFORMER.get();
        this.drawCommon(graphics, guiTexture);
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.f_97735_, (double)(this.f_97736_ + 98), (int)0, (int)158, (int)182, (int)98, (ResourceLocation)guiTexture);
        EntityGuiItem guiItem = ((ContainerPlatFormer)this.f_97732_).platformer.getEntity();
        if (guiItem != null) {
            Item item = guiItem.m_32055_().m_41720_();
            int y = this.f_97736_ + 64;
            if (item instanceof ItemBlockPlatform && ((ItemBlockPlatform)item).getPlatformType().isRoof()) {
                y -= 6;
            }
            guiItem.render(graphics, true, 175.0f, 0.0f, 0.0f, (float)(this.f_97735_ + 64), (float)y, 50.0f, -100.0f, 100.0f, 100.0f);
        }
    }

    private void drawGuide(GuiGraphics graphics, ResourceLocation texture) {
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + 35), (double)(this.f_97736_ + 16), (int)220, (int)214, (int)6, (int)42, (ResourceLocation)texture);
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + 87), (double)(this.f_97736_ + 16), (int)238, (int)214, (int)6, (int)42, (ResourceLocation)texture);
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(this.f_97735_ + 10), (double)(this.f_97736_ + 70), (double)(this.f_97735_ + 172), (double)(this.f_97736_ + 88), (int)-2141891073);
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(this.f_97735_ + 120), (double)(this.f_97736_ + 26), (double)(this.f_97735_ + 142), (double)(this.f_97736_ + 48), (int)-2130706603);
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(this.f_97735_ + 154), (double)(this.f_97736_ + 42), (double)(this.f_97735_ + 172), (double)(this.f_97736_ + 59), (int)-2147483478);
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(this.f_97735_ + 145), (double)(this.f_97736_ + 15), (double)(this.f_97735_ + 163), (double)(this.f_97736_ + 33), (int)-2130728448);
    }

    private void drawGuideText(GuiGraphics graphics, boolean info) {
        graphics.m_280137_(this.f_96547_, "I", this.f_97735_ + 91, this.f_97736_ + 75, -1);
        graphics.m_280137_(this.f_96547_, "II", this.f_97735_ + 131, this.f_97736_ + 33, -1);
        graphics.m_280137_(this.f_96547_, "III", this.f_97735_ + 163, this.f_97736_ + 46, -1);
        graphics.m_280137_(this.f_96547_, "IV", this.f_97735_ + 154, this.f_97736_ + 20, -1);
        if (info) {
            graphics.m_280137_(this.f_96547_, "V", this.f_97735_ + 19, this.f_97736_ + 33, -1);
            graphics.m_280137_(this.f_96547_, "VI", this.f_97735_ + 64, this.f_97736_ + 6, -1);
            graphics.m_280137_(this.f_96547_, "VII", this.f_97735_ + 64, this.f_97736_ + 33, -1);
        }
    }

    protected void drawInfo(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation guiTexture = Textures.PLATFORMER.get();
        this.drawCommon(graphics, guiTexture);
        this.drawGuide(graphics, guiTexture);
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(this.f_97735_ + 10), (double)(this.f_97736_ + 19), (double)(this.f_97735_ + 28), (double)(this.f_97736_ + 55), (int)-2147439958);
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(this.f_97735_ + 35), (double)(this.f_97736_ + 16), (double)(this.f_97735_ + 41), (double)(this.f_97736_ + 58), (int)-2141847723);
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(this.f_97735_ + 87), (double)(this.f_97736_ + 16), (double)(this.f_97735_ + 93), (double)(this.f_97736_ + 58), (int)-2141847723);
        graphics.m_280656_(this.f_97735_ + 37, this.f_97735_ + 90, this.f_97736_ + 9, -2141847723);
        graphics.m_280315_(this.f_97735_ + 37, this.f_97736_ + 9, this.f_97736_ + 16, -2141847723);
        graphics.m_280315_(this.f_97735_ + 90, this.f_97736_ + 9, this.f_97736_ + 16, -2141847723);
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(this.f_97735_ + 42), (double)(this.f_97736_ + 15), (double)(this.f_97735_ + 86), (double)(this.f_97736_ + 59), (int)-2147440128);
        if (this.infoBox != null) {
            this.infoBox.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        this.drawGuideText(graphics, true);
    }

    protected void drawConfig(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation guiTexture = Textures.PLATFORMER.get();
        this.drawCommon(graphics, guiTexture);
        this.drawGuide(graphics, guiTexture);
        this.drawGuideText(graphics, false);
    }

    protected void renderFaceButton(GuiGraphics graphics, AbstractWidget button, Direction face, int mouseX, int mouseY, float partialTicks) {
        int x = button.m_252754_();
        int y = button.m_252907_();
        byte index = this.indexSide[face.m_122411_()];
        if (index == 0 || index == 2) {
            GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)(x + button.m_5711_()), (double)(y + button.m_93694_()), (int)-171);
            GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)(x + button.m_5711_() / 2), (double)(y + button.m_93694_()), (int)-22016);
            if (index == 0) {
                GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)(y + button.m_93694_() / 2), (double)(x + button.m_5711_()), (double)(y + button.m_93694_()), (int)-11184641);
            }
        } else {
            int color = index == 1 ? -16777046 : (index == 3 ? -11184641 : Integer.MIN_VALUE);
            GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)(x + button.m_5711_()), (double)(y + button.m_93694_()), (int)color);
        }
    }

    private class ButtonIndex
    extends Button {
        int shift;

        ButtonIndex(int posX, int posY, int indexShift) {
            super(posX, posY, 6, 42, (Component)Component.m_237119_(), null, f_252438_);
            this.shift = indexShift;
        }

        public void m_5691_() {
            if (this.f_93622_) {
                int index = ((ContainerPlatFormer)GuiPlatFormer.this.f_97732_).getPlatformIndex();
                int max = EnumPlatformType.values().length - 1;
                index = (index += this.shift) < 0 ? max : (index > max ? 0 : index);
                GuiPlatFormer.this.getMinecraft().f_91072_.m_105208_(((ContainerPlatFormer)((GuiPlatFormer)GuiPlatFormer.this).f_97732_).f_38840_, index);
            }
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int index;
            int x = this.m_252754_();
            int y = this.m_252907_();
            this.f_93622_ = mouseX >= x && mouseY >= y && mouseX < x + this.f_93618_ && mouseY < y + this.f_93619_;
            int n = index = this.shift > 0 ? 18 : 0;
            if (this.f_93622_ && Minecraft.m_91087_().f_91067_.m_91560_()) {
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)x, (double)y, (int)(232 + index), (int)214, (int)this.f_93618_, (int)this.f_93619_, (ResourceLocation)Textures.PLATFORMER.get());
            } else if (this.f_93622_) {
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)x, (double)y, (int)(226 + index), (int)214, (int)this.f_93618_, (int)this.f_93619_, (ResourceLocation)Textures.PLATFORMER.get());
            } else {
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)x, (double)y, (int)(220 + index), (int)214, (int)this.f_93618_, (int)this.f_93619_, (ResourceLocation)Textures.PLATFORMER.get());
            }
        }
    }
}

