/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.network.PacketReturnEntityInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketGetEntityInfo {
    private ResourceKey<Level> dim;
    private UUID uuid;
    private ProbeMode mode;
    private Vec3 hitVec;

    public PacketGetEntityInfo(FriendlyByteBuf buf) {
        this.dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
        this.uuid = buf.m_130259_();
        this.mode = ProbeMode.values()[buf.readByte()];
        if (buf.readBoolean()) {
            this.hitVec = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.dim.m_135782_());
        buf.m_130077_(this.uuid);
        buf.writeByte(this.mode.ordinal());
        if (this.hitVec == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeDouble(this.hitVec.f_82479_);
            buf.writeDouble(this.hitVec.f_82480_);
            buf.writeDouble(this.hitVec.f_82481_);
        }
    }

    public PacketGetEntityInfo() {
    }

    public PacketGetEntityInfo(ResourceKey<Level> dim, ProbeMode mode, HitResult mouseOver, Entity entity) {
        this.dim = dim;
        this.uuid = entity.m_20148_();
        this.mode = mode;
        this.hitVec = mouseOver.m_82450_();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ServerLevel world = ((NetworkEvent.Context)ctx.get()).getSender().f_8924_.m_129880_(this.dim);
            if (world != null && (entity = world.m_8791_(this.uuid)) != null) {
                ProbeInfo probeInfo = PacketGetEntityInfo.getProbeInfo((Player)((NetworkEvent.Context)ctx.get()).getSender(), this.mode, (Level)world, entity, this.hitVec);
                PacketHandler.INSTANCE.sendTo((Object)new PacketReturnEntityInfo(this.uuid, probeInfo), ((NetworkEvent.Context)ctx.get()).getSender().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static ProbeInfo getProbeInfo(Player player, ProbeMode mode, Level world, Entity entity, Vec3 hitVec) {
        if ((Integer)Config.needsProbe.get() == 3) {
            if (!ModItems.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if ((Integer)Config.needsProbe.get() == 2 && !ModItems.hasAProbeSomewhere(player)) {
            return null;
        }
        if (!Config.getEntityBlacklist().isEmpty()) {
            ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
            for (Predicate<ResourceLocation> predicate : Config.getEntityBlacklist()) {
                if (!predicate.test(rl)) continue;
                return null;
            }
        }
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(hitVec);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, entity, data);
        }
        Config.setRealConfig(probeConfig);
        List<IProbeInfoEntityProvider> entityProviders = TheOneProbe.theOneProbeImp.getEntityProviders();
        for (IProbeInfoEntityProvider provider : entityProviders) {
            try {
                provider.addProbeEntityInfo(mode, probeInfo, player, world, entity, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Error: ").style(TextStyleClass.ERROR).text(provider.getID()));
            }
        }
        return probeInfo;
    }
}

