/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IEntityStyle;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITextStyle;
import mcjty.theoneprobe.api.TankReference;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.apiimpl.elements.ElementEntity;
import mcjty.theoneprobe.apiimpl.elements.ElementHorizontal;
import mcjty.theoneprobe.apiimpl.elements.ElementIcon;
import mcjty.theoneprobe.apiimpl.elements.ElementItemLabel;
import mcjty.theoneprobe.apiimpl.elements.ElementItemStack;
import mcjty.theoneprobe.apiimpl.elements.ElementPadding;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.elements.ElementTank;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.elements.ElementVertical;
import mcjty.theoneprobe.apiimpl.styles.EntityStyle;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import mcjty.theoneprobe.apiimpl.styles.TextStyle;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractElementPanel
implements IElement,
IProbeInfo {
    protected List<IElement> children = new ArrayList<IElement>();
    protected ILayoutStyle layout;
    protected IProbeConfig overriddenConfig;

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        Integer borderColor = this.layout.getBorderColor();
        if (borderColor != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            RenderHelper.drawHorizontalLine(graphics, x, y, x + w - 1, borderColor);
            RenderHelper.drawHorizontalLine(graphics, x, y + h - 1, x + w - 1, borderColor);
            RenderHelper.drawVerticalLine(graphics, x, y, y + h - 1, borderColor);
            RenderHelper.drawVerticalLine(graphics, x + w - 1, y, y + h, borderColor);
        }
    }

    public AbstractElementPanel(ILayoutStyle style) {
        this.layout = style;
    }

    @Deprecated
    public AbstractElementPanel(Integer borderColor, int spacing, ElementAlignment alignment) {
        this(new LayoutStyle().borderColor(borderColor).spacing(spacing).alignment(alignment));
    }

    public AbstractElementPanel(FriendlyByteBuf buf) {
        this.children = ProbeInfo.createElements(buf);
        this.layout = new LayoutStyle();
        this.layout.alignment((ElementAlignment)buf.m_130066_(ElementAlignment.class));
        if (buf.readBoolean()) {
            this.layout.borderColor(buf.readInt());
        }
        this.layout.spacing(buf.readInt()).topPadding(buf.readInt()).bottomPadding(buf.readInt()).leftPadding(buf.readInt()).rightPadding(buf.readInt());
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        ProbeInfo.writeElements(this.children, buf);
        buf.m_130068_((Enum)this.layout.getAlignment()).writeBoolean(this.layout.getBorderColor() != null);
        if (this.layout.getBorderColor() != null) {
            buf.writeInt(this.layout.getBorderColor().intValue());
        }
        buf.writeInt(this.layout.getSpacing()).writeInt(this.layout.getTopPadding()).writeInt(this.layout.getBottomPadding()).writeInt(this.layout.getLeftPadding()).writeInt(this.layout.getRightPadding());
    }

    public ILayoutStyle getStyle() {
        return this.layout;
    }

    @Override
    public List<IElement> getElements() {
        return this.children;
    }

    protected int getYPadding() {
        return this.layout.getBottomPadding() + this.layout.getTopPadding();
    }

    protected int getXPadding() {
        return this.layout.getLeftPadding() + this.layout.getRightPadding();
    }

    @Override
    public IProbeInfo icon(ResourceLocation icon, int u, int v, int w, int h) {
        return this.icon(icon, u, v, w, h, new IconStyle());
    }

    @Override
    public IProbeInfo icon(ResourceLocation icon, int u, int v, int w, int h, IIconStyle style) {
        this.children.add(new ElementIcon(icon, u, v, w, h, style));
        return this;
    }

    @Override
    public IProbeInfo text(Component text) {
        this.children.add(new ElementText(text).setLegacy());
        return this;
    }

    @Override
    public IProbeInfo text(CompoundText text, ITextStyle style) {
        this.children.add(new ElementText(text.get(), style).setLegacy());
        return this;
    }

    @Override
    public IProbeInfo text(CompoundText text) {
        this.children.add(new ElementText(text.get()).setLegacy());
        return this;
    }

    @Override
    public IProbeInfo text(Component text, ITextStyle style) {
        this.children.add(new ElementText(text, style).setLegacy());
        return this;
    }

    @Override
    public IProbeInfo mcText(Component text) {
        this.children.add(new ElementText(text));
        return this;
    }

    @Override
    public IProbeInfo mcText(Component text, ITextStyle style) {
        this.children.add(new ElementText(text, style));
        return this;
    }

    @Override
    public IProbeInfo itemLabel(ItemStack stack, ITextStyle style) {
        this.children.add(new ElementItemLabel(stack));
        return this;
    }

    @Override
    public IProbeInfo itemLabel(ItemStack stack) {
        this.children.add(new ElementItemLabel(stack));
        return this;
    }

    @Override
    public IProbeInfo entity(String entityName, IEntityStyle style) {
        this.children.add(new ElementEntity(entityName, style));
        return this;
    }

    @Override
    public IProbeInfo entity(String entityName) {
        return this.entity(entityName, (IEntityStyle)new EntityStyle());
    }

    @Override
    public IProbeInfo entity(Entity entity, IEntityStyle style) {
        this.children.add(new ElementEntity(entity, style));
        return this;
    }

    @Override
    public IProbeInfo entity(Entity entity) {
        return this.entity(entity, (IEntityStyle)new EntityStyle());
    }

    @Override
    public IProbeInfo item(ItemStack stack, IItemStyle style) {
        this.children.add(new ElementItemStack(stack, style));
        return this;
    }

    @Override
    public IProbeInfo item(ItemStack stack) {
        return this.item(stack, new ItemStyle());
    }

    @Override
    public IProbeInfo progress(int current, int max) {
        return this.progress(current, max, (IProgressStyle)new ProgressStyle());
    }

    @Override
    public IProbeInfo progress(int current, int max, IProgressStyle style) {
        this.children.add(new ElementProgress(current, max, style));
        return this;
    }

    @Override
    public IProbeInfo progress(long current, long max) {
        return this.progress(current, max, (IProgressStyle)new ProgressStyle());
    }

    @Override
    public IProbeInfo progress(long current, long max, IProgressStyle style) {
        this.children.add(new ElementProgress(current, max, style));
        return this;
    }

    @Override
    public IProbeInfo tank(TankReference tank) {
        this.children.add(new ElementTank(tank));
        return this;
    }

    @Override
    public IProbeInfo tank(TankReference tank, IProgressStyle style) {
        this.children.add(new ElementTank(tank, style));
        return this;
    }

    @Override
    public IProbeInfo padding(int width, int height) {
        this.children.add(new ElementPadding(width, height));
        return this;
    }

    @Override
    public IProbeInfo horizontal(ILayoutStyle style) {
        ElementHorizontal e = new ElementHorizontal(style);
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo horizontal() {
        ElementHorizontal e = new ElementHorizontal(new LayoutStyle().spacing(this.layout.getSpacing()).alignment(ElementAlignment.ALIGN_TOPLEFT));
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo vertical(ILayoutStyle style) {
        ElementVertical e = new ElementVertical(style);
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo vertical() {
        ElementVertical e = new ElementVertical(new LayoutStyle().spacing(2).alignment(ElementAlignment.ALIGN_TOPLEFT));
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo element(IElement element) {
        this.children.add(element);
        return this;
    }

    @Override
    public ILayoutStyle defaultLayoutStyle() {
        return new LayoutStyle();
    }

    @Override
    public IProgressStyle defaultProgressStyle() {
        return new ProgressStyle();
    }

    @Override
    public ITextStyle defaultTextStyle() {
        return new TextStyle();
    }

    @Override
    public IItemStyle defaultItemStyle() {
        return new ItemStyle();
    }

    @Override
    public IEntityStyle defaultEntityStyle() {
        return new EntityStyle();
    }

    @Override
    public IIconStyle defaultIconStyle() {
        return new IconStyle();
    }
}

