/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.theoneprobe.ForgeEventHandlers;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.providers.BlockProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.DebugProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DebugProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.EntityProbeInfoEntityProvider;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.AddProbeTagRecipe;
import mcjty.theoneprobe.items.AddProbeTagRecipeSerializer;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.rendering.ClientSetup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="theoneprobe")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheOneProbe {
    public static final String MODID = "theoneprobe";
    public static final Logger logger = LogManager.getLogger();
    public static TheOneProbeImp theOneProbeImp = new TheOneProbeImp();
    public static boolean baubles = false;
    public static boolean tesla = false;
    public static boolean redstoneflux = false;
    public static DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"theoneprobe");
    public static RegistryObject<CreativeModeTab> TAB_PROBE = TABS.register("probe", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237113_((String)"The One Probe")).m_257737_(() -> new ItemStack((ItemLike)ModItems.PROBE)).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257501_((featureFlags, output) -> {
        if (ModItems.CREATIVE_PROBE != null) {
            output.m_246326_((ItemLike)ModItems.CREATIVE_PROBE);
        }
        if (ModItems.PROBE != null) {
            output.m_246326_((ItemLike)ModItems.PROBE);
        }
        if (ModItems.DIAMOND_HELMET_PROBE != null) {
            output.m_246326_((ItemLike)ModItems.DIAMOND_HELMET_PROBE);
        }
        if (ModItems.GOLD_HELMET_PROBE != null) {
            output.m_246326_((ItemLike)ModItems.GOLD_HELMET_PROBE);
        }
        if (ModItems.IRON_HELMET_PROBE != null) {
            output.m_246326_((ItemLike)ModItems.IRON_HELMET_PROBE);
        }
        if (ModItems.PROBE_GOGGLES != null) {
            output.m_246326_((ItemLike)ModItems.PROBE_GOGGLES);
        }
        if (ModItems.PROBE_NOTE != null) {
            output.m_246326_((ItemLike)ModItems.PROBE_NOTE);
        }
    }).m_257652_());

    public TheOneProbe() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::init);
        bus.addListener(Config::onLoad);
        bus.addListener(Config::onReload);
        bus.addListener(this::processIMC);
        TABS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(ClientSetup::onClientSetup);
            bus.addListener(ClientSetup::onRegisterKeyMappings);
        });
    }

    private void init(FMLCommonSetupEvent event) {
        tesla = ModList.get().isLoaded("tesla");
        if (tesla) {
            logger.log(Level.INFO, "The One Probe Detected TESLA: enabling support");
        }
        if (redstoneflux = ModList.get().isLoaded("redstoneflux")) {
            logger.log(Level.INFO, "The One Probe Detected RedstoneFlux: enabling support");
        }
        if (baubles = ModList.get().isLoaded("baubles")) {
            if (((Boolean)Config.supportBaubles.get()).booleanValue()) {
                logger.log(Level.INFO, "The One Probe Detected Baubles: enabling support");
            } else {
                logger.log(Level.INFO, "The One Probe Detected Baubles but support disabled in config");
                baubles = false;
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        TheOneProbe.registerCapabilities();
        TheOneProbeImp.registerElements();
        theOneProbeImp.registerProvider(new DefaultProbeInfoProvider());
        theOneProbeImp.registerProvider(new DebugProbeInfoProvider());
        theOneProbeImp.registerProvider(new BlockProbeInfoProvider());
        theOneProbeImp.registerEntityProvider(new DefaultProbeInfoEntityProvider());
        theOneProbeImp.registerEntityProvider(new DebugProbeInfoEntityProvider());
        theOneProbeImp.registerEntityProvider(new EntityProbeInfoEntityProvider());
        PacketHandler.registerMessages(MODID);
        this.configureProviders();
        this.configureEntityProviders();
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getTheOneProbe".equalsIgnoreCase(message.method())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(theOneProbeImp);
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterEvent(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> {
            AddProbeTagRecipe.HELMET_SERIALIZER = new AddProbeTagRecipeSerializer();
            helper.register(new ResourceLocation(MODID, "probe_helmet"), (Object)AddProbeTagRecipe.HELMET_SERIALIZER);
        });
        event.register(ForgeRegistries.Keys.ITEMS, helper -> {
            ModItems.init();
            helper.register(new ResourceLocation(MODID, "probe"), (Object)ModItems.PROBE);
            helper.register(new ResourceLocation(MODID, "creativeprobe"), (Object)ModItems.CREATIVE_PROBE);
            helper.register(new ResourceLocation(MODID, "probenote"), (Object)ModItems.PROBE_NOTE);
            helper.register(new ResourceLocation(MODID, "diamond_helmet_probe"), (Object)ModItems.DIAMOND_HELMET_PROBE);
            helper.register(new ResourceLocation(MODID, "gold_helmet_probe"), (Object)ModItems.GOLD_HELMET_PROBE);
            helper.register(new ResourceLocation(MODID, "iron_helmet_probe"), (Object)ModItems.IRON_HELMET_PROBE);
        });
    }

    private static void registerCapabilities() {
    }

    private void configureProviders() {
        List<IProbeInfoProvider> providers = theOneProbeImp.getProviders();
        ResourceLocation[] defaultValues = new ResourceLocation[providers.size()];
        int i = 0;
        for (IProbeInfoProvider provider : providers) {
            defaultValues[i++] = provider.getID();
        }
        String[] excludedProviders = new String[]{};
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, excludedProviders);
        theOneProbeImp.configureProviders(defaultValues, excluded);
    }

    private void configureEntityProviders() {
        List<IProbeInfoEntityProvider> providers = theOneProbeImp.getEntityProviders();
        String[] defaultValues = new String[providers.size()];
        int i = 0;
        for (IProbeInfoEntityProvider provider : providers) {
            defaultValues[i++] = provider.getID();
        }
        String[] excludedProviders = new String[]{};
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, excludedProviders);
        theOneProbeImp.configureEntityProviders(defaultValues, excluded);
    }
}

