/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common.data.damageitem;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.oitsjustjose.natprog.common.data.damageitem.DamageItemRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageItemRecipeSerializer
implements RecipeSerializer<DamageItemRecipe> {
    @NotNull
    public DamageItemRecipe fromJson(@NotNull ResourceLocation resloc, @NotNull JsonObject obj) {
        String group = GsonHelper.m_13906_((JsonObject)obj, (String)"group");
        NonNullList<Ingredient> ingredients = DamageItemRecipeSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)obj, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for natprog:damage_tools");
        }
        ItemStack stack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)obj, (String)"result"));
        return new DamageItemRecipe(resloc, group, CraftingBookCategory.MISC, stack, ingredients);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull DamageItemRecipe recipe) {
        buf.m_130070_(recipe.m_6076_());
        buf.m_130130_(recipe.m_7527_().size());
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredient.m_43923_(buf);
        }
        buf.writeItemStack(recipe.getResultItem(), false);
    }

    @Nullable
    public DamageItemRecipe fromNetwork(@NotNull ResourceLocation rl, @NotNull FriendlyByteBuf buf) {
        String s = buf.m_130136_(Short.MAX_VALUE);
        int i = buf.m_130242_();
        NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
        ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
        ItemStack stack = buf.m_130267_();
        return new DamageItemRecipe(rl, s, CraftingBookCategory.MISC, stack, (NonNullList<Ingredient>)ingredients);
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Ingredient ingr = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
            if (ingr.m_43947_()) continue;
            ingredients.add((Object)ingr);
        }
        return ingredients;
    }
}

