/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class PebbleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    @Nullable
    private final ResourceLocation parentBlockRl;

    public PebbleBlock(@Nullable ResourceLocation parent) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(0.125f, 2.0f).m_60918_(SoundType.f_56742_).m_60988_().m_60910_().m_222979_(BlockBehaviour.OffsetType.XZ).m_280170_().m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283947_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.parentBlockRl = parent;
    }

    @Nullable
    public Block getParentBlock() {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.parentBlockRl);
        return block == Blocks.f_50016_ ? null : block;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_() == Blocks.f_49990_) {
            return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
        }
        return this.m_49966_();
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Vec3 offset = state.m_60824_(getter, pos);
        return Shapes.m_166049_((double)0.37, (double)0.0, (double)0.37, (double)0.69, (double)0.065, (double)0.69).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public void m_142072_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, fallDistance);
        Random random = new Random();
        if ((int)fallDistance > 0 && random.nextInt((int)fallDistance) > 5) {
            level.m_46961_(pos, true);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (!player.m_6047_()) {
            level.m_46961_(pos, true);
            player.m_6674_(handIn);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        return below.m_60804_((BlockGetter)level, pos.m_7495_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
    }
}

