/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common;

import com.oitsjustjose.natprog.NatProg;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class Utils {
    public static final TagKey<Block> GROUND = BlockTags.create((ResourceLocation)new ResourceLocation("natprog", "ground"));

    public static Block getPebbleForPos(WorldGenLevel level, BlockPos pos) {
        HashMap<ResourceLocation, RegistryObject<? extends Block>> mapper = NatProg.getInstance().REGISTRY.Mapper;
        BlockPos search = new BlockPos(pos.m_123341_(), level.m_141928_(), pos.m_123343_());
        for (int y = level.m_141928_() / 2; y < search.m_123342_(); ++y) {
            ResourceLocation resloc;
            BlockState at = level.m_8055_(search.m_6625_(y));
            if (at.m_60734_() == Blocks.f_50069_ || at.m_60734_() == Blocks.f_152550_ || at.m_60795_() || !mapper.containsKey(resloc = ForgeRegistries.BLOCKS.getKey((Object)at.m_60734_()))) continue;
            return (Block)mapper.get(resloc).get();
        }
        Block choice = level.m_213780_().m_188499_() ? Blocks.f_50069_ : Blocks.f_152550_;
        ResourceLocation resloc = ForgeRegistries.BLOCKS.getKey((Object)choice);
        return (Block)mapper.get(resloc).get();
    }

    public static boolean isInWater(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() == Blocks.f_49990_;
    }

    public static boolean inNonWaterFluid(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_278721_() && !Utils.isInWater(level, pos);
    }

    @Nullable
    public static BlockPos getTopLevelPlacePos(WorldGenLevel level, ChunkPos chunkPos) {
        return Utils.getTopLevelPlacePos(level, chunkPos, -1);
    }

    @Nullable
    public static BlockPos getTopLevelPlacePos(WorldGenLevel level, ChunkPos chunkPos, int spread) {
        if (!(level instanceof WorldGenRegion)) {
            return null;
        }
        WorldGenRegion region = (WorldGenRegion)level;
        int usedSpread = Math.max(8, spread);
        int xCenter = (chunkPos.m_45604_() + chunkPos.m_45608_()) / 2;
        int zCenter = (chunkPos.m_45605_() + chunkPos.m_45609_()) / 2;
        int blockPosX = xCenter + level.m_213780_().m_188503_(usedSpread) * (level.m_213780_().m_188499_() ? 1 : -1);
        int blockPosZ = zCenter + level.m_213780_().m_188503_(usedSpread) * (level.m_213780_().m_188499_() ? 1 : -1);
        if (!region.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            return null;
        }
        BlockPos searchPos = new BlockPos(blockPosX, region.m_141928_(), blockPosZ);
        while (searchPos.m_123342_() > region.m_141937_()) {
            BlockPos actualPlacePos;
            if (Utils.canPlaceOn(level, searchPos) && Utils.canReplace((WorldGenLevel)region, actualPlacePos = searchPos.m_7494_())) {
                return actualPlacePos;
            }
            searchPos = searchPos.m_7495_();
        }
        return null;
    }

    public static boolean canPlaceOn(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return Block.m_49916_((VoxelShape)state.m_60808_((BlockGetter)level, pos)) && state.m_204336_(GROUND);
    }

    public static boolean canReplace(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_278721_() || state.m_60795_() || state.m_204336_(BlockTags.f_13035_) || state.m_247087_();
    }

    public static void fixSnowyBlock(WorldGenLevel level, BlockPos posPlaced) {
        BlockState below = level.m_8055_(posPlaced.m_7495_());
        if (below.m_61138_((Property)BlockStateProperties.f_61451_)) {
            level.m_7731_(posPlaced.m_7495_(), (BlockState)below.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.FALSE), 18);
        }
    }
}

