/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.particle.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DiamondSparkleParticle
extends TextureSheetParticle {
    protected DiamondSparkleParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites) {
        super(world, x, y, z);
        this.m_107268_(0.96f);
        this.f_172259_ = true;
        this.f_107663_ *= 0.75f;
        this.f_107219_ = false;
        this.m_108339_(sprites);
    }

    public void m_5989_() {
        super.m_5989_();
        float fadeInAge = (float)this.m_107273_() * 0.2f;
        float fadeOutAge = (float)this.m_107273_() * 0.6f;
        if ((float)this.f_107224_ <= fadeInAge) {
            this.m_107271_((float)this.f_107224_ / fadeInAge);
        } else if ((float)this.f_107224_ >= fadeOutAge) {
            this.m_107271_(1.0f - ((float)this.f_107224_ - fadeOutAge) / fadeOutAge);
        } else {
            this.m_107271_(1.0f);
        }
    }

    public int m_6355_(float partialTick) {
        return 240;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DiamondSparkleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public DiamondSparkleProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DiamondSparkleParticle glowParticle = new DiamondSparkleParticle(worldIn, x, y, z, this.sprite);
            glowParticle.m_107257_(worldIn.m_213780_().m_188503_(30) + 10);
            glowParticle.m_107271_(0.0f);
            return glowParticle;
        }
    }
}

