/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.network;

import me.shedaniel.autoconfig.AutoConfig;
import net.larsmans.infinitybuttons.block.custom.letterbutton.LetterButton;
import net.larsmans.infinitybuttons.block.custom.letterbutton.gui.LetterButtonGui;
import net.larsmans.infinitybuttons.config.AlarmEnum;
import net.larsmans.infinitybuttons.config.InfinityButtonsConfig;
import net.larsmans.infinitybuttons.network.packets.AlarmPacket;
import net.larsmans.infinitybuttons.network.packets.JadePacket;
import net.larsmans.infinitybuttons.network.packets.LetterButtonScreenPacket;
import net.larsmans.infinitybuttons.sounds.InfinityButtonsSounds;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class IBClientPacketHandler {
    private static boolean forceHidden = true;

    public static void handleScreenPacket(LetterButtonScreenPacket packet) {
        BlockPos pos = packet.getPos();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        assert (world != null);
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof LetterButton) {
            LetterButton letterButton = (LetterButton)block;
            Minecraft.m_91087_().m_91152_((Screen)new LetterButtonGui(letterButton, state, (Level)world, pos));
        }
    }

    public static void handleAlarmPacket(AlarmPacket packet) {
        InfinityButtonsConfig config = (InfinityButtonsConfig)AutoConfig.getConfigHolder(InfinityButtonsConfig.class).getConfig();
        if (config.muteAlarmSound) {
            return;
        }
        BlockPos pos = packet.getPos();
        AlarmEnum alarmEnum = packet.getAlarmEnum();
        if (alarmEnum == AlarmEnum.GLOBAL) {
            IBClientPacketHandler.playGlobalSound((Level)Minecraft.m_91087_().f_91073_, pos, (SoundEvent)InfinityButtonsSounds.ALARM.get(), SoundSource.BLOCKS);
        } else {
            assert (Minecraft.m_91087_().f_91073_ != null);
            Minecraft.m_91087_().f_91073_.m_5594_((Player)Minecraft.m_91087_().f_91074_, pos, (SoundEvent)InfinityButtonsSounds.ALARM.get(), SoundSource.BLOCKS, (float)config.alarmSoundRange, 1.0f);
        }
    }

    public static void playGlobalSound(Level level, BlockPos pos, SoundEvent soundEvent, SoundSource soundSource) {
        Camera cam = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 centerPos = pos.m_252807_();
        if (cam.m_90593_()) {
            float chunkDistance = (float)cam.m_90583_().m_82554_(centerPos) / 16.0f;
            level.m_7785_(centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_, soundEvent, soundSource, chunkDistance * 1.3f + 20.0f, 1.0f, false);
        }
    }

    public static void handleJadePacket(JadePacket packet) {
        forceHidden = packet.getConfig();
    }

    public static boolean getForceHidden() {
        return forceHidden;
    }
}

