/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.button;

import java.util.Optional;
import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public interface WeatheringButton
extends WeatheringCopper {
    public static Optional<BlockState> getWaxed(BlockState state) {
        InfinityButtonsUtil.buildWax();
        return Optional.ofNullable((Block)InfinityButtonsUtil.WAX_ON_BY_BLOCK.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getUnwaxed(BlockState state) {
        InfinityButtonsUtil.buildWax();
        return Optional.ofNullable((Block)InfinityButtonsUtil.WAX_OFF_BY_BLOCK.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getSticky(BlockState state) {
        InfinityButtonsUtil.buildSticky();
        return Optional.ofNullable((Block)InfinityButtonsUtil.STICKY_ON_BY_BLOCK.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getUnsticky(BlockState state) {
        InfinityButtonsUtil.buildSticky();
        return Optional.ofNullable((Block)InfinityButtonsUtil.STICKY_OFF_BY_BLOCK.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    @NotNull
    default public Optional<BlockState> m_142123_(BlockState state) {
        return WeatheringButton.getNext(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getNext(Block block) {
        InfinityButtonsUtil.buildNext();
        return Optional.ofNullable((Block)InfinityButtonsUtil.NEXT_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<Block> getPrevious(Block block) {
        InfinityButtonsUtil.buildNext();
        return Optional.ofNullable((Block)InfinityButtonsUtil.PREVIOUS_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<BlockState> getPrevious(BlockState state) {
        return WeatheringButton.getPrevious(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    default public InteractionResult wax(BlockState state, Level level, BlockPos blockpos, Player player, ItemStack itemStack) {
        return WeatheringButton.getWaxed(state).map(waxedBlockState -> {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemStack);
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            level.m_7731_(blockpos, waxedBlockState, 11);
            level.m_5898_(player, 3003, blockpos, 0);
            level.m_5594_(player, blockpos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }).orElse(InteractionResult.m_19078_((boolean)level.f_46443_));
    }

    default public InteractionResult scrape(BlockState state, Level level, BlockPos blockpos, Player player, ItemStack itemStack) {
        return WeatheringButton.getPrevious(state).map(previousBlockState -> {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemStack);
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
            }
            level.m_7731_(blockpos, previousBlockState, 11);
            level.m_5898_(player, 3005, blockpos, 0);
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }).orElse(InteractionResult.m_19078_((boolean)level.f_46443_));
    }
}

