/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.button;

import javax.annotation.Nullable;
import net.larsmans.infinitybuttons.advancement.InfinityButtonsTriggers;
import net.larsmans.infinitybuttons.block.custom.button.AbstractSmallButton;
import net.larsmans.infinitybuttons.block.custom.button.CopperButton;
import net.larsmans.infinitybuttons.block.custom.button.WeatheringButton;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class WaxedCopperButton
extends AbstractSmallButton {
    public WaxedCopperButton(BlockBehaviour.Properties properties, boolean large) {
        super(false, large, properties);
    }

    @Override
    protected void playSound(@Nullable Player playerIn, LevelAccessor worldIn, BlockPos pos, boolean hitByArrow) {
        worldIn.m_5594_((Player)(hitByArrow ? playerIn : null), pos, this.getSoundEvent(hitByArrow), SoundSource.BLOCKS, 1.0f, hitByArrow ? 0.6f : 0.5f);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(handIn);
        if (itemStack.m_41720_() instanceof AxeItem && !(this instanceof CopperButton)) {
            return (Boolean)state.m_61143_((Property)PRESSED) != false ? InteractionResult.CONSUME : this.scrapeWax(state, worldIn, pos, player, itemStack);
        }
        return !(itemStack.m_41720_() instanceof HoneyBottleItem) || this instanceof CopperButton ? super.m_6227_(state, worldIn, pos, player, handIn, hit) : this.sticky(state, worldIn, pos, player, handIn, itemStack);
    }

    public InteractionResult scrapeWax(BlockState blockState, Level level, BlockPos blockpos, Player player, ItemStack itemStack) {
        return WeatheringButton.getUnwaxed(blockState).map(waxedBlockState -> {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemStack);
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
            }
            level.m_7731_(blockpos, waxedBlockState, 11);
            level.m_5898_(player, 3004, blockpos, 0);
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                InfinityButtonsTriggers.WAX_OFF_TRIGGER.trigger(serverPlayer);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }).orElse(InteractionResult.m_19078_((boolean)level.f_46443_));
    }

    public InteractionResult sticky(BlockState blockState, Level level, BlockPos blockpos, Player player, InteractionHand hand, ItemStack itemStack) {
        return WeatheringButton.getSticky(blockState).map(waxedBlockState -> {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemStack);
            }
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
            }
            level.m_7731_(blockpos, waxedBlockState, 11);
            level.m_5898_(player, 3003, blockpos, 0);
            level.m_5594_(player, blockpos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }).orElse(InteractionResult.m_19078_((boolean)level.f_46443_));
    }

    @Override
    public int getPressDuration() {
        return 50;
    }

    @Override
    protected SoundEvent getSoundEvent(boolean isOn) {
        return SoundEvents.f_144117_;
    }
}

