/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.button;

import java.util.List;
import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.larsmans.infinitybuttons.block.custom.button.AbstractSmallButton;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class FallingButton
extends AbstractSmallButton {
    public boolean gravel;

    public FallingButton(boolean gravel, BlockBehaviour.Properties properties, boolean large) {
        super(false, large, properties);
        this.gravel = gravel;
    }

    @Override
    public int getPressDuration() {
        return 10;
    }

    @Override
    protected SoundEvent getSoundEvent(boolean pressed) {
        return this.gravel ? SoundEvents.f_11993_ : SoundEvents.f_12331_;
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)), 3);
            this.updateNeighbors(state, (Level)worldIn, pos);
            this.playSound(null, (LevelAccessor)worldIn, pos, false);
            worldIn.m_46961_(pos, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        InfinityButtonsUtil.tooltip(pTooltip, "falling_button");
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

