/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.button;

import java.util.List;
import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.larsmans.infinitybuttons.block.custom.button.AbstractSmallButton;
import net.larsmans.infinitybuttons.particle.InfinityButtonsParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class DiamondButton
extends AbstractSmallButton {
    private final boolean large;

    public DiamondButton(BlockBehaviour.Properties properties, boolean large) {
        super(false, large, properties);
        this.large = large;
    }

    @Override
    public int getPressDuration() {
        return 20;
    }

    @Override
    protected SoundEvent getSoundEvent(boolean isOn) {
        return isOn ? SoundEvents.f_12444_ : SoundEvents.f_12443_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (DiamondButton.config.diamondParticles && random.m_188503_(3) == 0) {
            if (this.large) {
                block0 : switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
                    case FLOOR: {
                        this.addParticle(3, 10, 2, 1, 3, 10, world, pos, random);
                        break;
                    }
                    case WALL: {
                        switch ((Direction)state.m_61143_((Property)f_54117_)) {
                            case NORTH: {
                                this.addParticle(3, 10, 3, 10, 13, 1, world, pos, random);
                                break block0;
                            }
                            case EAST: {
                                this.addParticle(2, 1, 3, 10, 3, 10, world, pos, random);
                                break block0;
                            }
                            case SOUTH: {
                                this.addParticle(3, 10, 3, 10, 2, 1, world, pos, random);
                                break block0;
                            }
                            case WEST: {
                                this.addParticle(13, 1, 3, 10, 3, 10, world, pos, random);
                            }
                        }
                        break;
                    }
                    case CEILING: {
                        this.addParticle(3, 10, 13, 1, 3, 10, world, pos, random);
                    }
                }
            } else {
                block11 : switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
                    case FLOOR: {
                        switch ((Direction)state.m_61143_((Property)f_54117_)) {
                            case NORTH: 
                            case SOUTH: {
                                this.addParticle(4, 8, 2, 1, 5, 6, world, pos, random);
                                break;
                            }
                            case EAST: 
                            case WEST: {
                                this.addParticle(5, 6, 2, 1, 4, 8, world, pos, random);
                            }
                        }
                        break;
                    }
                    case WALL: {
                        switch ((Direction)state.m_61143_((Property)f_54117_)) {
                            case NORTH: {
                                this.addParticle(4, 8, 5, 6, 13, 1, world, pos, random);
                                break;
                            }
                            case EAST: {
                                this.addParticle(2, 1, 5, 6, 4, 8, world, pos, random);
                                break;
                            }
                            case SOUTH: {
                                this.addParticle(4, 8, 5, 6, 2, 1, world, pos, random);
                                break;
                            }
                            case WEST: {
                                this.addParticle(13, 1, 5, 6, 4, 8, world, pos, random);
                            }
                        }
                        break;
                    }
                    case CEILING: {
                        switch ((Direction)state.m_61143_((Property)f_54117_)) {
                            case NORTH: 
                            case SOUTH: {
                                this.addParticle(4, 8, 13, 1, 5, 6, world, pos, random);
                                break block11;
                            }
                            case EAST: 
                            case WEST: {
                                this.addParticle(5, 6, 13, 1, 4, 8, world, pos, random);
                            }
                        }
                    }
                }
            }
        }
    }

    public void addParticle(int x1, int x2, int y1, int y2, int z1, int z2, Level world, BlockPos pos, RandomSource random) {
        world.m_7106_((ParticleOptions)InfinityButtonsParticleTypes.DIAMOND_SPARKLE.get(), (double)pos.m_123341_() + (double)x1 / 16.0 + (double)random.m_188501_() * (double)x2 / 16.0, (double)pos.m_123342_() + (double)y1 / 16.0 + (double)random.m_188501_() * (double)y2 / 16.0, (double)pos.m_123343_() + (double)z1 / 16.0 + (double)random.m_188501_() * (double)z2 / 16.0, 0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        InfinityButtonsUtil.tooltip(pTooltip, "diamond_button");
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

