/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.button;

import java.util.List;
import javax.annotation.Nullable;
import me.shedaniel.autoconfig.AutoConfig;
import net.larsmans.infinitybuttons.config.InfinityButtonsConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractButton
extends FaceAttachedHorizontalDirectionalBlock {
    protected static InfinityButtonsConfig config = (InfinityButtonsConfig)AutoConfig.getConfigHolder(InfinityButtonsConfig.class).getConfig();
    public static final BooleanProperty PRESSED = BooleanProperty.m_61465_((String)"pressed");
    protected final boolean projectile;

    protected AbstractButton(boolean projectile, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR));
        this.projectile = projectile;
    }

    public abstract int getPressDuration();

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.powerBlock(state, worldIn, pos);
        this.playSound(player, (LevelAccessor)worldIn, pos, true);
        worldIn.m_142346_((Entity)player, GameEvent.f_223702_, pos);
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public void powerBlock(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbors(state, world, pos);
        world.m_186460_(pos, (Block)this, this.getPressDuration());
    }

    protected void playSound(@Nullable Player playerIn, LevelAccessor worldIn, BlockPos pos, boolean pressed) {
        worldIn.m_247517_((Player)(pressed ? playerIn : null), pos, this.getSoundEvent(pressed), SoundSource.BLOCKS);
    }

    protected abstract SoundEvent getSoundEvent(boolean var1);

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.m_60713_(newState.m_60734_())) {
            if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
                this.updateNeighbors(state, worldIn, pos);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)PRESSED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)PRESSED) != false && AbstractButton.m_53200_((BlockState)blockState) == side ? 15 : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            if (this.projectile) {
                this.checkPressed(state, (Level)worldIn, pos);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)), 3);
                this.updateNeighbors(state, (Level)worldIn, pos);
                this.playSound(null, (LevelAccessor)worldIn, pos, false);
                worldIn.m_142346_(null, GameEvent.f_223703_, pos);
            }
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.f_46443_ && this.projectile && !((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            this.checkPressed(state, worldIn, pos);
        }
    }

    private void checkPressed(BlockState state, Level worldIn, BlockPos pos) {
        boolean flag1;
        List list = worldIn.m_45976_(AbstractArrow.class, state.m_60808_((BlockGetter)worldIn, pos).m_83215_().m_82338_(pos));
        boolean flag = !list.isEmpty();
        if (flag != (flag1 = ((Boolean)state.m_61143_((Property)PRESSED)).booleanValue())) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(flag)), 3);
            this.updateNeighbors(state, worldIn, pos);
            this.playSound(null, (LevelAccessor)worldIn, pos, flag);
        }
        if (flag) {
            worldIn.m_186460_(new BlockPos((Vec3i)pos), (Block)this, this.getPressDuration());
        }
    }

    public void updateNeighbors(BlockState state, Level worldIn, BlockPos pos) {
        worldIn.m_46672_(pos, (Block)this);
        worldIn.m_46672_(pos.m_121945_(AbstractButton.m_53200_((BlockState)state).m_122424_()), (Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PRESSED, f_53179_});
    }
}

