/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom;

import java.util.List;
import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class LanternButton
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty PRESSED = BooleanProperty.m_61465_((String)"pressed");
    private static final VoxelShape HANGING_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
    public static final VoxelShape SHAPE_PRESSED = HANGING_AABB.m_83216_(0.0, -0.0625, 0.0);
    private final boolean isLever;
    public final Block jadeBlock;

    public LanternButton(BlockBehaviour.Properties properties, boolean isLever, Block jadeBlock) {
        super(properties);
        this.isLever = isLever;
        this.jadeBlock = jadeBlock;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LanternBlock.f_153460_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)PRESSED) != false ? SHAPE_PRESSED : HANGING_AABB;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        for (Direction direction : ctx.m_6232_()) {
            if (direction != Direction.UP) continue;
            return (BlockState)this.m_49966_().m_61124_((Property)LanternBlock.f_153460_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LanternBlock.f_153460_, PRESSED});
    }

    protected int getPressDuration() {
        return 30;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)LanternBlock.f_153460_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing == Direction.UP && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.isLever) {
            if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
                this.powerOff(state, world, pos);
                this.playSound(player, (LevelAccessor)world, pos, false);
                world.m_142346_((Entity)player, GameEvent.f_223703_, pos);
            } else {
                this.powerOn(state, world, pos);
                this.playSound(player, (LevelAccessor)world, pos, true);
                world.m_142346_((Entity)player, GameEvent.f_223702_, pos);
            }
        } else {
            if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
                return InteractionResult.CONSUME;
            }
            this.powerOn(state, world, pos);
            world.m_186460_(pos, (Block)this, this.getPressDuration());
            this.playSound(player, (LevelAccessor)world, pos, true);
            world.m_142346_((Entity)player, GameEvent.f_223702_, pos);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public void powerOn(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbors(world, pos);
    }

    public void powerOff(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)), 3);
        this.updateNeighbors(world, pos);
    }

    protected void playSound(@javax.annotation.Nullable Player playerIn, LevelAccessor worldIn, BlockPos pos, boolean pressed) {
        worldIn.m_247517_((Player)(pressed ? playerIn : null), pos, this.getSoundEvent(pressed), SoundSource.BLOCKS);
    }

    protected SoundEvent getSoundEvent(boolean pressed) {
        return pressed ? SoundEvents.f_12444_ : SoundEvents.f_12443_;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (isMoving || state.m_60713_(newState.m_60734_())) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            this.updateNeighbors(worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)PRESSED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)PRESSED) != false && side == Direction.DOWN ? 15 : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            return;
        }
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)), 3);
        this.updateNeighbors((Level)worldIn, pos);
        this.playSound(null, (LevelAccessor)worldIn, pos, false);
        worldIn.m_142346_(null, GameEvent.f_223703_, pos);
    }

    public void updateNeighbors(Level world, BlockPos pos) {
        int distance = InfinityButtonsUtil.checkChains(world, pos);
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_6630_(distance), (Block)this);
        world.m_46672_(pos.m_6630_(distance + 1), (Block)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        InfinityButtonsUtil.tooltip(pTooltip, "lantern_button");
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)LanternBlock.f_153460_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return Block.m_49863_((LevelReader)world, (BlockPos)pos.m_121945_(Direction.UP), (Direction)Direction.DOWN);
    }
}

