/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import net.larsmans.infinitybuttons.block.InfinityButtonsBlocks;
import net.larsmans.infinitybuttons.block.custom.emergencybutton.SafeEmergencyButton;
import net.larsmans.infinitybuttons.block.custom.letterbutton.LetterButton;
import net.larsmans.infinitybuttons.config.InfinityButtonsConfig;
import net.larsmans.infinitybuttons.item.custom.SafeEmergencyButtonItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class InfinityButtonsUtil {
    public static final BooleanProperty PRESSED = BooleanProperty.m_61465_((String)"pressed");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final MutableComponent HOLD_SHIFT_TEXT = Component.m_237115_((String)"infinitybuttons.tooltip.hold_shift").m_130940_(ChatFormatting.GRAY);
    public static final MutableComponent SAFE_EMERGENCY_BUTTON_ACTIONBAR_TEXT = Component.m_237115_((String)"infinitybuttons.actionbar.closed_safety_button");
    public static List<SafeEmergencyButtonItem> SAFETY_BUTTONS;
    public static Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK;
    public static Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK;
    public static Supplier<BiMap<Block, Block>> WAX_ON_BY_BLOCK;
    public static Supplier<BiMap<Block, Block>> WAX_OFF_BY_BLOCK;
    public static Supplier<BiMap<Block, Block>> STICKY_ON_BY_BLOCK;
    public static Supplier<BiMap<Block, Block>> STICKY_OFF_BY_BLOCK;

    public static boolean crouchClickOverrides(Block block) {
        return block instanceof SafeEmergencyButton || block instanceof LetterButton;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tooltip(List<Component> tooltip, String name) {
        if (((InfinityButtonsConfig)AutoConfig.getConfigHolder(InfinityButtonsConfig.class).getConfig()).tooltips) {
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)("infinitybuttons.tooltip." + name)).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)HOLD_SHIFT_TEXT);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tooltip(List<Component> tooltip, String name1, String name2) {
        if (((InfinityButtonsConfig)AutoConfig.getConfigHolder(InfinityButtonsConfig.class).getConfig()).tooltips) {
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)("infinitybuttons.tooltip." + name1)).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)("infinitybuttons.tooltip." + name2)).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)HOLD_SHIFT_TEXT);
            }
        }
    }

    public static void buildNext() {
        if (NEXT_BY_BLOCK == null) {
            NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)InfinityButtonsBlocks.COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.EXPOSED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.EXPOSED_COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WEATHERED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WEATHERED_COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.OXIDIZED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.EXPOSED_COPPER_LARGE_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.EXPOSED_COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WEATHERED_COPPER_LARGE_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WEATHERED_COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.OXIDIZED_COPPER_LARGE_BUTTON.get())).build());
            PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());
        }
    }

    public static void buildWax() {
        if (WAX_ON_BY_BLOCK == null) {
            WAX_ON_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)InfinityButtonsBlocks.COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WAXED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.EXPOSED_COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WAXED_EXPOSED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WEATHERED_COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WAXED_WEATHERED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.OXIDIZED_COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WAXED_OXIDIZED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WAXED_COPPER_LARGE_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.EXPOSED_COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WAXED_EXPOSED_COPPER_LARGE_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WEATHERED_COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WAXED_WEATHERED_COPPER_LARGE_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.OXIDIZED_COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.WAXED_OXIDIZED_COPPER_LARGE_BUTTON.get())).build());
            WAX_OFF_BY_BLOCK = Suppliers.memoize(() -> WAX_ON_BY_BLOCK.get().inverse());
        }
    }

    public static void buildSticky() {
        if (STICKY_ON_BY_BLOCK == null) {
            STICKY_ON_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)InfinityButtonsBlocks.WAXED_COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.STICKY_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WAXED_EXPOSED_COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.STICKY_EXPOSED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WAXED_WEATHERED_COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.STICKY_WEATHERED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WAXED_OXIDIZED_COPPER_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.STICKY_OXIDIZED_COPPER_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WAXED_COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.STICKY_COPPER_LARGE_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WAXED_EXPOSED_COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.STICKY_EXPOSED_COPPER_LARGE_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WAXED_WEATHERED_COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.STICKY_WEATHERED_COPPER_LARGE_BUTTON.get())).put((Object)((Block)InfinityButtonsBlocks.WAXED_OXIDIZED_COPPER_LARGE_BUTTON.get()), (Object)((Block)InfinityButtonsBlocks.STICKY_OXIDIZED_COPPER_LARGE_BUTTON.get())).build());
            STICKY_OFF_BY_BLOCK = Suppliers.memoize(() -> STICKY_ON_BY_BLOCK.get().inverse());
        }
    }

    public static void buildSafety() {
        if (SAFETY_BUTTONS == null) {
            SAFETY_BUTTONS = new ArrayList<SafeEmergencyButtonItem>();
            for (RegistryObject entry : InfinityButtonsBlocks.BLOCKS.getEntries()) {
                if (!(entry.get() instanceof SafeEmergencyButton)) continue;
                SAFETY_BUTTONS.add((SafeEmergencyButtonItem)((Block)entry.get()).m_5456_());
            }
        }
    }

    public static int checkChains(Level world, BlockPos pos) {
        int i = 0;
        while (world.m_8055_(pos.m_6630_(i + 1)).m_60734_() instanceof ChainBlock) {
            ++i;
        }
        return i;
    }
}

