/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import org.apache.commons.lang3.StringUtils;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.aspect.ItemAspect;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.data.AspectData;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.ItemProperties;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.TierData;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.module.data.VariantData;
import se.mickelus.tetra.module.schematic.RepairDefinition;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.properties.IToolProvider;

public abstract class ItemModule
implements IToolProvider {
    public static final float repairLevelFactor = 10.0f;
    protected final String slotTagKey;
    protected final String moduleKey;
    protected final String variantTagKey;
    protected VariantData[] variantData = new VariantData[0];
    protected TweakData[] tweaks = new TweakData[0];
    protected Priority renderLayer = Priority.BASE;
    protected Priority namePriority = Priority.BASE;
    protected Priority prefixPriority = Priority.BASE;
    protected boolean perk = false;

    public ItemModule(String slotKey, String moduleKey) {
        this.slotTagKey = slotKey;
        this.moduleKey = moduleKey;
        this.variantTagKey = moduleKey + "_material";
    }

    public static String getName(String moduleKey, String variantKey) {
        String variant;
        if (I18n.m_118936_((String)("tetra.variant." + variantKey))) {
            return I18n.m_118938_((String)("tetra.variant." + variantKey), (Object[])new Object[0]);
        }
        if (I18n.m_118936_((String)("tetra.module." + moduleKey + ".material_name")) && I18n.m_118936_((String)("tetra.material." + (variant = variantKey.substring(variantKey.indexOf(47) + 1)) + ".prefix"))) {
            return StringUtils.capitalize((String)I18n.m_118938_((String)("tetra.module." + moduleKey + ".material_name"), (Object[])new Object[]{I18n.m_118938_((String)("tetra.material." + variant + ".prefix"), (Object[])new Object[0])}).toLowerCase());
        }
        return I18n.m_118938_((String)("tetra.variant." + variantKey), (Object[])new Object[0]);
    }

    public String getKey() {
        return this.moduleKey;
    }

    public String getUnlocalizedName() {
        return this.moduleKey;
    }

    public String getSlot() {
        return this.slotTagKey;
    }

    public void addModule(ItemStack targetStack, String variantKey, Player player) {
        CompoundTag tag = targetStack.m_41784_();
        tag.m_128359_(this.slotTagKey, this.moduleKey);
        tag.m_128359_(this.variantTagKey, variantKey);
    }

    public final ItemStack[] removeModule(ItemStack targetStack) {
        return this.removeModule(targetStack, false);
    }

    public ItemStack[] removeModule(ItemStack targetStack, boolean upgrade) {
        CompoundTag tag = targetStack.m_41784_();
        tag.m_128473_(this.slotTagKey);
        tag.m_128473_(this.variantTagKey);
        return new ItemStack[0];
    }

    public void postRemove(ItemStack targetStack, Player player) {
    }

    public VariantData[] getVariantData() {
        return this.variantData;
    }

    public VariantData getVariantData(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128461_(this.variantTagKey)).map(key -> this.getVariantData((String)key)).orElseGet(this::getDefaultData);
    }

    public VariantData getVariantData(String variantKey) {
        return Arrays.stream(this.variantData).filter(moduleData -> moduleData.key.equals(variantKey)).findAny().orElseGet(this::getDefaultData);
    }

    public ItemProperties getProperties(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.getProperties(this.getTweakStep(itemStack, (TweakData)tweak))).reduce(ItemProperties.merge(new ItemProperties(), this.getVariantData(itemStack)), ItemProperties::merge);
    }

    public VariantData getDefaultData() {
        return this.variantData.length > 0 ? this.variantData[0] : new VariantData();
    }

    public String getName(ItemStack itemStack) {
        String key = this.getVariantData((ItemStack)itemStack).key;
        return ItemModule.getName(this.getUnlocalizedName(), key);
    }

    public String getDescription(ItemStack itemStack) {
        String descriptionKey = "tetra.variant." + this.getVariantData((ItemStack)itemStack).key + ".description";
        if (I18n.m_118936_((String)descriptionKey)) {
            return I18n.m_118938_((String)descriptionKey, (Object[])new Object[0]);
        }
        return I18n.m_118938_((String)("tetra.module." + this.getUnlocalizedName() + ".description"), (Object[])new Object[0]);
    }

    public String getItemName(ItemStack itemStack) {
        String variantItemNameKey = "tetra.variant." + this.getVariantData((ItemStack)itemStack).key + ".item_name";
        if (I18n.m_118936_((String)variantItemNameKey)) {
            return I18n.m_118938_((String)variantItemNameKey, (Object[])new Object[0]);
        }
        String moduleItemNameKey = "tetra.module." + this.getUnlocalizedName() + ".item_name";
        if (I18n.m_118936_((String)moduleItemNameKey)) {
            return I18n.m_118938_((String)moduleItemNameKey, (Object[])new Object[0]);
        }
        return null;
    }

    public Priority getItemNamePriority(ItemStack itemStack) {
        return this.namePriority;
    }

    public String getItemPrefix(ItemStack itemStack) {
        String key = this.getVariantData((ItemStack)itemStack).key;
        String variantPrefixKey = "tetra.variant." + key + ".prefix";
        if (I18n.m_118936_((String)variantPrefixKey)) {
            return I18n.m_118938_((String)variantPrefixKey, (Object[])new Object[0]);
        }
        String modulePrefixKey = "tetra.module." + this.getUnlocalizedName() + ".prefix";
        if (I18n.m_118936_((String)modulePrefixKey)) {
            String prefix = I18n.m_118938_((String)modulePrefixKey, (Object[])new Object[0]);
            if (prefix.startsWith("Format error:")) {
                String variant = key.substring(key.indexOf(47) + 1);
                return StringUtils.capitalize((String)I18n.m_118938_((String)modulePrefixKey, (Object[])new Object[]{I18n.m_118938_((String)("tetra.material." + variant + ".prefix"), (Object[])new Object[0]).toLowerCase()}));
            }
            return prefix;
        }
        return null;
    }

    public Priority getItemPrefixPriority(ItemStack itemStack) {
        return this.prefixPriority;
    }

    public int getIntegrityGain(ItemStack itemStack) {
        return Math.max(this.getProperties((ItemStack)itemStack).integrity, 0);
    }

    public int getIntegrityCost(ItemStack itemStack) {
        return Math.max(this.getProperties((ItemStack)itemStack).integrityUsage, 0);
    }

    public int getMagicCapacity(ItemStack itemStack) {
        return this.getMagicCapacityGain(itemStack) - this.getMagicCapacityCost(itemStack);
    }

    public int getMagicCapacityGain(ItemStack itemStack) {
        int magicCapacity = this.getVariantData((ItemStack)itemStack).magicCapacity;
        if (magicCapacity > 0) {
            float stabilityMultiplier = CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> Float.valueOf(item.getStabilityModifier(itemStack))).orElse(Float.valueOf(1.0f)).floatValue();
            return Math.round((float)magicCapacity * ((Double)ConfigHandler.magicCapacityMultiplier.get()).floatValue() * stabilityMultiplier);
        }
        return 0;
    }

    public int getMagicCapacityCost(ItemStack itemStack) {
        int magicCapacity = this.getVariantData((ItemStack)itemStack).magicCapacity;
        if (magicCapacity < 0) {
            return -magicCapacity;
        }
        return 0;
    }

    public float getDestabilizationChance(ItemStack itemStack, float probabilityMultiplier) {
        return this.getDestabilizationChance(-this.getMagicCapacity(itemStack), this.getMagicCapacityGain(itemStack), probabilityMultiplier);
    }

    public float getDestabilizationChance(int instability, int capacity, float probabilityMultiplier) {
        return capacity > 0 ? Math.max(probabilityMultiplier * (float)instability / (float)capacity, 0.0f) : 0.0f;
    }

    public int getDurability(ItemStack itemStack) {
        return this.getProperties((ItemStack)itemStack).durability;
    }

    public float getDurabilityMultiplier(ItemStack itemStack) {
        return this.getProperties((ItemStack)itemStack).durabilityMultiplier;
    }

    public Collection<RepairDefinition> getRepairDefinitions(ItemStack itemStack) {
        return RepairRegistry.instance.getDefinitions(this.getVariantData((ItemStack)itemStack).key);
    }

    public RepairDefinition getRepairDefinition(ItemStack itemStack, ItemStack materialStack) {
        return RepairRegistry.instance.getDefinitions(this.getVariantData((ItemStack)itemStack).key).stream().filter(definition -> definition.material.isValid()).filter(definition -> definition.material.getPredicate().m_45049_(materialStack)).findFirst().orElse(null);
    }

    public Collection<ToolAction> getRepairRequiredTools(ItemStack itemStack, ItemStack materialStack) {
        return Optional.ofNullable(this.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.requiredTools).map(TierData::getValues).orElseGet(Collections::emptySet);
    }

    public Map<ToolAction, Integer> getRepairRequiredToolLevels(ItemStack itemStack, ItemStack materialStack) {
        return Optional.ofNullable(this.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.requiredTools).map(TierData::getLevelMap).orElseGet(Collections::emptyMap);
    }

    public int getRepairRequiredToolLevel(ItemStack itemStack, ItemStack materialStack, ToolAction tool) {
        return Optional.ofNullable(this.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.requiredTools).map(requiredTools -> requiredTools.getLevel(tool)).orElse(0);
    }

    public int getRepairExperienceCost(ItemStack itemStack, ItemStack materialStack) {
        float result = (float)Optional.ofNullable(this.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.experienceCost).orElse(0).intValue() + Optional.of(Float.valueOf(this.getDestabilizationChance(itemStack, 1.0f))).map(capacity -> Float.valueOf(capacity.floatValue() * 10.0f)).orElse(Float.valueOf(0.0f)).floatValue();
        return Math.max(0, Mth.m_14167_((float)result));
    }

    public boolean isTweakable(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            String variant = itemStack.m_41783_().m_128461_(this.variantTagKey);
            return Arrays.stream(this.tweaks).anyMatch(data -> variant.equals(data.variant));
        }
        return false;
    }

    public TweakData[] getTweaks(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            String variant = itemStack.m_41783_().m_128461_(this.variantTagKey);
            return (TweakData[])Arrays.stream(this.tweaks).filter(tweak -> variant.equals(tweak.variant)).toArray(TweakData[]::new);
        }
        return new TweakData[0];
    }

    public boolean hasTweak(ItemStack itemStack, String tweakKey) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.key).anyMatch(tweakKey::equals);
    }

    public int getTweakStep(ItemStack itemStack, TweakData tweak) {
        return Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128451_(this.slotTagKey + "_tweak:" + tweak.key)).map(step -> Mth.m_14045_((int)step, (int)(-tweak.steps), (int)tweak.steps)).orElse(0);
    }

    public void setTweakStep(ItemStack itemStack, String tweakKey, int step) {
        itemStack.m_41784_().m_128405_(this.slotTagKey + "_tweak:" + tweakKey, step);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.getAttributeModifiers(this.getTweakStep(itemStack, (TweakData)tweak))).filter(Objects::nonNull).reduce(this.getVariantData((ItemStack)itemStack).attributes, AttributeHelper::merge);
    }

    public double getDamageModifier(ItemStack itemStack) {
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> modifiers.get((Object)Attributes.f_22281_)).map(AttributeHelper::getAdditionAmount).orElse(0.0);
    }

    public double getDamageMultiplierModifier(ItemStack itemStack) {
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> modifiers.get((Object)Attributes.f_22281_)).map(AttributeHelper::getMultiplyAmount).orElse(1.0);
    }

    public double getSpeedModifier(ItemStack itemStack) {
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> modifiers.get((Object)Attributes.f_22283_)).map(AttributeHelper::getAdditionAmount).orElse(0.0);
    }

    public double getSpeedMultiplierModifier(ItemStack itemStack) {
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> modifiers.get((Object)Attributes.f_22283_)).map(AttributeHelper::getMultiplyAmount).orElse(1.0);
    }

    public ModuleModel[] getModels(ItemStack itemStack) {
        return this.getVariantData((ItemStack)itemStack).models;
    }

    public Priority getRenderLayer() {
        return this.renderLayer;
    }

    public int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        return Optional.ofNullable(this.getEffectData(itemStack)).map(data -> data.getLevel(effect)).orElse(0);
    }

    public float getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        return Optional.ofNullable(this.getEffectData(itemStack)).map(data -> Float.valueOf(data.getEfficiency(effect))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Collection<ItemEffect> getEffects(ItemStack itemStack) {
        return Optional.ofNullable(this.getEffectData(itemStack)).map(TierData::getValues).orElseGet(Collections::emptySet);
    }

    public EffectData getEffectData(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.getEffectData(this.getTweakStep(itemStack, (TweakData)tweak))).filter(Objects::nonNull).reduce(this.getVariantData((ItemStack)itemStack).effects, EffectData::merge);
    }

    @Override
    public boolean canProvideTools(ItemStack itemStack) {
        return true;
    }

    @Override
    public int getToolLevel(ItemStack itemStack, ToolAction tool) {
        return Optional.ofNullable(this.getToolData(itemStack)).map(data -> data.getLevel(tool)).orElse(0);
    }

    @Override
    public float getToolEfficiency(ItemStack itemStack, ToolAction tool) {
        return Optional.ofNullable(this.getToolData(itemStack)).map(data -> Float.valueOf(data.getEfficiency(tool))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Set<ToolAction> getTools(ItemStack itemStack) {
        return Optional.ofNullable(this.getToolData(itemStack)).map(TierData::getValues).orElseGet(Collections::emptySet);
    }

    @Override
    public Map<ToolAction, Integer> getToolLevels(ItemStack itemStack) {
        return Optional.ofNullable(this.getToolData(itemStack)).map(TierData::getLevelMap).orElseGet(Collections::emptyMap);
    }

    @Override
    public ToolData getToolData(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.getToolData(this.getTweakStep(itemStack, (TweakData)tweak))).filter(Objects::nonNull).reduce(this.getVariantData((ItemStack)itemStack).tools, ToolData::merge);
    }

    public AspectData getAspects(ItemStack itemStack) {
        return this.getVariantData((ItemStack)itemStack).aspects;
    }

    public boolean hasAspect(ItemStack itemStack, ItemAspect aspect) {
        return this.getAspects(itemStack).contains(aspect);
    }
}

