/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.ApplyHitTargetEffectsEvent;
import se.mickelus.tetra.effect.ArmorPenetrationEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.CrushingEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.FocusEffect;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.JankEffect;
import se.mickelus.tetra.effect.LungeEffect;
import se.mickelus.tetra.effect.ReachingEffect;
import se.mickelus.tetra.effect.SeveringEffect;
import se.mickelus.tetra.effect.SkeweringEffect;
import se.mickelus.tetra.effect.StrikingEffect;
import se.mickelus.tetra.effect.StunEffect;
import se.mickelus.tetra.effect.SweepingEffect;
import se.mickelus.tetra.effect.howling.HowlingEffect;
import se.mickelus.tetra.effect.potion.BleedingPotionEffect;
import se.mickelus.tetra.effect.potion.EarthboundPotionEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuiverInventory;
import se.mickelus.tetra.properties.PropertyHelper;

@ParametersAreNonnullByDefault
public class ItemEffectHandler {
    public static ItemEffectHandler instance;

    public ItemEffectHandler() {
        instance = this;
    }

    public static void applyHitEffects(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        int stunLevel;
        int earthbindLevel;
        int severLevel;
        int bleedingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.bleeding);
        if (bleedingLevel > 0 && !MobType.f_21641_.equals(target.m_6336_()) && attacker.m_217043_().m_188501_() < 0.3f) {
            target.m_7292_(new MobEffectInstance((MobEffect)BleedingPotionEffect.instance, 40, bleedingLevel));
        }
        if ((severLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.severing)) > 0) {
            SeveringEffect.perform(itemStack, severLevel, attacker, target);
        }
        if ((earthbindLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.earthbind)) > 0 && (double)attacker.m_217043_().m_188501_() < Math.max(0.1, 0.5 * (1.0 - target.m_20186_() / 128.0))) {
            target.m_7292_(new MobEffectInstance((MobEffect)EarthboundPotionEffect.instance, earthbindLevel * 20, 0, false, true));
            Level level = target.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockState blockState = serverLevel.m_8055_(BlockPos.m_274561_((double)target.m_20185_(), (double)(target.m_20186_() - 1.0), (double)target.m_20189_()));
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), target.m_20185_(), target.m_20186_() + 0.1, target.m_20189_(), 16, 0.0, serverLevel.f_46441_.m_188583_() * 0.2, 0.0, 0.1);
            }
        }
        if ((stunLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.stun)) > 0) {
            StunEffect.perform(itemStack, stunLevel, attacker, target);
        }
        ApplyHitTargetEffectsEvent event = new ApplyHitTargetEffectsEvent(attacker, target, itemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        Optional.ofNullable(event.getAttackingPlayer()).map(LivingEntity::m_21205_).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> itemStack.m_41720_() instanceof IModularItem).ifPresent(itemStack -> {
            int intuitLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.intuit);
            int xp = event.getDroppedExperience();
            if (intuitLevel > 0 && xp > 0) {
                ((IModularItem)itemStack.m_41720_()).tickHoningProgression((LivingEntity)event.getAttackingPlayer(), (ItemStack)itemStack, intuitLevel * xp);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttackEntity(AttackEntityEvent event) {
        if (!event.isCanceled()) {
            ComboPoints.onAttackEntity(event);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (!event.getSource().m_269533_(DamageTypeTags.f_268490_) && event.getEntity().m_21254_()) {
            Optional.ofNullable(event.getEntity()).map(LivingEntity::m_21211_).filter(itemStack -> itemStack.m_41720_() instanceof ItemModularHandheld).ifPresent(itemStack -> {
                Entity patt7077$temp;
                ItemModularHandheld item = (ItemModularHandheld)itemStack.m_41720_();
                LivingEntity blocker = event.getEntity();
                if (UseAnim.BLOCK.equals((Object)itemStack.m_41780_())) {
                    item.applyUsageEffects(blocker, (ItemStack)itemStack, Mth.m_14167_((float)(event.getAmount() / 2.0f)));
                }
                if ((patt7077$temp = event.getSource().m_7640_()) instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)patt7077$temp;
                    if ((float)item.getEffectLevel((ItemStack)itemStack, ItemEffect.blockingReflect) > attacker.m_217043_().m_188501_() * 100.0f) {
                        attacker.m_6469_(event.getEntity().m_269291_().m_269374_((Entity)event.getEntity()), (float)(item.getAbilityBaseDamage((ItemStack)itemStack) * (double)item.getEffectEfficiency((ItemStack)itemStack, ItemEffect.blockingReflect)));
                        ItemEffectHandler.applyHitEffects(itemStack, attacker, blocker);
                        EffectHelper.applyEnchantmentHitEffects(itemStack, attacker, blocker);
                        float knockbackFactor = 0.5f + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)itemStack);
                        attacker.m_147240_((double)(knockbackFactor * 0.5f), blocker.m_20185_() - attacker.m_20185_(), blocker.m_20189_() - attacker.m_20189_());
                    }
                }
            });
        }
        if ("arrow".equals(event.getSource().m_19385_())) {
            CastOptional.cast((Object)event.getSource().m_7639_(), LivingEntity.class).map(shooter -> Stream.of(shooter.m_21205_(), shooter.m_21206_())).orElseGet(Stream::empty).filter(itemStack -> itemStack.m_41720_() instanceof ModularBowItem).findFirst().ifPresent(itemStack -> {
                ModularBowItem item = (ModularBowItem)itemStack.m_41720_();
                item.tickHoningProgression((LivingEntity)event.getSource().m_7639_(), (ItemStack)itemStack, 2);
            });
        }
        RevengeTracker.onAttackEntity(event);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (TickEvent.Phase.START == event.phase) {
            LungeEffect.onPlayerTick(event.player);
            FocusEffect.onPlayerTick(event);
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        HowlingEffect.deflectProjectile(event, event.getProjectile(), event.getRayTraceResult());
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Optional.ofNullable(event.getSource().m_7639_()).filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).map(LivingEntity::m_21205_).filter(itemStack -> itemStack.m_41720_() instanceof IModularItem).ifPresent(itemStack -> {
            int armorPenetrationLevel;
            int quickStrikeLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.quickStrike);
            if (quickStrikeLevel > 0) {
                float maxDamage = (float)((LivingEntity)event.getSource().m_7639_()).m_21051_(Attributes.f_22281_).m_22135_();
                float multiplier = (float)quickStrikeLevel * 0.05f + 0.2f;
                if (event.getAmount() < multiplier * maxDamage) {
                    event.setAmount(multiplier * maxDamage);
                }
            }
            if ((armorPenetrationLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.armorPenetration)) > 0) {
                ArmorPenetrationEffect.onLivingHurt(event, armorPenetrationLevel);
            }
        });
        if (!event.getSource().m_269533_(DamageTypeTags.f_268490_)) {
            Optional.ofNullable(event.getEntity()).map(entity -> Stream.of(entity.m_21205_(), entity.m_21206_())).orElseGet(Stream::empty).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> itemStack.m_41720_() instanceof ItemModularHandheld).forEach(itemStack -> {
                ItemModularHandheld item = (ItemModularHandheld)itemStack.m_41720_();
                if (item.getAttributeValue((ItemStack)itemStack, Attributes.f_22284_) > 0.0 || item.getAttributeValue((ItemStack)itemStack, Attributes.f_22285_) > 0.0) {
                    int reducedAmount = (int)Math.ceil(event.getAmount() - CombatRules.m_19272_((float)event.getAmount(), (float)event.getEntity().m_21230_(), (float)((float)event.getEntity().m_21051_(Attributes.f_22285_).m_22135_())));
                    item.applyUsageEffects(event.getEntity(), (ItemStack)itemStack, reducedAmount);
                    item.applyDamage(reducedAmount, (ItemStack)itemStack, event.getEntity());
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        Optional.ofNullable(event.getSource().m_7639_()).filter(entity -> entity instanceof Player).map(entity -> (LivingEntity)entity).map(LivingEntity::m_21205_).filter(itemStack -> itemStack.m_41720_() instanceof IModularItem).ifPresent(itemStack -> {
            int reachingLevel;
            int skeweringLevel;
            int crushingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.crushing);
            if (crushingLevel > 0) {
                CrushingEffect.onLivingDamage(event, crushingLevel);
            }
            if ((skeweringLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.skewering)) > 0) {
                SkeweringEffect.onLivingDamage(event, skeweringLevel, itemStack);
            }
            if ((reachingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.reaching)) > 0) {
                ReachingEffect.onLivingDamage(event, reachingLevel, EffectHelper.getEffectEfficiency(itemStack, ItemEffect.reaching));
            }
        });
        Optional.ofNullable(event.getEntity()).filter(entity -> entity instanceof Player).ifPresent(player -> FocusEffect.onLivingDamage(event));
        ArmorPenetrationEffect.onLivingDamage(event);
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Entity killer;
        ItemStack itemStack;
        Entity entity2;
        if ("trident".equals(event.getSource().m_19385_()) && (entity2 = event.getSource().m_7640_()) instanceof ThrownModularItemEntity) {
            ThrownModularItemEntity modularEntity = (ThrownModularItemEntity)entity2;
            itemStack = modularEntity.getThrownStack();
            killer = modularEntity.m_19749_();
        } else {
            itemStack = Optional.ofNullable(event.getSource().m_7639_()).filter(entity -> entity instanceof Player).map(entity -> (LivingEntity)entity).map(LivingEntity::m_21205_).filter(stack -> stack.m_41720_() instanceof IModularItem).orElse(null);
            killer = event.getSource().m_7639_();
        }
        if (itemStack != null) {
            int jankLevel;
            Level level = event.getEntity().m_9236_();
            if (!level.f_46443_ && (jankLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.janking)) > 0) {
                JankEffect.jankItemsDelayed((ServerLevel)level, event.getEntity().m_20183_(), jankLevel, EffectHelper.getEffectEfficiency(itemStack, ItemEffect.janking), killer);
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Optional.ofNullable(event.getEntity().m_21124_((MobEffect)EarthboundPotionEffect.instance)).ifPresent(effect -> event.getEntity().m_20256_(event.getEntity().m_20184_().m_82542_(1.0, 0.5, 1.0)));
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent event) {
        Optional.ofNullable(event.getEntity()).map(LivingEntity::m_21205_).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> itemStack.m_41720_() instanceof IModularItem).ifPresent(itemStack -> {
            int critLevel;
            int backstabLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.backstab);
            if (backstabLevel > 0 && event.getTarget() instanceof LivingEntity) {
                Player attacker = event.getEntity();
                LivingEntity target = (LivingEntity)event.getTarget();
                if (180.0f - Math.abs(Math.abs(attacker.f_20885_ - target.f_20885_) % 360.0f - 180.0f) < 60.0f) {
                    event.setDamageModifier(Math.max(1.25f + 0.25f * (float)backstabLevel, event.getDamageModifier()));
                    event.setResult(Event.Result.ALLOW);
                }
            }
            if ((critLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.criticalStrike)) > 0) {
                CritEffect.critEntity(event, itemStack, critLevel);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack itemStack = mc.f_91074_.m_21205_();
        if (event.isAttack() && !event.isCanceled() && itemStack.m_41720_() instanceof ItemModularHandheld && mc.f_91077_ != null && HitResult.Type.MISS.equals((Object)mc.f_91077_.m_6662_())) {
            if (EffectHelper.getEffectLevel(itemStack, ItemEffect.truesweep) > 0) {
                SweepingEffect.triggerTruesweep();
            }
            if (EffectHelper.getEffectLevel(itemStack, ItemEffect.howling) > 0) {
                HowlingEffect.sendPacket();
            }
        }
        if (event.isUseItem()) {
            LungeEffect.onRightClick(mc.f_91074_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKeyInput(InputEvent.Key event) {
        KeyMapping jumpKey = Minecraft.m_91087_().f_91066_.f_92089_;
        if (jumpKey.m_90832_(event.getKey(), event.getScanCode()) && jumpKey.m_90857_()) {
            LungeEffect.onJump(Minecraft.m_91087_().f_91074_);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Optional.of(event.getItemStack()).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> itemStack.m_41720_() instanceof ItemModularHandheld).ifPresent(itemStack -> {
            ItemModularHandheld item = (ItemModularHandheld)itemStack.m_41720_();
            BlockPos pos = event.getPos();
            Level world = event.getLevel();
            BlockState blockState = world.m_8055_(pos);
            Player breakingPlayer = event.getEntity();
            boolean didStrike = StrikingEffect.causeEffect(breakingPlayer, itemStack, item, world, pos, blockState);
            if (didStrike) {
                event.setCanceled(true);
                return;
            }
            if (!event.getLevel().f_46443_) {
                int critLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.criticalStrike);
                if (critLevel > 0 && CritEffect.critBlock(world, breakingPlayer, pos, blockState, itemStack, critLevel)) {
                    event.setCanceled(true);
                }
                if (breakingPlayer.m_36403_(0.5f) > 0.9f) {
                    int howlingLevel;
                    if (EffectHelper.getEffectLevel(itemStack, ItemEffect.truesweep) > 0 && breakingPlayer.m_20096_() && !breakingPlayer.m_20142_()) {
                        SweepingEffect.truesweep(itemStack, (LivingEntity)breakingPlayer, true);
                    }
                    if ((howlingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.howling)) > 0) {
                        HowlingEffect.trigger(itemStack, (LivingEntity)breakingPlayer, howlingLevel);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ExhaustedPotionEffect.onBreakSpeed(event);
        ReachingEffect.onBreakSpeed(event);
    }

    @SubscribeEvent
    public void onEnderTeleport(EntityTeleportEvent event) {
        if (!event.getEntity().m_20193_().f_46443_) {
            AABB aabb = new AABB(event.getTargetX() - 24.0, event.getTargetY() - 24.0, event.getTargetZ() - 24.0, event.getTargetX() + 24.0, event.getTargetY() + 24.0, event.getTargetZ() + 24.0);
            event.getEntity().m_20193_().m_45976_(Player.class, aabb).forEach(player -> {
                double effectProbability;
                int reverbLevel = PropertyHelper.getPlayerEffectLevel(player, ItemEffect.enderReverb);
                if (reverbLevel > 0 && !player.m_7500_() && (effectProbability = (double)PropertyHelper.getPlayerEffectEfficiency(player, ItemEffect.enderReverb)) > 0.0 && player.m_217043_().m_188500_() < effectProbability * 2.0) {
                    player.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 40 * reverbLevel));
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onArrowNock(ArrowNockEvent event) {
        ItemStack itemStack;
        Player player = event.getEntity();
        if (!event.hasAmmo() && player.m_21120_(InteractionHand.OFF_HAND).m_41619_() && !(itemStack = ToolbeltHelper.findToolbelt(player)).m_41619_()) {
            QuiverInventory inventory = new QuiverInventory(itemStack);
            List<Collection<ItemEffect>> effects = inventory.getSlotEffects();
            int count = CastOptional.cast((Object)event.getBow().m_41720_(), IModularItem.class).map(item -> EffectHelper.getEffectLevel(event.getBow(), ItemEffect.multishot)).filter(level -> level > 0).orElse(1);
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (!effects.get(i).contains(ItemEffect.quickAccess) || inventory.m_8020_(i).m_41619_()) continue;
                player.m_21008_(InteractionHand.OFF_HAND, inventory.m_8020_(i).m_41620_(count));
                player.m_6672_(event.getHand());
                inventory.m_6596_();
                event.setAction(new InteractionResultHolder(InteractionResult.SUCCESS, (Object)event.getBow()));
                return;
            }
        }
    }
}

