/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.holo;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.blocks.holo.HolosphereBlockEntity;
import se.mickelus.tetra.util.Lherper;

public class HolosphereEntityRenderer
implements BlockEntityRenderer<HolosphereBlockEntity> {
    public static final Material material = new Material(TextureAtlas.f_118259_, new ResourceLocation("tetra", "block/holosphere_hud"));
    private final BlockEntityRenderDispatcher dispatcher;
    private final Font font;

    public HolosphereEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.dispatcher = context.m_173581_();
        this.font = context.m_173586_();
    }

    public void render(HolosphereBlockEntity entity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        long timestamp = entity.getScanModeTimestamp();
        Level level = entity.m_58904_();
        if (timestamp == 0L || timestamp < 0L && level.m_46467_() + timestamp > 20L) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        ChunkPos chunkPos = new ChunkPos(pos);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.0, 0.5);
        matrixStack.m_85849_();
        int light = this.getLightColor(entity.m_58904_(), entity.m_58899_());
        double angle = RotationHelper.getHorizontalAngle((Vec3)Minecraft.m_91087_().m_91288_().m_20299_(partialTicks), (Vec3)Vec3.m_82512_((Vec3i)entity.m_58899_()));
        Quaternionf rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)(angle / Math.PI * 180.0)));
        VertexConsumer vertexBuilder = material.m_119194_(buffer, RenderType::m_110473_);
        this.renderBackdrop(vertexBuilder, matrixStack, rotation, light, (float)level.m_46467_() + partialTicks, timestamp);
        entity.getScanResults().stream().filter(scan -> scan.timestamp() <= level.m_46467_()).forEach(scan -> {
            int x = scan.chunkX() - chunkPos.f_45578_;
            int z = scan.chunkZ() - chunkPos.f_45579_;
            long openTimestamp = timestamp + (long)(Math.abs(x) + Math.abs(z));
            this.renderMarker(vertexBuilder, matrixStack, material.m_119204_(), rotation, (float)level.m_46467_() + partialTicks, openTimestamp, light, 0.5f + (float)(x * 1) / 16.0f, 0.0f, 0.5f + (float)(z * 1) / 16.0f, (HolosphereBlockEntity.ScanResult)scan);
        });
    }

    public void renderBackdrop(VertexConsumer consumer, PoseStack poseStack, Quaternionf rotation, int light, float time, long openTimestamp) {
        float animSlow2;
        float animFast = openTimestamp > 0L ? Lherper.easeOut(Mth.m_184631_((float)(time - (float)openTimestamp), (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f)) : Lherper.easeOut(Lherper.easeOut(Mth.m_184631_((float)(time + (float)openTimestamp - 2.0f), (float)0.0f, (float)5.0f, (float)1.0f, (float)0.0f)));
        float animSlow = openTimestamp > 0L ? Lherper.easeOut(Lherper.easeOut(Mth.m_184631_((float)(time - (float)openTimestamp - 5.0f), (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f))) : Lherper.easeOut(Mth.m_184631_((float)(time + (float)openTimestamp), (float)0.0f, (float)5.0f, (float)1.0f, (float)0.0f));
        float f = animSlow2 = openTimestamp > 0L ? Lherper.easeOut(Lherper.easeOut(Mth.m_184631_((float)(time - (float)openTimestamp - 10.0f), (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f))) : Lherper.easeOut(Mth.m_184631_((float)(time + (float)openTimestamp), (float)0.0f, (float)5.0f, (float)1.0f, (float)0.0f));
        if (animFast > 0.0f) {
            this.drawQuad(consumer, poseStack, rotation, material.m_119204_(), light, 1.0f, animFast * 16.0f, 6, 0, 0.5f, 0.96875f, 0.5f, 0xFFFFFF, animFast, -0.0025f, 1.0f);
        }
        if (animSlow > 0.0f) {
            this.drawQuad(consumer, poseStack, rotation, material.m_119204_(), light, 1.0f, 1.0f, 5, 0, 0.5f, (6.5f - animSlow * 0.5f) / 16.0f, 0.5f, 0xFFFFFF, animSlow, -0.0025f, 1.0f);
            this.drawQuad(consumer, poseStack, rotation, material.m_119204_(), light, 1.0f, 1.0f, 5, 0, 0.5f, (24.5f + animSlow * 0.5f) / 16.0f, 0.5f, 0xFFFFFF, animSlow, -0.0025f, 1.0f);
        }
        if (animSlow2 > 0.0f) {
            float offset = (20.0f + animSlow2 * 1.0f) / 16.0f;
            Quaternionf up = Axis.f_252392_.m_252977_(45.0f);
            up.mul((Quaternionfc)Axis.f_252495_.m_252977_(90.0f));
            this.drawQuad(consumer, poseStack, up, material.m_119204_(), light, 3.0f, 3.0f, 2, 3, offset + 0.5f, (4.5f + animSlow2 * 1.5f) / 16.0f, 0.5f, 0xFFFFFF, animSlow2, 0.0f, 1.0f);
            this.drawQuad(consumer, poseStack, up, material.m_119204_(), light, 3.0f, 3.0f, 2, 9, 0.5f - offset, (4.5f + animSlow2 * 1.5f) / 16.0f, 0.5f, 0xFFFFFF, animSlow2, 0.0f, 1.0f);
            this.drawQuad(consumer, poseStack, up, material.m_119204_(), light, 3.0f, 3.0f, 2, 6, 0.5f, (4.5f + animSlow2 * 1.5f) / 16.0f, offset + 0.5f, 0xFFFFFF, animSlow2, 0.0f, 1.0f);
            this.drawQuad(consumer, poseStack, up, material.m_119204_(), light, 3.0f, 3.0f, 2, 0, 0.5f, (4.5f + animSlow2 * 1.5f) / 16.0f, 0.5f - offset, 0xFFFFFF, animSlow2, 0.0f, 1.0f);
        }
    }

    public void renderMarker(VertexConsumer consumer, PoseStack poseStack, TextureAtlasSprite sprite, Quaternionf rotation, float time, long openTimestamp, int light, float x, float y, float z, HolosphereBlockEntity.ScanResult scan) {
        float anim = this.calculateMarkerAnimation(time, openTimestamp, scan.timestamp());
        if (openTimestamp == 0L || anim == 0.0f) {
            return;
        }
        double height = scan.height();
        float ry = -0.1f + anim * (0.1f + (float)((double)0.005f * height));
        int color = scan.structures().isEmpty() ? Lherper.lerpColors(Mth.m_184631_((float)(scan.temperature() / 3.0f), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f), 12961023, 12779476, 16515017, 16763837) : 15882800;
        color = Lherper.lerpColors((float)Mth.m_144851_((double)height, (double)40.0, (double)140.0, (double)0.5, (double)1.0), 0, color);
        float opacity = 0.9f * anim;
        this.drawQuad(consumer, poseStack, rotation, sprite, light, 1.0f, 4.0f, 7, 0, x, ry - 0.01f, z, 0, opacity * 0.3f, -0.001f, 1.125f);
        this.drawQuad(consumer, poseStack, rotation, sprite, light, 1.0f, 4.0f, 7, 0, x, ry, z, color, opacity);
        if (!scan.structures().isEmpty()) {
            float cut = Mth.m_14036_((float)(ry - 0.28125f), (float)0.0f, (float)2.0f) * 16.0f;
            float sh = 16.0f - cut;
            if (sh > 0.0f) {
                this.drawQuad(consumer, poseStack, rotation, material.m_119204_(), light, 1.0f, sh, 6, 0, x, 1.0f + ((16.0f - sh) / 2.0f - 0.5f) / 16.0f, z, 15882800, anim, -0.002f, 1.0f);
            }
            if (cut < 18.0f) {
                this.drawQuad(consumer, poseStack, rotation, material.m_119204_(), light, 1.0f, 1.0f, 5, 0, x, 1.5625f, z, 0, anim, -0.003f, 1.125f);
                this.drawQuad(consumer, poseStack, rotation, material.m_119204_(), light, 1.0f, 1.0f, 5, 0, x, 1.5625f, z, 15882800, anim, -0.002f, 1.0f);
            }
        }
    }

    private float calculateMarkerAnimation(float time, long openTimestamp, long scanTimestamp) {
        if (time - (float)scanTimestamp < 5.0f) {
            return Lherper.easeOut(Mth.m_184631_((float)(time - (float)scanTimestamp), (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f));
        }
        return openTimestamp > 0L ? Lherper.easeOut(Mth.m_184631_((float)(time - (float)openTimestamp), (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f)) : Lherper.easeOut(Lherper.easeOut(Mth.m_184631_((float)(time + (float)openTimestamp - 20.0f), (float)0.0f, (float)5.0f, (float)1.0f, (float)0.0f)));
    }

    private void drawQuad(VertexConsumer consumer, PoseStack poseStack, Quaternionf rotation, TextureAtlasSprite sprite, int light, float width, float height, int u, int v, float x, float y, float z, int color, float a) {
        this.drawQuad(consumer, poseStack, rotation, sprite, light, width, height, u, v, x, y, z, color, a, 0.0f, 1.0f);
    }

    private void drawQuad(VertexConsumer consumer, PoseStack poseStack, Quaternionf rotation, TextureAtlasSprite sprite, int light, float width, float height, int u, int v, float x, float y, float z, int color, float a, float zIndex, float scale) {
        float spriteWidth = sprite.m_245424_().m_246492_();
        float spriteHeight = sprite.m_245424_().m_245330_();
        float voxelSize = 1.0f / Math.max(spriteWidth, spriteHeight) * scale;
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix3f normal = pose.m_252943_();
        Matrix4f matrix4f = pose.m_252922_();
        Vector3f[] matrix = new Vector3f[]{new Vector3f(-0.5f * width, -0.5f * height, zIndex), new Vector3f(-0.5f * width, 0.5f * height, zIndex), new Vector3f(0.5f * width, 0.5f * height, zIndex), new Vector3f(0.5f * width, -0.5f * height, zIndex)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = matrix[i];
            rotation.transform(vector3f);
            vector3f.mul(voxelSize);
            vector3f.add(x, y, z);
        }
        consumer.m_252986_(matrix4f, matrix[0].x(), matrix[0].y(), matrix[0].z()).m_85950_(r, g, b, a).m_7421_((float)u / spriteWidth, ((float)v + height) / spriteHeight).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4f, matrix[1].x(), matrix[1].y(), matrix[1].z()).m_85950_(r, g, b, a).m_7421_((float)u / spriteWidth, (float)v / spriteHeight).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4f, matrix[2].x(), matrix[2].y(), matrix[2].z()).m_85950_(r, g, b, a).m_7421_(((float)u + width) / spriteWidth, (float)v / spriteHeight).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4f, matrix[3].x(), matrix[3].y(), matrix[3].z()).m_85950_(r, g, b, a).m_7421_(((float)u + width) / spriteWidth, ((float)v + height) / spriteHeight).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private int getLightColor(Level level, BlockPos pos) {
        return 0xF000F0;
    }

    private void drawLabel(String label, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85841_(-0.0125f, -0.0125f, 0.0125f);
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        float x = (float)(-this.font.m_92895_(label)) / 2.0f;
        this.font.m_272078_(label, x + 1.0f, 0.0f, 0, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight, false);
        this.font.m_272078_(label, x - 1.0f, 0.0f, 0, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight, false);
        this.font.m_272078_(label, x, -1.0f, 0, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight, false);
        this.font.m_272078_(label, x, 1.0f, 0, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight, false);
        matrixStack.m_252880_(0.0f, 0.0f, -0.0125f);
        this.font.m_272078_(label, x, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight, false);
    }
}

